/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.config;

import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.AbstractConfigUtil;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureConfig
extends AbstractConfigUtil {
    private final Storage storage = new Storage();
    private final ForgeConfigSpec.Builder builder;
    @Nullable
    private ForgeConfigSpec.IntValue probability;
    @Nullable
    private ForgeConfigSpec.IntValue spacing;
    @Nullable
    private ForgeConfigSpec.IntValue offset;
    @Nullable
    private ForgeConfigSpec.ConfigValue<List<? extends String>> validDimensions;
    @Nullable
    private ForgeConfigSpec.BooleanValue isWhitelist;
    @Nullable
    private ForgeConfigSpec.ConfigValue<List<? extends String>> biomes;
    private Map<MobCategory, ForgeConfigSpec.ConfigValue<List<? extends String>>> spawnConfigs = new HashMap<MobCategory, ForgeConfigSpec.ConfigValue<List<? extends String>>>();

    public StructureConfig(ForgeConfigSpec.Builder builder, String name) {
        super(name);
        this.builder = builder;
    }

    public StructureConfig(ForgeConfigSpec.Builder builder, String name, int probability, int spacing, int offset) {
        this(builder, name);
        this.probability(probability).spacing(spacing).offset(offset);
    }

    public StructureConfig probability(int probability) {
        this.probability = this.builder.comment(this.configComment("Percent chance of generating in an allowed chunk.", probability)).defineInRange(this.name + ".probability", probability, 0, 100);
        return this;
    }

    public StructureConfig spacing(int spacing) {
        this.spacing = this.builder.comment(this.configComment("The average distance between structures of this type, measured in chunks.", spacing)).defineInRange(this.name + ".spacing", spacing, 1, Integer.MAX_VALUE);
        return this;
    }

    public StructureConfig offset(int offset) {
        this.offset = this.builder.comment(this.configComment("A random offset applied to spacing. Values closer to 0 produce a grid effect while values closer to spacing are more random.", offset)).defineInRange(this.name + ".offset", offset, 0, Integer.MAX_VALUE);
        return this;
    }

    public StructureConfig biomes(boolean isWhitelist, String ... biomes) {
        return this.biomes(isWhitelist, Arrays.asList(biomes));
    }

    public StructureConfig biomes(boolean isWhitelist, List<? extends String> biomes) {
        this.biomes = this.builder.comment(this.configComment("A filter for which biomes this structure should generate in. Works with the biome dictionary using # (#structure_gel:overworld) and \"not\" statements using ! (!minecraft:plains). These can be combined (!#nether). Operates in the order typed.", biomes, "[\"#forge:forest\", \"!minecraft:flower_forest\"] This will add all forests in the biome dictionary and then remove the flower forest.")).defineList(this.name + ".biomes", biomes, o -> true);
        this.isWhitelist = this.builder.comment(this.configComment("How the biomes list should be used. true = whitelist, false = blacklist.", isWhitelist)).define(this.name + ".is_whitelist", isWhitelist);
        return this;
    }

    public StructureConfig spawns(MobCategory category, String ... spawns) {
        return this.spawns(category, Arrays.asList(spawns));
    }

    public StructureConfig spawns(MobCategory category, List<? extends String> spawns) {
        this.spawnConfigs.put(category, (ForgeConfigSpec.ConfigValue<List<? extends String>>)this.builder.defineList(this.name + ".spawns." + category.m_21607_(), spawns, o -> true));
        return this;
    }

    public StructureConfig spawns(Map<MobCategory, List<? extends String>> spawns) {
        for (MobCategory category : MobCategory.values()) {
            List<? extends String> spawnList = spawns.get(category);
            if (spawnList == null) continue;
            this.spawns(category, spawnList);
        }
        return this;
    }

    public StructureConfig validDimensions(String ... dimensions) {
        return this.validDimensions(Arrays.asList(dimensions));
    }

    public StructureConfig validDimensions(List<? extends String> dimensions) {
        this.validDimensions = this.builder.comment(this.configComment("What dimensions should this structure be placed in. Type [\"allow_all\"] to allow all dimensions", dimensions, "[\"minecraft:overworld\", \"some_mod:cool_dimension\"]")).defineList(this.name + ".valid_dimensions", dimensions, o -> true);
        return this;
    }

    public float getProbability() {
        return this.storage.probability;
    }

    public int getSpacing() {
        return this.storage.spacing;
    }

    public int getOffset() {
        return this.storage.offset;
    }

    public boolean isWhitelist() {
        return this.storage.isWhitelist;
    }

    public List<ResourceLocation> getBiomes() {
        return this.storage.biomesList;
    }

    @Nullable
    private List<? extends String> getSpawnConfig(MobCategory category) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> config = this.spawnConfigs.get(category);
        return config != null ? (List)config.get() : null;
    }

    public List<MobSpawnSettings.SpawnerData> getSpawnsForClassification(MobCategory category) {
        return this.getSpawnsMap().getOrDefault(category, new ArrayList());
    }

    public Map<MobCategory, List<MobSpawnSettings.SpawnerData>> getSpawnsMap() {
        return this.storage.spawnsMap;
    }

    @Nullable
    public Set<ResourceLocation> getValidDimensions() {
        return this.storage.validDimensions;
    }

    @Override
    protected void reload() {
        Map<MobCategory, List<MobSpawnSettings.SpawnerData>> spawnsMap;
        StructureGelMod.debug("Config for {}:", this.name);
        if (this.probability != null) {
            this.storage.probability = (float)((Integer)this.probability.get()).intValue() / 100.0f;
        }
        if (this.spacing != null) {
            this.storage.spacing = (Integer)this.spacing.get();
        }
        this.storage.offset = this.offset != null ? (Integer)this.offset.get() : Math.max(this.storage.spacing - 2, 0);
        if (SGConfig.COMMON.consoleDebug()) {
            StructureGelMod.log("  Spacing: " + this.storage.spacing, new Object[0]);
            StructureGelMod.log("  Offset: " + this.storage.offset, new Object[0]);
            StructureGelMod.log("  Probability: " + this.storage.probability * 100.0f + "%", new Object[0]);
        }
        if (this.validDimensions != null) {
            this.storage.validDimensions = this.parseValidDimensions((List)this.validDimensions.get());
            if (SGConfig.COMMON.consoleDebug()) {
                StructureGelMod.log("  Dimensions:", new Object[0]);
                if (this.storage.validDimensions == null) {
                    StructureGelMod.log("    All dimensions are allowed", new Object[0]);
                } else {
                    for (ResourceLocation dim : this.storage.validDimensions) {
                        StructureGelMod.log("    " + dim, new Object[0]);
                    }
                }
            }
        }
        if (this.isWhitelist != null) {
            this.storage.isWhitelist = (Boolean)this.isWhitelist.get();
        }
        this.reloadBiomes();
        this.storage.spawnsMap = (Map)Util.m_137469_(new HashMap(), map -> {
            for (MobCategory category : MobCategory.values()) {
                List<? extends String> config = this.getSpawnConfig(category);
                if (config == null) continue;
                map.put(category, this.parseSpawns(config));
            }
        });
        if (SGConfig.COMMON.consoleDebug() && !(spawnsMap = this.storage.spawnsMap).isEmpty()) {
            StructureGelMod.log("  Spawns:", new Object[0]);
            for (Map.Entry<MobCategory, List<MobSpawnSettings.SpawnerData>> entry : spawnsMap.entrySet()) {
                StructureGelMod.log("    " + entry.getKey().m_21607_(), new Object[0]);
                for (MobSpawnSettings.SpawnerData data : entry.getValue()) {
                    StructureGelMod.log("      " + data, new Object[0]);
                }
            }
        }
    }

    @Internal
    public void reloadBiomes() {
        if (this.biomes != null) {
            this.storage.biomesList = this.parseBiomes((List)this.biomes.get());
            if (SGConfig.COMMON.consoleDebug()) {
                StructureGelMod.log("  Biome Filter:", new Object[0]);
                StructureGelMod.log("    Whitelist: " + this.storage.isWhitelist, new Object[0]);
                StructureGelMod.log("    {} Biomes:", this.storage.isWhitelist ? "Allowed" : "Restricted");
                for (ResourceLocation biome : this.storage.biomesList) {
                    StructureGelMod.log("      " + biome, new Object[0]);
                }
            }
        }
    }

    public boolean isBiomeAllowed(ResourceLocation biome) {
        return this.getBiomes().contains(biome) == this.isWhitelist();
    }

    private List<ResourceLocation> parseBiomes(List<? extends String> biomeConfig) {
        ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        if (!biomeConfig.isEmpty()) {
            biomeConfig.stream().forEach(s -> {
                boolean not = s.startsWith("!");
                boolean isTag = s.replace("!", "").startsWith("#");
                String biomeString = s.replace("!", "").replace("#", "");
                try {
                    ResourceLocation value = new ResourceLocation(biomeString);
                    if (!isTag) {
                        StructureConfig.updateBiomeList(biomes, value, not);
                    } else {
                        BiomeType type = BiomeDictionary.REGISTRY.get(value);
                        if (type != null) {
                            type.getAllBiomes().forEach(b -> StructureConfig.updateBiomeList(biomes, b.m_135782_(), not));
                        }
                    }
                }
                catch (ResourceLocationException e) {
                    String string = isTag ? "#mod_namespace:biome_dictionary_entry" : "mod_namespace:biome";
                    this.logResourceLocationError((String)s, "It should be formatted as \"" + string + "\"");
                }
            });
        }
        return biomes;
    }

    private static void updateBiomeList(List<ResourceLocation> biomes, ResourceLocation biome, boolean not) {
        if (not) {
            biomes.remove(biome);
        } else if (!biomes.contains(biome)) {
            biomes.add(biome);
        }
    }

    private List<MobSpawnSettings.SpawnerData> parseSpawns(List<? extends String> spawnsConfig) {
        ArrayList<MobSpawnSettings.SpawnerData> spawns = new ArrayList<MobSpawnSettings.SpawnerData>();
        spawnsConfig.stream().forEach(key -> {
            block6: {
                try {
                    Matcher matcher = Pattern.compile("\\(([a-z0-9/_:[-][.]]*),\\s*([0-9]*),\\s*([0-9]*),\\s*([0-9*])\\)").matcher((CharSequence)key);
                    if (matcher.matches()) {
                        try {
                            EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(matcher.group(1)));
                            if (entity != null) {
                                spawns.add(new MobSpawnSettings.SpawnerData(entity, Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4))));
                            }
                            break block6;
                        }
                        catch (ResourceLocationException e) {
                            this.logResourceLocationError((String)key, "It should be formatted as \"mod_namespace:entity\"");
                        }
                        break block6;
                    }
                    throw new IllegalArgumentException(key + " was not formatted correctly. It should be \"(entity_id, weight, min_count, max_count)\"\n Example: \"(minecraft:creeper, 1, 2, 4)\" will spawn between 2 and 4 creepers with a weight of 1.");
                }
                catch (Exception e) {
                    StructureGelMod.logError("Failed to load the mob spawn config for a structure.", e);
                }
            }
        });
        return spawns;
    }

    @Nullable
    private Set<ResourceLocation> parseValidDimensions(@Nullable List<? extends String> dimensionNames) {
        if (dimensionNames == null || dimensionNames.size() > 0 && dimensionNames.get(0).equals("allow_all")) {
            return null;
        }
        HashSet<ResourceLocation> dimensions = new HashSet<ResourceLocation>();
        dimensionNames.stream().forEach(s -> {
            try {
                dimensions.add(new ResourceLocation(s));
            }
            catch (ResourceLocationException e) {
                this.logResourceLocationError((String)s, "It should be formatted as \"mod_namespace:dimension_id\"");
            }
        });
        return dimensions;
    }

    private static class Storage {
        private float probability = 1.0f;
        private int spacing = 16;
        private int offset = Math.max(this.spacing - 2, 0);
        @Nullable
        private Set<ResourceLocation> validDimensions = null;
        private boolean isWhitelist = true;
        private List<ResourceLocation> biomesList = new ArrayList<ResourceLocation>();
        private Map<MobCategory, List<MobSpawnSettings.SpawnerData>> spawnsMap = new HashMap<MobCategory, List<MobSpawnSettings.SpawnerData>>();

        private Storage() {
        }
    }
}

