/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.biome_dictionary;

import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.registry.registrar.BiomeRegistrar;
import com.legacy.structure_gel.core.StructureGelMod;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeType {
    private ResourceLocation registryName = BiomeDictionary.EMPTY_NAME;
    private Set<ResourceLocation> biomes = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> parents = new HashSet<ResourceLocation>();

    public BiomeType(ResourceLocation registryName, Set<ResourceLocation> parents, Set<ResourceLocation> biomes) {
        if (registryName != null) {
            this.registryName = registryName;
        }
        if (parents != null) {
            this.parents = new HashSet<ResourceLocation>(parents);
        }
        if (biomes != null) {
            this.biomes = new HashSet<ResourceLocation>(biomes);
        }
    }

    public static BiomeType create(ResourceLocation registryName) {
        return new BiomeType(registryName, null, null);
    }

    protected static BiomeType create(String registryName) {
        return BiomeType.create(StructureGelMod.locate(registryName));
    }

    public BiomeType biomes(ResourceKey<Biome> ... biomes) {
        return this.biomes(Arrays.asList(biomes).stream().map(ResourceKey::m_135782_).collect(Collectors.toSet()));
    }

    public BiomeType biomes(Biome ... biomes) {
        return this.biomes(Arrays.asList(biomes).stream().map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toSet()));
    }

    public BiomeType biomes(ResourceLocation ... biomes) {
        return this.biomes(Arrays.asList(biomes).stream().collect(Collectors.toSet()));
    }

    public BiomeType biomes(BiomeRegistrar ... biomes) {
        return this.biomes(Arrays.asList(biomes).stream().map(BiomeRegistrar::getName).collect(Collectors.toSet()));
    }

    public BiomeType biomes(String modid, String ... biomes) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String biome : biomes) {
            set.add(new ResourceLocation(modid, biome));
        }
        return this.biomes(set);
    }

    public BiomeType biomes(Collection<ResourceLocation> biomes) {
        this.getBiomes().addAll(biomes);
        return this;
    }

    public BiomeType biome(ResourceKey<Biome> biome) {
        return this.biome(biome.m_135782_());
    }

    public BiomeType biome(Biome biome) {
        return this.biome(biome.getRegistryName());
    }

    public BiomeType biome(BiomeRegistrar biome) {
        return this.biome(biome.getName());
    }

    public BiomeType biome(ResourceLocation biome) {
        this.getBiomes().add(biome);
        return this;
    }

    public Set<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    public BiomeType setBiomes(Collection<ResourceLocation> biomes) {
        this.biomes = new HashSet<ResourceLocation>(biomes);
        return this;
    }

    public BiomeType parents(ResourceLocation ... parents) {
        return this.parents(new HashSet<ResourceLocation>(Arrays.asList(parents)));
    }

    public BiomeType parents(BiomeType ... parents) {
        return this.parents(Arrays.asList(parents).stream().map(BiomeType::getRegistryName).collect(Collectors.toSet()));
    }

    public BiomeType parents(Collection<ResourceLocation> parents) {
        this.getParents().addAll(parents);
        return this;
    }

    public BiomeType parent(ResourceLocation parent) {
        this.getParents().add(parent);
        return this;
    }

    public Set<ResourceLocation> getParents() {
        return this.parents;
    }

    public BiomeType setParents(Collection<ResourceLocation> parents) {
        this.parents = new HashSet<ResourceLocation>(parents);
        return this;
    }

    public Set<ResourceKey<Biome>> getAllBiomes() {
        Set<ResourceKey<Biome>> biomes = this.getBiomes().stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).containsKey(arg_0)).map(name -> ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)name)).collect(Collectors.toSet());
        for (ResourceLocation parent : this.getParents()) {
            BiomeType parentType = BiomeDictionary.REGISTRY.get(parent);
            if (parentType == null) continue;
            biomes.addAll(parentType.getAllBiomes());
        }
        return biomes;
    }

    public boolean contains(ResourceKey<Biome> key) {
        return this.contains(key.m_135782_());
    }

    public boolean contains(Biome biome) {
        return this.contains(biome.getRegistryName());
    }

    public boolean contains(ResourceLocation key) {
        return this.getAllBiomes().stream().anyMatch(registryKey -> registryKey.m_135782_().equals((Object)key));
    }

    public boolean equals(Object obj) {
        BiomeType type;
        return obj == this || obj instanceof BiomeType && (type = (BiomeType)obj).getRegistryName() != null && this.getRegistryName() != null && type.getRegistryName().equals((Object)this.getRegistryName());
    }

    public String toString() {
        String parents = String.join((CharSequence)", ", this.getParents().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList()));
        String biomes = String.join((CharSequence)", ", this.getBiomes().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList()));
        return String.format("name = %s, parents = [%s], biomes = [%s]", this.getRegistryName().toString(), parents, biomes);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public BiomeType setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public Class<BiomeType> getRegistryType() {
        return BiomeType.class;
    }
}

