/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import com.google.common.collect.ImmutableList;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.Lazy;

public class ModUtil {
    public static final BlockPos VEC_ZERO = new BlockPos(0, 0, 0);
    public static final BlockPos VEC_ONE = new BlockPos(1, 1, 1);
    public static final BlockPos VEC_TWO = new BlockPos(2, 2, 2);
    public static final BlockPos CHUNK_SIZE = new BlockPos(16, 16, 16);
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Lazy<Boolean> IS_DEVELOPER_WORKSPACE = Lazy.concurrentOf(() -> {
        String target = System.getenv().get("target");
        if (target == null) {
            return false;
        }
        return target.contains("userdev");
    });
    public static final float FULLY_SMOOTHABLE = 1.0f;
    public static final float NOT_SMOOTHABLE = -1.0f;

    public static ImmutableList<BlockState> getStates(Block block) {
        return block.m_49965_().m_61056_();
    }

    public static int length(BlockPos size) {
        return size.m_123341_() * size.m_123342_() * size.m_123343_();
    }

    public static void traverseArea(Vec3i startInclusive, Vec3i endInclusive, BlockPos.MutableBlockPos currentPosition, LevelReader world, Traverser func) {
        ModUtil.traverseArea(startInclusive.m_123341_(), startInclusive.m_123342_(), startInclusive.m_123343_(), endInclusive.m_123341_(), endInclusive.m_123342_(), endInclusive.m_123343_(), currentPosition, world, func);
    }

    public static void traverseArea(int startXInclusive, int startYInclusive, int startZInclusive, int endXInclusive, int endYInclusive, int endZInclusive, BlockPos.MutableBlockPos currentPosition, LevelReader world, Traverser func) {
        BlockState air = Blocks.f_50016_.m_49966_();
        int endXPlus1 = endXInclusive + 1;
        int endYPlus1 = endYInclusive + 1;
        int endZPlus1 = endZInclusive + 1;
        int maxX = endXInclusive + 16 & 0xFFFFFFF0;
        int maxY = endYInclusive + 16 & 0xFFFFFFF0;
        int maxZ = endZInclusive + 16 & 0xFFFFFFF0;
        int width = endXPlus1 - startXInclusive;
        int height = endYPlus1 - startYInclusive;
        int widthMulHeight = width * height;
        for (int blockChunkZ = startZInclusive; blockChunkZ < maxZ; blockChunkZ += 16) {
            int maskedBlockChunkZ = blockChunkZ & 0xFFFFFFF0;
            int maskedNextBlockChunkZ = blockChunkZ + 16 & 0xFFFFFFF0;
            for (int blockChunkX = startXInclusive; blockChunkX < maxX; blockChunkX += 16) {
                int maskedBlockChunkX = blockChunkX & 0xFFFFFFF0;
                int maskedNextBlockChunkX = blockChunkX + 16 & 0xFFFFFFF0;
                int chunkX = blockChunkX >> 4;
                int chunkZ = blockChunkZ >> 4;
                ChunkAccess chunk = world.m_6522_(chunkX, chunkZ, ChunkStatus.f_62314_, false);
                LevelChunkSection[] sections = chunk == null ? null : chunk.m_7103_();
                int chunkMinSection = chunk != null ? chunk.m_151560_() : 0;
                for (int blockChunkY = startYInclusive; blockChunkY < maxY; blockChunkY += 16) {
                    int maskedBlockChunkY = blockChunkY & 0xFFFFFFF0;
                    int maskedNextBlockChunkY = blockChunkY + 16 & 0xFFFFFFF0;
                    int sectionIndex = (blockChunkY >> 4) - chunkMinSection;
                    LevelChunkSection section = sections == null || sectionIndex < 0 || sectionIndex >= sections.length ? null : sections[sectionIndex];
                    int sectionMinX = Math.max(maskedBlockChunkX, startXInclusive);
                    int sectionMinY = Math.max(maskedBlockChunkY, startYInclusive);
                    int sectionMinZ = Math.max(maskedBlockChunkZ, startZInclusive);
                    int sectionMaxX = Math.min(maskedNextBlockChunkX, endXPlus1);
                    int sectionMaxY = Math.min(maskedNextBlockChunkY, endYPlus1);
                    int sectionMaxZ = Math.min(maskedNextBlockChunkZ, endZPlus1);
                    for (int y = sectionMinY; y < sectionMaxY; ++y) {
                        int maskedY = y & 0xF;
                        for (int z = sectionMinZ; z < sectionMaxZ; ++z) {
                            int maskedZ = z & 0xF;
                            for (int x = sectionMinX; x < sectionMaxX; ++x) {
                                BlockState state = section == null ? air : section.m_62982_(x & 0xF, maskedY, maskedZ);
                                currentPosition.m_122178_(x, y, z);
                                int zyxIndex = (z - startZInclusive) * widthMulHeight + (y - startYInclusive) * width + (x - startXInclusive);
                                func.accept(state, currentPosition, zyxIndex);
                            }
                        }
                    }
                }
            }
        }
    }

    public static float getBlockDensity(Predicate<BlockState> isSmoothable, BlockState state) {
        return ModUtil.getBlockDensity(isSmoothable.test(state), state);
    }

    public static float getBlockDensity(boolean shouldSmooth, BlockState state) {
        if (!shouldSmooth) {
            return -1.0f;
        }
        if (ModUtil.isSnowLayer(state)) {
            return ModUtil.mapSnowHeight((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_));
        }
        return 1.0f;
    }

    private static float mapSnowHeight(int value) {
        return -1.0f + (float)(value - 1) * 0.25f;
    }

    public static boolean isSnowLayer(BlockState state) {
        return state.m_61138_((Property)SnowLayerBlock.f_56581_);
    }

    public static boolean isShortPlant(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof BushBlock && !(block instanceof DoublePlantBlock) && !(block instanceof CropBlock) && !(block instanceof StemBlock);
    }

    public static boolean isPlant(BlockState state) {
        Material material = state.m_60767_();
        return material == Material.f_76300_ || material == Material.f_76301_ || material == Material.f_76302_ || material == Material.f_76303_ || material == Material.f_76304_ || material == Material.f_76270_ || material == Material.f_76271_ || material == Material.f_76285_;
    }

    public static int get3dIndexInto1dArray(int x, int y, int z, int xSize, int ySize) {
        return xSize * ySize * z + xSize * y + x;
    }

    public static FluidState getExtendedFluidState(Level world, BlockPos pos) {
        int extendRange = NoCubesConfig.Server.extendFluidsRange;
        assert (extendRange > 0);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int chunkX = x >> 4;
        int z = pos.m_123343_();
        int chunkZ = z >> 4;
        LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
        FluidState fluid = chunk.m_62814_(x, y, z);
        if (!fluid.m_76178_() || !NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)chunk.m_8055_(pos))) {
            return fluid;
        }
        fluid = chunk.m_62814_(x, y + 1, z);
        if (fluid.m_76170_()) {
            return fluid;
        }
        for (int extendZ = z - extendRange; extendZ <= z + extendRange; ++extendZ) {
            for (int extendX = x - extendRange; extendX <= x + extendRange; ++extendX) {
                if (extendZ == z && extendX == x) continue;
                if (chunkX != extendZ >> 4 || chunkZ != extendX >> 4) {
                    chunkZ = extendZ >> 4;
                    chunkX = extendX >> 4;
                    chunk = world.m_6325_(chunkX, chunkZ);
                }
                if (!(fluid = chunk.m_62814_(extendX, y, extendZ)).m_76170_()) continue;
                return fluid;
            }
        }
        return Fluids.f_76191_.m_76145_();
    }

    public static interface Traverser {
        public void accept(BlockState var1, BlockPos.MutableBlockPos var2, int var3);
    }
}

