/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.ThreadLocalArrayCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class Area
implements AutoCloseable {
    private static final ThreadLocalArrayCache<BlockState[]> BLOCKS_CACHE = new ThreadLocalArrayCache<BlockState[]>(BlockState[]::new, array -> ((BlockState[])array).length);
    public final BlockPos start;
    public final BlockPos size;
    private final BlockGetter world;
    private BlockState[] blocks;
    private FluidState[] fluids;

    public Area(BlockGetter world, BlockPos startInclusive, BlockPos size) {
        this.world = world;
        this.start = startInclusive.m_7949_();
        this.size = size.m_7949_();
    }

    public Area(BlockGetter world, BlockPos startInclusive, BlockPos size, MeshGenerator generator) {
        this.world = world;
        Vec3i negativeExtension = generator.getNegativeAreaExtension();
        Vec3i positiveExtension = generator.getPositiveAreaExtension();
        this.start = startInclusive.m_141950_(negativeExtension).m_7949_();
        this.size = new BlockPos(size.m_123341_() + negativeExtension.m_123341_() + positiveExtension.m_123341_(), size.m_123342_() + negativeExtension.m_123342_() + positiveExtension.m_123342_(), size.m_123343_() + negativeExtension.m_123343_() + positiveExtension.m_123343_());
    }

    public BlockState[] getAndCacheBlocks() {
        if (this.blocks == null) {
            this.blocks = BLOCKS_CACHE.takeArray(this.numBlocks());
            BlockState[] array = this.blocks;
            BlockPos start = this.start;
            int startX = start.m_123341_();
            int startY = start.m_123342_();
            int startZ = start.m_123343_();
            BlockPos size = this.size;
            int endX = startX + size.m_123341_();
            int endY = startY + size.m_123342_();
            int endZ = startZ + size.m_123343_();
            BlockGetter world = this.world;
            if (world instanceof LevelReader) {
                BlockPos endInclusive = new BlockPos(endX - 1, endY - 1, endZ - 1);
                ModUtil.traverseArea((Vec3i)start, (Vec3i)endInclusive, new BlockPos.MutableBlockPos(), (LevelReader)world, (state, pos, zyxIndex) -> {
                    array[zyxIndex] = state;
                });
            } else {
                BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
                int zyxIndex2 = 0;
                for (int z = startZ; z < endZ; ++z) {
                    for (int y = startY; y < endY; ++y) {
                        int x = startX;
                        while (x < endX) {
                            array[zyxIndex2] = world.m_8055_((BlockPos)pos2.m_122178_(x, y, z));
                            ++x;
                            ++zyxIndex2;
                        }
                    }
                }
            }
        }
        return this.blocks;
    }

    public int numBlocks() {
        return ModUtil.length(this.size);
    }

    public int index(BlockPos relativePos) {
        int index = this.indexIfInsideCache(relativePos);
        if (index == -1) {
            throw new IndexOutOfBoundsException("relativePos was " + relativePos + " but should have been within " + ModUtil.VEC_ZERO + " and " + this.size);
        }
        return index;
    }

    public int indexIfInsideCache(BlockPos relativePos) {
        return this.indexIfInsideCache(relativePos.m_123341_(), relativePos.m_123342_(), relativePos.m_123343_());
    }

    public int indexIfInsideCache(int relativeX, int relativeY, int relativeZ) {
        BlockPos size = this.size;
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        if (relativeX < 0 || relativeX >= sizeX || relativeY < 0 || relativeY >= sizeY || relativeZ < 0 || relativeZ >= size.m_123343_()) {
            return -1;
        }
        return ModUtil.get3dIndexInto1dArray(relativeX, relativeY, relativeZ, sizeX, sizeY);
    }

    @Override
    public void close() {
    }

    public BlockState getBlockState(BlockPos.MutableBlockPos relativePos) {
        int index = this.indexIfInsideCache((BlockPos)relativePos);
        if (index == -1) {
            int x = relativePos.m_123341_();
            int y = relativePos.m_123342_();
            int z = relativePos.m_123343_();
            BlockState state = this.world.m_8055_((BlockPos)relativePos.m_122193_((Vec3i)this.start));
            relativePos.m_122178_(x, y, z);
            return state;
        }
        return this.getAndCacheBlocks()[index];
    }
}

