/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.smoothable;

import com.google.common.collect.Sets;
import io.github.cadiboo.nocubes.hooks.INoCubesBlockState;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.apache.logging.log4j.LogManager;

public interface SmoothableHandler {
    public static SmoothableHandler create(BlockBehaviour.BlockStateBase test) {
        try {
            ASM asm = new ASM();
            asm.isSmoothable(test);
            return asm;
        }
        catch (ClassCastException | NoSuchFieldError e) {
            LogManager.getLogger().warn("Failed to create optimised ASM based handler, falling back to Set implementation, performance may suffer slightly", e);
            return new Set();
        }
    }

    public void addSmoothable(BlockBehaviour.BlockStateBase var1);

    public void removeSmoothable(BlockBehaviour.BlockStateBase var1);

    public boolean isSmoothable(BlockBehaviour.BlockStateBase var1);

    public void setSmoothable(boolean var1, BlockBehaviour.BlockStateBase var2);

    public static class ASM
    implements SmoothableHandler {
        @Override
        public void addSmoothable(BlockBehaviour.BlockStateBase state) {
            this.setSmoothable(true, state);
        }

        @Override
        public void removeSmoothable(BlockBehaviour.BlockStateBase state) {
            this.setSmoothable(false, state);
        }

        @Override
        public boolean isSmoothable(BlockBehaviour.BlockStateBase state) {
            return ((INoCubesBlockState)state).isTerrainSmoothable();
        }

        @Override
        public void setSmoothable(boolean newValue, BlockBehaviour.BlockStateBase state) {
            ((INoCubesBlockState)state).setTerrainSmoothable(newValue);
        }
    }

    public static class Set
    implements SmoothableHandler {
        private final java.util.Set<BlockBehaviour.BlockStateBase> smoothables = Sets.newIdentityHashSet();

        @Override
        public void addSmoothable(BlockBehaviour.BlockStateBase state) {
            this.smoothables.add(state);
        }

        @Override
        public void removeSmoothable(BlockBehaviour.BlockStateBase state) {
            this.smoothables.remove(state);
        }

        @Override
        public boolean isSmoothable(BlockBehaviour.BlockStateBase state) {
            return this.smoothables.contains(state);
        }

        @Override
        public void setSmoothable(boolean newValue, BlockBehaviour.BlockStateBase state) {
            if (newValue) {
                this.addSmoothable(state);
            } else {
                this.removeSmoothable(state);
            }
        }
    }
}

