/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public record S2CUpdateSmoothable(BlockState state, boolean newValue) {
    public static void encode(S2CUpdateSmoothable msg, FriendlyByteBuf buffer) {
        buffer.m_130130_(BlockStateConverter.toId(msg.state));
        buffer.writeBoolean(msg.newValue);
    }

    public static S2CUpdateSmoothable decode(FriendlyByteBuf buffer) {
        BlockState state = BlockStateConverter.fromId(buffer.m_130242_());
        boolean newValue = buffer.readBoolean();
        return new S2CUpdateSmoothable(state, newValue);
    }

    public static void handle(S2CUpdateSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            NoCubes.smoothableHandler.setSmoothable(msg.newValue, (BlockBehaviour.BlockStateBase)msg.state);
            ClientUtil.reloadAllChunks();
        });
        ctx.setPacketHandled(true);
    }
}

