/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.network.S2CUpdateSmoothable;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SRequestUpdateSmoothable(BlockState state, boolean newValue) {
    public static void encode(C2SRequestUpdateSmoothable msg, FriendlyByteBuf buffer) {
        buffer.m_130130_(BlockStateConverter.toId(msg.state));
        buffer.writeBoolean(msg.newValue);
    }

    public static C2SRequestUpdateSmoothable decode(FriendlyByteBuf buffer) {
        BlockState state = BlockStateConverter.fromId(buffer.m_130242_());
        boolean newValue = buffer.readBoolean();
        return new C2SRequestUpdateSmoothable(state, newValue);
    }

    public static void handle(C2SRequestUpdateSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer sender = ctx.getSender();
        boolean hasPermission = sender.m_20310_(2);
        if (hasPermission) {
            BlockState state = msg.state;
            boolean newValue = msg.newValue;
            if (NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state) != newValue) {
                ctx.enqueueWork(() -> NoCubesConfig.Server.updateSmoothable(newValue, state));
                NoCubesNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CUpdateSmoothable(state, newValue));
            } else {
                NoCubesNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new S2CUpdateSmoothable(state, newValue));
            }
        } else {
            sender.m_6352_((Component)new TranslatableComponent("nocubes.command.addSmoothableNoPermission"), Util.f_137441_);
        }
        ctx.setPacketHandled(true);
    }
}

