/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.ThreadLocalArrayCache;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class SurfaceNets
implements MeshGenerator {
    public static final int COMPLETELY_OUTSIDE_ISOSURFACE = 0;
    public static final int COMPLETELY_INSIDE_ISOSURFACE = 255;
    private static final ThreadLocalArrayCache<float[]> DISTANCE_FIELD_CACHE = new ThreadLocalArrayCache<float[]>(float[]::new, array -> ((float[])array).length);

    @Override
    public Vec3i getPositiveAreaExtension() {
        return ModUtil.VEC_ONE;
    }

    @Override
    public Vec3i getNegativeAreaExtension() {
        return NoCubesConfig.Server.extraSmoothMesh ? ModUtil.VEC_TWO : ModUtil.VEC_ONE;
    }

    @Override
    public void generateOrThrow(Area area, Predicate<BlockState> isSmoothable, MeshGenerator.VoxelAction voxelAction, MeshGenerator.FaceAction faceAction) {
        boolean smoother = NoCubesConfig.Server.extraSmoothMesh;
        float[] distanceField = SurfaceNets.generateDistanceField(area, isSmoothable, smoother);
        BlockPos dims = SurfaceNets.getDimensions(area, smoother);
        SurfaceNets.generateOrThrow(distanceField, dims, smoother, voxelAction, faceAction);
    }

    public static BlockPos getDimensions(Area area, boolean smoother) {
        return smoother ? area.size.m_141950_((Vec3i)ModUtil.VEC_ONE) : area.size;
    }

    public static float[] generateDistanceField(Area area, Predicate<BlockState> isSmoothable, boolean smoother) {
        BlockState[] states = area.getAndCacheBlocks();
        return smoother ? SurfaceNets.generateDistanceField(area, isSmoothable, states) : SurfaceNets.generateNegativeDensityField(area, isSmoothable, states);
    }

    private static float[] generateNegativeDensityField(Area area, Predicate<BlockState> isSmoothable, BlockState[] states) {
        int length = area.numBlocks();
        float[] densityField = DISTANCE_FIELD_CACHE.takeArray(length);
        for (int i = 0; i < length; ++i) {
            densityField[i] = -ModUtil.getBlockDensity(isSmoothable, states[i]);
        }
        return densityField;
    }

    private static float[] generateDistanceField(Area area, Predicate<BlockState> isSmoothable, BlockState[] states) {
        int areaX = area.size.m_123341_();
        int areaY = area.size.m_123342_();
        int areaZ = area.size.m_123343_();
        int distanceFieldSizeX = areaX - 1;
        int distanceFieldSizeY = areaY - 1;
        int distanceFieldSizeZ = areaZ - 1;
        int distanceFieldSize = distanceFieldSizeX * distanceFieldSizeY * distanceFieldSizeZ;
        float[] distanceField = DISTANCE_FIELD_CACHE.takeArray(distanceFieldSize);
        int index = 0;
        for (int z = 0; z < areaZ; ++z) {
            for (int y = 0; y < areaY; ++y) {
                int x = 0;
                while (x < areaX) {
                    if (z != distanceFieldSizeZ && y != distanceFieldSizeY && x != distanceFieldSizeX) {
                        int combinedDensity = 0;
                        int neighbourIndex = index;
                        int neighbourZ = 0;
                        while (neighbourZ < 2) {
                            int neighbourY = 0;
                            while (neighbourY < 2) {
                                int neighbourX = 0;
                                while (neighbourX < 2) {
                                    combinedDensity = (int)((float)combinedDensity + ModUtil.getBlockDensity(isSmoothable, states[neighbourIndex]));
                                    ++neighbourX;
                                    ++neighbourIndex;
                                }
                                ++neighbourY;
                                neighbourIndex += areaX - 2;
                            }
                            ++neighbourZ;
                            neighbourIndex += areaX * (areaY - 2);
                        }
                        int distanceFieldIndex = ModUtil.get3dIndexInto1dArray(x, y, z, distanceFieldSizeX, distanceFieldSizeY);
                        distanceField[distanceFieldIndex] = (float)(-combinedDensity) / 8.0f;
                    }
                    ++x;
                    ++index;
                }
            }
        }
        return distanceField;
    }

    private static void generateOrThrow(float[] distanceField, BlockPos dims, boolean smoother, MeshGenerator.VoxelAction voxelAction, MeshGenerator.FaceAction faceAction) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Face face = new Face();
        int n = 0;
        int[] axisMultipliers = new int[]{1, dims.m_123341_() + 1, (dims.m_123341_() + 1) * (dims.m_123342_() + 1)};
        float[] cornerDistances = new float[8];
        int buf_no = 1;
        Vec[] verticesBuffer = new Vec[axisMultipliers[2] * 2];
        float[] vertexUntilIFigureOutTheInterpolationAndIntersection = new float[]{0.0f, 0.0f, 0.0f};
        int z = 0;
        while (z < dims.m_123343_() - 1) {
            int bufferPointer = 1 + (dims.m_123341_() + 1) * (1 + buf_no * (dims.m_123342_() + 1));
            int y = 0;
            while (y < dims.m_123342_() - 1) {
                int x = 0;
                while (x < dims.m_123341_() - 1) {
                    int mask = 0;
                    int corner = 0;
                    int cornerIndex = n;
                    int cornerZ = 0;
                    while (cornerZ < 2) {
                        int cornerY = 0;
                        while (cornerY < 2) {
                            int cornerX = 0;
                            while (cornerX < 2) {
                                float signedDistance;
                                cornerDistances[corner] = signedDistance = distanceField[cornerIndex];
                                boolean insideIsosurface = signedDistance < 0.0f;
                                mask |= insideIsosurface ? 1 << corner : 0;
                                cornerX = (byte)(cornerX + 1);
                                ++corner;
                                ++cornerIndex;
                            }
                            ++cornerY;
                            cornerIndex += dims.m_123341_() - 2;
                        }
                        ++cornerZ;
                        cornerIndex += dims.m_123341_() * (dims.m_123342_() - 2);
                    }
                    if (!voxelAction.apply(pos.m_122178_(x, y, z), SurfaceNets.getAmountInsideIsosurface(smoother, cornerDistances))) {
                        return;
                    }
                    if (mask != 0 && mask != 255) {
                        int edge_mask = Lookup.EDGE_TABLE[mask];
                        vertexUntilIFigureOutTheInterpolationAndIntersection[2] = 0.0f;
                        vertexUntilIFigureOutTheInterpolationAndIntersection[1] = 0.0f;
                        vertexUntilIFigureOutTheInterpolationAndIntersection[0] = 0.0f;
                        int edgeCrossings = 0;
                        for (int edge = 0; edge < 12; ++edge) {
                            if ((edge_mask & 1 << edge) == 0) continue;
                            ++edgeCrossings;
                            int edgeStart = Lookup.CUBE_EDGES[edge << 1];
                            float edgeStartValue = cornerDistances[edgeStart];
                            int edgeEnd = Lookup.CUBE_EDGES[(edge << 1) + 1];
                            float edgeEndValue = cornerDistances[edgeEnd];
                            float t = edgeStartValue - edgeEndValue;
                            if (Math.abs(t) <= 1.0E-8f) continue;
                            t = edgeStartValue / t;
                            int axis = 0;
                            int axisMask = 1;
                            while (axis < 3) {
                                int startAxisValue = edgeStart & axisMask;
                                int endAxisValue = edgeEnd & axisMask;
                                float axisInterpValue = startAxisValue != endAxisValue ? (startAxisValue != 0 ? 1.0f - t : t) : (startAxisValue != 0 ? 1.0f : 0.0f);
                                int n2 = axis++;
                                vertexUntilIFigureOutTheInterpolationAndIntersection[n2] = vertexUntilIFigureOutTheInterpolationAndIntersection[n2] + axisInterpValue;
                                axisMask <<= 1;
                            }
                        }
                        float s = 1.0f / (float)edgeCrossings;
                        Vec vertex = new Vec(vertexUntilIFigureOutTheInterpolationAndIntersection[0], vertexUntilIFigureOutTheInterpolationAndIntersection[1], vertexUntilIFigureOutTheInterpolationAndIntersection[2]);
                        vertex.x = (float)x + s * vertex.x;
                        vertex.y = (float)y + s * vertex.y;
                        vertex.z = (float)z + s * vertex.z;
                        if (!smoother) {
                            vertex.add(0.5f, 0.5f, 0.5f);
                        } else {
                            vertex.add(1.0f, 1.0f, 1.0f);
                        }
                        verticesBuffer[bufferPointer] = vertex;
                        for (int axis = 0; axis < 3; ++axis) {
                            if ((edge_mask & 1 << axis) == 0) continue;
                            int nextAxis = (axis + 1) % 3;
                            int nextNextAxis = (axis + 2) % 3;
                            if (nextAxis == 0 && x == 0 || nextAxis == 1 && y == 0 || nextAxis == 2 && z == 0 || nextNextAxis == 0 && x == 0 || nextNextAxis == 1 && y == 0 || nextNextAxis == 2 && z == 0) continue;
                            int du = axisMultipliers[nextAxis];
                            int dv = axisMultipliers[nextNextAxis];
                            if ((mask & 1) != 0) {
                                face.set(verticesBuffer[bufferPointer], verticesBuffer[bufferPointer - dv], verticesBuffer[bufferPointer - du - dv], verticesBuffer[bufferPointer - du]);
                            } else {
                                face.set(verticesBuffer[bufferPointer], verticesBuffer[bufferPointer - du], verticesBuffer[bufferPointer - du - dv], verticesBuffer[bufferPointer - dv]);
                            }
                            face.flip();
                            pos.m_122178_(x, y, z);
                            if (faceAction.apply(pos, face)) continue;
                            return;
                        }
                    }
                    ++x;
                    ++n;
                    ++bufferPointer;
                }
                ++y;
                ++n;
                bufferPointer += 2;
            }
            ++z;
            n += dims.m_123341_();
            buf_no ^= 1;
            axisMultipliers[2] = -axisMultipliers[2];
        }
    }

    private static float getAmountInsideIsosurface(boolean smoother, float[] cornerDistances) {
        if (!smoother) {
            float voxelDensity = 0.0f;
            for (int corner = 0; corner < 8; ++corner) {
                float cornerDensity = -cornerDistances[corner];
                voxelDensity += (cornerDensity + 1.0f) / 2.0f;
            }
            return voxelDensity / 8.0f;
        }
        float combinedDistance = 0.0f;
        for (int corner = 0; corner < 8; ++corner) {
            combinedDistance += cornerDistances[corner];
        }
        float averageDistance = combinedDistance / 8.0f;
        float voxelDensity = -averageDistance;
        return (voxelDensity + 1.0f) / 2.0f;
    }

    static final class Lookup {
        public static final int[] CUBE_EDGES = new int[24];
        public static final int[] EDGE_TABLE = new int[256];

        Lookup() {
        }

        private static void generateCubeEdgesTable() {
            int cubeEdgesIndex = 0;
            for (int cubeCornerIndex = 0; cubeCornerIndex < 8; cubeCornerIndex = (int)((byte)(cubeCornerIndex + 1))) {
                for (int em = 1; em <= 4; em <<= 1) {
                    int j = cubeCornerIndex ^ em;
                    if (cubeCornerIndex > j) continue;
                    Lookup.CUBE_EDGES[cubeEdgesIndex++] = cubeCornerIndex;
                    Lookup.CUBE_EDGES[cubeEdgesIndex++] = j;
                }
            }
        }

        private static void generateIntersectionTable() {
            for (int edgeTableIndex = 0; edgeTableIndex < 256; edgeTableIndex = (int)((short)(edgeTableIndex + 1))) {
                int em = 0;
                for (int cubeEdgesIndex = 0; cubeEdgesIndex < 24; cubeEdgesIndex += 2) {
                    boolean a = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex]) != 0;
                    boolean b = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex + 1]) != 0;
                    em = (short)(em | (a != b ? 1 << (cubeEdgesIndex >> 1) : 0));
                }
                Lookup.EDGE_TABLE[edgeTableIndex] = em;
            }
        }

        static {
            Lookup.generateCubeEdgesTable();
            Lookup.generateIntersectionTable();
        }
    }
}

