/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public interface MeshGenerator {
    public static final VoxelAction DEFAULT_VOXEL_ACTION;

    default public void generate(Area area, Predicate<BlockState> isSmoothable, FaceAction action) {
        this.generate(area, isSmoothable, DEFAULT_VOXEL_ACTION, action);
    }

    default public void generate(Area area, Predicate<BlockState> isSmoothable, VoxelAction voxelAction, FaceAction faceAction) {
        try {
            this.generateOrThrow(area, isSmoothable, voxelAction, faceAction);
        }
        catch (Throwable t) {
            if (!((Boolean)ModUtil.IS_DEVELOPER_WORKSPACE.get()).booleanValue()) {
                throw t;
            }
            t.getCause();
        }
    }

    public void generateOrThrow(Area var1, Predicate<BlockState> var2, VoxelAction var3, FaceAction var4);

    public Vec3i getPositiveAreaExtension();

    public Vec3i getNegativeAreaExtension();

    default public boolean isOutsideMesh(int x, int y, int z, BlockPos size) {
        Vec3i negativeExtension = this.getNegativeAreaExtension();
        Vec3i positiveExtension = this.getPositiveAreaExtension();
        return x >= size.m_123341_() - positiveExtension.m_123341_() || x < negativeExtension.m_123341_() || y >= size.m_123342_() - positiveExtension.m_123342_() || y < negativeExtension.m_123342_() || z >= size.m_123343_() - positiveExtension.m_123343_() || z < negativeExtension.m_123343_();
    }

    public static void translateToMeshStart(PoseStack matrix, BlockPos areaStart, BlockPos renderStartPos) {
        matrix.m_85837_((double)MeshGenerator.validateMeshOffset(areaStart.m_123341_() - renderStartPos.m_123341_()), (double)MeshGenerator.validateMeshOffset(areaStart.m_123342_() - renderStartPos.m_123342_()), (double)MeshGenerator.validateMeshOffset(areaStart.m_123343_() - renderStartPos.m_123343_()));
    }

    public static int validateMeshOffset(int meshOffset) {
        if (!1.$assertionsDisabled && meshOffset > 0) {
            throw new AssertionError((Object)"Mesh generators won't require a smaller area than they are generating a mesh for");
        }
        if (!1.$assertionsDisabled && meshOffset <= -3) {
            throw new AssertionError((Object)"Mesh generators won't require more than 2 extra blocks on each axis");
        }
        return meshOffset;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        DEFAULT_VOXEL_ACTION = (pos, amount) -> true;
    }

    public static interface VoxelAction {
        public boolean apply(BlockPos.MutableBlockPos var1, float var2);
    }

    public static interface FaceAction {
        public boolean apply(BlockPos.MutableBlockPos var1, Face var2);
    }
}

