/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.hooks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.render.RendererDispatcher;
import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.hooks.SelfCheck;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Hooks {
    @OnlyIn(value=Dist.CLIENT)
    public static void preIteration(ChunkRenderDispatcher.RenderChunk.RebuildTask rebuildTask, ChunkRenderDispatcher.RenderChunk chunkRender, ChunkRenderDispatcher.CompiledChunk compiledChunkIn, ChunkBufferBuilderPack builderIn, BlockPos blockpos, BlockAndTintGetter chunkrendercache, PoseStack matrixstack, Random random, BlockRenderDispatcher blockrendererdispatcher) {
        SelfCheck.preIteration = true;
        RendererDispatcher.renderChunk(rebuildTask, chunkRender, compiledChunkIn, builderIn, blockpos, chunkrendercache, matrixstack, random, blockrendererdispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FluidState getRenderFluidState(BlockPos pos) {
        SelfCheck.getRenderFluidState = true;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return Fluids.f_76191_.m_76145_();
        }
        return world.m_6425_(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canBlockStateRender(BlockState state) {
        SelfCheck.canBlockStateRender = true;
        if (!NoCubesConfig.Client.render) {
            return true;
        }
        if (!NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            if (!NoCubesConfig.Client.fixPlantHeight) {
                return true;
            }
            return !ModUtil.isShortPlant(state);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderBreakingTexture(BlockRenderDispatcher dispatcher, BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack matrix, VertexConsumer buffer, IModelData modelData) {
        SelfCheck.renderBreakingTexture = true;
        if (!NoCubesConfig.Client.render || !NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return false;
        }
        RendererDispatcher.renderBreakingTexture(dispatcher, state, pos, world, matrix, buffer, modelData);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setBlocksDirty(Minecraft minecraft, LevelRenderer worldRenderer, BlockPos pos, BlockState oldState, BlockState newState) {
        SelfCheck.setBlocksDirty = true;
        if (minecraft.m_91304_().m_119415_(oldState, newState)) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            int extension = NoCubesConfig.Client.render ? 2 : 1;
            worldRenderer.m_109494_(x - extension, y - extension, z - extension, x + extension, y + extension, z + extension);
        }
    }

    @Nullable
    public static Boolean canOccludeOverride(BlockState state) {
        SelfCheck.canOccludeOverride = true;
        if (NoCubesConfig.Client.render && NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return false;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static LiquidBlockRenderer createFluidBlockRenderer(LiquidBlockRenderer original) {
        SelfCheck.createFluidBlockRenderer = true;
        return new LiquidBlockRenderer(){

            public boolean m_110954_(BlockAndTintGetter ignored, BlockPos posIn, VertexConsumer vertexBuilderIn, FluidState fluidStateIn) {
                return super.m_110954_((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, posIn, vertexBuilderIn, fluidStateIn);
            }
        };
    }

    @Nullable
    public static VoxelShape getCollisionShapeOverride(BlockState state, BlockGetter world, BlockPos pos) {
        SelfCheck.getCollisionShapeNoContextOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return CollisionHandler.getCollisionShape(state, world, pos, CollisionContext.m_82749_());
        }
        return null;
    }

    @Nullable
    public static VoxelShape getCollisionShapeOverride(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        SelfCheck.getCollisionShapeWithContextOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return CollisionHandler.getCollisionShape(state, world, pos, context);
        }
        return null;
    }

    @Nullable
    public static Boolean isCollisionShapeFullBlockOverride(BlockState state, BlockGetter reader, BlockPos pos) {
        SelfCheck.isCollisionShapeFullBlockOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return false;
        }
        return null;
    }

    @Nullable
    public static Boolean hasLargeCollisionShapeOverride(BlockState state) {
        SelfCheck.hasLargeCollisionShapeOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return true;
        }
        return null;
    }

    @Nullable
    public static Boolean isSuffocatingOverride(BlockState state, BlockGetter world, BlockPos pos) {
        SelfCheck.isSuffocatingOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return false;
        }
        return null;
    }

    @Nullable
    public static FluidState getFluidStateOverride(Level world, BlockPos pos) {
        SelfCheck.getFluidStateOverride = true;
        if (NoCubesConfig.Server.extendFluidsRange <= 0) {
            return null;
        }
        return ModUtil.getExtendedFluidState(world, pos);
    }

    public static void afterClientLoginSuccess(Connection manager) {
        SelfCheck.afterClientLoginSuccess = true;
        if (NetworkHooks.isVanillaConnection((Connection)manager)) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"NoCubes Client-only features");
        logger.info("Connected to a modded server that doesn't have NoCubes installed, loading default server config");
        NoCubesConfig.Hacks.loadDefaultServerConfig();
        logger.debug("Done loading default server config");
    }

    public static void loadClasses(Dist dist) {
        Hooks.loadClass("net.minecraft.world.level.block.state.BlockBehaviour$BlockStateBase");
        Hooks.loadClass("net.minecraft.world.level.block.state.BlockState");
        Hooks.loadClass("net.minecraft.world.level.Level");
        Hooks.loadClass("net.minecraftforge.network.NetworkHooks");
        if (dist.isClient()) {
            Hooks.loadClass("net.minecraft.client.renderer.block.BlockRenderDispatcher");
            Hooks.loadClass("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$RenderChunk$RebuildTask");
            Hooks.loadClass("net.minecraft.client.multiplayer.ClientLevel");
            Hooks.loadClass("net.minecraft.client.renderer.chunk.RenderChunkRegion");
        }
    }

    private static void loadClass(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class \"" + className + "\", probably a coremod issue", e);
        }
        try {
            Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to initialise class \"" + className + "\", probably a coremod issue", e);
        }
    }
}

