/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.config.ColorParser;
import io.github.cadiboo.nocubes.mesh.CullingChamfer;
import io.github.cadiboo.nocubes.mesh.CullingCubic;
import io.github.cadiboo.nocubes.mesh.MarchingCubes;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.OldNoCubes;
import io.github.cadiboo.nocubes.mesh.StupidCubic;
import io.github.cadiboo.nocubes.mesh.SurfaceNets;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.network.S2CUpdateServerConfig;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="nocubes", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class NoCubesConfig {
    private static long lastSavedClientConfigAt = -1L;
    private static long lastSavedServerConfigAt = -1L;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Client.SPEC);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Server.SPEC);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        IConfigSpec spec = config.getSpec();
        if (spec == Client.SPEC && NoCubesConfig.didNotSaveConfigRecently(lastSavedClientConfigAt)) {
            Client.bake(config);
            lastSavedClientConfigAt = -1L;
        } else if (spec == Server.SPEC && NoCubesConfig.didNotSaveConfigRecently(lastSavedServerConfigAt)) {
            Server.bake(config);
            lastSavedServerConfigAt = -1L;
        }
    }

    static boolean didNotSaveConfigRecently(long lastSavedConfigAt) {
        long ten_seconds = 10000000000L;
        long now = System.nanoTime();
        return now - 10000000000L > lastSavedConfigAt;
    }

    public static class Client {
        public static final Impl INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public static boolean render;
        public static ColorParser.Color selectionBoxColor;
        public static boolean betterGrassSides;
        public static boolean moreSnow;
        public static boolean fixPlantHeight;
        public static boolean grassTufts;
        public static boolean debugEnabled;
        public static boolean debugOutlineSmoothables;
        public static boolean debugVisualiseDensitiesGrid;
        public static boolean debugRenderCollisions;
        public static boolean debugRenderMeshCollisions;
        public static boolean debugRecordMeshPerformance;
        public static boolean debugOutlineNearbyMesh;

        public static void bake(ModConfig config) {
            boolean oldRender = render;
            int oldChunkRenderSettingsHash = Client.hashChunkRenderSettings();
            render = Server.forceVisuals || (Boolean)Client.INSTANCE.render.get() != false;
            selectionBoxColor = ColorParser.parse((String)Client.INSTANCE.selectionBoxColor.get());
            betterGrassSides = (Boolean)Client.INSTANCE.betterGrassSides.get();
            moreSnow = (Boolean)Client.INSTANCE.moreSnow.get();
            fixPlantHeight = (Boolean)Client.INSTANCE.fixPlantHeight.get();
            grassTufts = (Boolean)Client.INSTANCE.grassTufts.get();
            if (oldRender != render || render && oldChunkRenderSettingsHash != Client.hashChunkRenderSettings()) {
                ClientUtil.reloadAllChunks();
            }
            debugEnabled = (Boolean)Client.INSTANCE.debugEnabled.get();
            debugOutlineSmoothables = (Boolean)Client.INSTANCE.debugOutlineSmoothables.get();
            debugVisualiseDensitiesGrid = (Boolean)Client.INSTANCE.debugVisualiseDensitiesGrid.get();
            debugRenderCollisions = (Boolean)Client.INSTANCE.debugRenderCollisions.get();
            debugRenderMeshCollisions = (Boolean)Client.INSTANCE.debugRenderMeshCollisions.get();
            debugRecordMeshPerformance = (Boolean)Client.INSTANCE.debugRecordMeshPerformance.get();
            debugOutlineNearbyMesh = (Boolean)Client.INSTANCE.debugOutlineNearbyMesh.get();
        }

        private static int hashChunkRenderSettings() {
            return Objects.hash(betterGrassSides, moreSnow, fixPlantHeight, grassTufts);
        }

        public static void updateRender(boolean newValue) {
            Client.INSTANCE.render.set((Object)newValue);
            Client.saveAndLoad();
        }

        private static void saveAndLoad() {
            lastSavedClientConfigAt = -1L;
            Hacks.saveAndLoad(ModConfig.Type.CLIENT);
            lastSavedClientConfigAt = System.nanoTime();
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Impl::new);
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Impl)specPair.getLeft();
        }

        static class Impl {
            final ForgeConfigSpec.BooleanValue render;
            final ForgeConfigSpec.ConfigValue<String> selectionBoxColor;
            final ForgeConfigSpec.BooleanValue betterGrassSides;
            final ForgeConfigSpec.BooleanValue moreSnow;
            final ForgeConfigSpec.BooleanValue fixPlantHeight;
            final ForgeConfigSpec.BooleanValue grassTufts;
            final ForgeConfigSpec.BooleanValue debugEnabled;
            final ForgeConfigSpec.BooleanValue debugOutlineSmoothables;
            final ForgeConfigSpec.BooleanValue debugVisualiseDensitiesGrid;
            final ForgeConfigSpec.BooleanValue debugRenderCollisions;
            final ForgeConfigSpec.BooleanValue debugRenderMeshCollisions;
            final ForgeConfigSpec.BooleanValue debugRecordMeshPerformance;
            final ForgeConfigSpec.BooleanValue debugOutlineNearbyMesh;

            private Impl(ForgeConfigSpec.Builder builder) {
                this.render = builder.translation("nocubes.config.render").comment("If NoCubes' custom rendering is enabled").define("render", true);
                this.selectionBoxColor = builder.translation("nocubes.config.selectionBoxColor").comment(new String[]{"The color of the outline (selection box) over a smoothed block.", "Supports pretty much any format you can imagine.", "Some examples of ways to define colors:", "By name: \"red\"", "By name: \"firebrick\" (a red-orangeish color)", "By name: \"gainsboro\" (a light gray color)", "With RGB (red, green, blue) integers (0-255): \"rgb(255, 0, 0)\" (pure red)", "With RGB (red, green, blue) floats (0.0-1.0): \"rgb(1.0, 0, 0)\" (also pure red)", "With RGBA (red, green, blue, alpha) integers (0-255): \"rgba(255, 0, 0, 0.5)\" (partially transparent pure red)", "With RGBA (red, green, blue, alpha) integers (0-255): \"rgba(1.0, 0, 0, 1.0)\" (also partially transparent pure red)", "With hexadecimal (case insensitive) RGB (red, green, blue) integers (00-FF): \"0x0ff\" (aqua)", "With hexadecimal (case insensitive) RGBA (red, green, blue, alpha) integers (00-FF): \"#0FF6\" (partially transparent aqua)", "With HSL (hue, saturation, lightness): \"hsl(270, 100%, 100%)\" (a dark purple)", "With HSLA (hue, saturation, lightness, alpha): \"hsla(270, 100%, 100%, 0.5)\" (a partially transparent dark purple)"}).define("selectionBoxColor", (Object)"#0006");
                this.betterGrassSides = builder.translation("nocubes.config.betterGrassSides").comment(new String[]{"Similar to OptiFine's 'Better Grass' feature", "OFF - The sides of grass blocks have the default texture", "ON - The sides of grass blocks have the texture of the top of the block"}).define("betterGrassSides", false);
                this.moreSnow = builder.translation("nocubes.config.moreSnow").comment(new String[]{"Similar to OptiFine's 'Better Snow' feature", "OFF - The sides of blocks nearby snow have their own texture", "ON - The sides of blocks nearby snow have the snow texture"}).define("moreSnow", false);
                this.fixPlantHeight = builder.translation("nocubes.config.fixPlantHeight").comment("If small plants like flowers and grass should be moved onto NoCubes' terrain").define("fixPlantHeight", false);
                this.grassTufts = builder.translation("nocubes.config.grassTufts").comment("If small tufts of grass should be rendered on top of grass blocks, similar to BetterFoliage's 'Short Grass' feature").define("grassTufts", false);
                builder.push("debug");
                this.debugEnabled = builder.translation("nocubes.config.debugEnabled").comment("If debugging features should be enabled").define("debugEnabled", false);
                this.debugOutlineSmoothables = builder.define("debugOutlineSmoothables", false);
                this.debugVisualiseDensitiesGrid = builder.define("debugVisualiseDensitiesGrid", false);
                this.debugRenderCollisions = builder.define("debugRenderCollisions", false);
                this.debugRenderMeshCollisions = builder.define("debugRenderMeshCollisions", false);
                this.debugRecordMeshPerformance = builder.define("debugRecordMeshPerformance", false);
                this.debugOutlineNearbyMesh = builder.define("debugOutlineNearbyMesh", false);
                builder.pop();
            }
        }
    }

    public static class Server {
        public static final Impl INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public static MeshGenerator meshGenerator;
        public static boolean collisionsEnabled;
        public static boolean forceVisuals;
        public static int extendFluidsRange;
        public static float oldNoCubesRoughness;
        public static boolean extraSmoothMesh;

        public static void bake(ModConfig config) {
            int oldChunkRenderSettingsHash = Server.hashChunkRenderSettings();
            Smoothables.recomputeInMemoryLookup((List)Server.INSTANCE.smoothableWhitelist.get(), (List)Server.INSTANCE.smoothableBlacklist.get());
            meshGenerator = ((MeshGeneratorEnum)((Object)Server.INSTANCE.meshGenerator.get())).generator;
            collisionsEnabled = (Boolean)Server.INSTANCE.collisionsEnabled.get();
            forceVisuals = (Boolean)Server.INSTANCE.forceVisuals.get();
            if (forceVisuals) {
                Client.render = true;
            }
            extendFluidsRange = Server.validateRange(0, 2, (Integer)Server.INSTANCE.extendFluidsRange.get(), "extendFluidsRange");
            oldNoCubesRoughness = Server.validateRange(0.0, 1.0, (Double)Server.INSTANCE.oldNoCubesRoughness.get(), "oldNoCubesRoughness").floatValue();
            extraSmoothMesh = (Boolean)Server.INSTANCE.extraSmoothMesh.get();
            if (oldChunkRenderSettingsHash != Server.hashChunkRenderSettings()) {
                DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtil::reloadAllChunks);
            }
            if (FMLEnvironment.dist.isDedicatedServer()) {
                NoCubesNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)S2CUpdateServerConfig.create(config));
            }
        }

        private static <T extends Number> T validateRange(T min, T max, T value, String name) {
            if (((Comparable)((Object)value)).compareTo(min) < 0 || ((Comparable)((Object)value)).compareTo(max) > 0) {
                throw new IllegalStateException("Config was not validated! '" + name + "' must be between " + min + " and " + max + " but was " + value);
            }
            return value;
        }

        private static int hashChunkRenderSettings() {
            return Objects.hash(meshGenerator, forceVisuals, extraSmoothMesh);
        }

        public static void updateSmoothable(boolean newValue, BlockState ... states) {
            Smoothables.updateSmoothables(newValue, states, (List)Server.INSTANCE.smoothableWhitelist.get(), (List)Server.INSTANCE.smoothableBlacklist.get());
            Server.saveAndLoad();
        }

        private static void saveAndLoad() {
            lastSavedServerConfigAt = -1L;
            Hacks.saveAndLoad(ModConfig.Type.SERVER);
            lastSavedServerConfigAt = System.nanoTime();
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Impl::new);
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Impl)specPair.getLeft();
        }

        static class Impl {
            final ForgeConfigSpec.ConfigValue<List<? extends String>> smoothableWhitelist;
            final ForgeConfigSpec.ConfigValue<List<? extends String>> smoothableBlacklist;
            final ForgeConfigSpec.EnumValue<MeshGeneratorEnum> meshGenerator;
            final ForgeConfigSpec.BooleanValue collisionsEnabled;
            final ForgeConfigSpec.BooleanValue forceVisuals;
            final ForgeConfigSpec.IntValue extendFluidsRange;
            final ForgeConfigSpec.DoubleValue oldNoCubesRoughness;
            final ForgeConfigSpec.BooleanValue extraSmoothMesh;

            private Impl(ForgeConfigSpec.Builder builder) {
                this.smoothableWhitelist = builder.translation("nocubes.config.smoothableWhitelist").comment("What blocks should be smoothed by NoCubes").defineListAllowEmpty(Collections.singletonList("smoothableWhitelist"), Lists::newArrayList, String.class::isInstance);
                this.smoothableBlacklist = builder.translation("nocubes.config.smoothableBlacklist").comment("What blocks should not be smoothed by NoCubes").defineListAllowEmpty(Collections.singletonList("smoothableBlacklist"), Lists::newArrayList, String.class::isInstance);
                this.collisionsEnabled = builder.translation("nocubes.config.collisionsEnabled").comment("If players should be able to walk up the smooth slopes generated by NoCubes").define("collisionsEnabled", true);
                this.meshGenerator = builder.translation("nocubes.config.meshGenerator").comment("meshGenerator").defineEnum("meshGenerator", (Enum)MeshGeneratorEnum.SurfaceNets);
                this.forceVisuals = builder.translation("nocubes.config.forceVisuals").comment(new String[]{"For MMO servers that require NoCubes to be enabled for a proper player experience.", "If you enable this make sure that you've manually checked that every chunk is navigable!"}).define("forceVisuals", false);
                this.extendFluidsRange = builder.translation("nocubes.config.extendFluidsRange").comment("The range at which to extend fluids (water & lava) into smoothable blocks").defineInRange("extendFluidsRange", 1, 0, 2);
                this.oldNoCubesRoughness = builder.translation("nocubes.config.oldNoCubesRoughness").comment("How much pseudo-random roughness should be applied to mesh generated by OldNoCubes").defineInRange("oldNoCubesRoughness", 0.5, 0.0, 1.0);
                this.extraSmoothMesh = builder.translation("nocubes.config.extraSmoothMesh").comment("If the mesh generated by SurfaceNets and MarchingCubes should be twice as smooth").define("extraSmoothMesh", false);
            }
        }

        public static enum MeshGeneratorEnum {
            SurfaceNets(new SurfaceNets()),
            OldNoCubes(new OldNoCubes()),
            Debug_MarchingCubes(new MarchingCubes()),
            Debug_CullingCubic(new CullingCubic()),
            Debug_StupidCubic(new StupidCubic()),
            Debug_CullingChamfer(new CullingChamfer());

            public final MeshGenerator generator;

            private MeshGeneratorEnum(MeshGenerator generator) {
                this.generator = generator;
            }
        }
    }

    public static class Smoothables {
        private static final Set<BlockState> DEFAULT_SMOOTHABLES = Sets.newIdentityHashSet();

        static void updateSmoothables(boolean newValue, BlockState[] states, List<String> whitelist, List<String> blacklist) {
            List<String> toAddTo = newValue ? whitelist : blacklist;
            List<String> toRemoveFrom = newValue ? blacklist : whitelist;
            for (BlockState state : states) {
                String string = BlockStateConverter.toString(state);
                NoCubes.smoothableHandler.setSmoothable(newValue, (BlockBehaviour.BlockStateBase)state);
                if (!toAddTo.contains(string)) {
                    toAddTo.add(string);
                }
                while (toRemoveFrom.remove(string)) {
                }
            }
        }

        static void recomputeInMemoryLookup(List<? extends String> whitelist, List<? extends String> blacklist) {
            Set<BlockState> whitelisted = Smoothables.parseBlockStates(whitelist);
            Set<BlockState> blacklisted = Smoothables.parseBlockStates(blacklist);
            ForgeRegistries.BLOCKS.getValues().parallelStream().flatMap(block -> ModUtil.getStates(block).parallelStream()).forEach(state -> {
                if (blacklisted.contains(state)) {
                    NoCubes.smoothableHandler.removeSmoothable((BlockBehaviour.BlockStateBase)state);
                } else if (whitelisted.contains(state) || DEFAULT_SMOOTHABLES.contains(state)) {
                    NoCubes.smoothableHandler.addSmoothable((BlockBehaviour.BlockStateBase)state);
                }
            });
        }

        static Set<BlockState> parseBlockStates(List<? extends String> list) {
            Set set = Sets.newIdentityHashSet();
            list.parallelStream().map(BlockStateConverter::fromStringOrNull).filter(Objects::nonNull).forEach(set::add);
            return set;
        }

        public static void addDefault(BlockState ... states) {
            DEFAULT_SMOOTHABLES.addAll(Arrays.asList(states));
        }

        static {
            DEFAULT_SMOOTHABLES.addAll(Arrays.stream(new Block[]{Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50440_, Blocks.f_50493_, Blocks.f_50546_, Blocks.f_50599_, Blocks.f_50195_, Blocks.f_152550_, Blocks.f_152549_, Blocks.f_152496_, Blocks.f_152497_, Blocks.f_152597_, Blocks.f_152490_, Blocks.f_152491_, Blocks.f_50752_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_50062_, Blocks.f_50394_, Blocks.f_49994_, Blocks.f_49997_, Blocks.f_49996_, Blocks.f_152505_, Blocks.f_49995_, Blocks.f_50173_, Blocks.f_50089_, Blocks.f_50059_, Blocks.f_50264_, Blocks.f_50331_, Blocks.f_49998_, Blocks.f_152469_, Blocks.f_152468_, Blocks.f_152506_, Blocks.f_152467_, Blocks.f_152473_, Blocks.f_152474_, Blocks.f_152472_, Blocks.f_152479_, Blocks.f_50226_, Blocks.f_152596_, Blocks.f_50453_, Blocks.f_152481_, Blocks.f_50129_, Blocks.f_50352_, Blocks.f_50287_, Blocks.f_50288_, Blocks.f_50289_, Blocks.f_50290_, Blocks.f_50291_, Blocks.f_50292_, Blocks.f_50293_, Blocks.f_50294_, Blocks.f_50295_, Blocks.f_50296_, Blocks.f_50297_, Blocks.f_50298_, Blocks.f_50299_, Blocks.f_50300_, Blocks.f_50301_, Blocks.f_50302_, Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50449_, Blocks.f_50134_, Blocks.f_50135_, Blocks.f_50136_, Blocks.f_50137_, Blocks.f_50450_, Blocks.f_50141_, Blocks.f_50451_, Blocks.f_50695_, Blocks.f_50690_, Blocks.f_50692_, Blocks.f_50686_, Blocks.f_50259_, Blocks.f_49999_, Blocks.f_50000_, Blocks.f_50001_, Blocks.f_50002_, Blocks.f_50003_, Blocks.f_50004_, Blocks.f_50050_, Blocks.f_50051_, Blocks.f_50052_, Blocks.f_50053_, Blocks.f_50054_, Blocks.f_50055_}).flatMap(block -> ModUtil.getStates(block).stream()).collect(Collectors.toList()));
            DEFAULT_SMOOTHABLES.addAll(Arrays.stream(new BlockState[0]).collect(Collectors.toList()));
            DEFAULT_SMOOTHABLES.addAll(Smoothables.parseBlockStates(Arrays.asList("biomesoplenty:grass[snowy=false,variant=sandy]", "biomesoplenty:dirt[coarse=false,variant=sandy]", "biomesoplenty:white_sand", "biomesoplenty:grass[snowy=false,variant=silty]", "biomesoplenty:dirt[coarse=false,variant=loamy]", "biomesoplenty:grass[snowy=false,variant=loamy]", "biomesoplenty:dried_sand", "biomesoplenty:hard_ice", "biomesoplenty:mud[variant=mud]", "biomesoplenty:dirt[coarse=false,variant=silty]", "chisel:marble2[variation=7]", "chisel:limestone2[variation=7]", "dynamictrees:rootydirtspecies[life=0]", "dynamictrees:rootysand[life=0]", "iceandfire:ash", "iceandfire:sapphire_ore", "iceandfire:chared_grass", "iceandfire:chared_stone", "iceandfire:frozen_grass_path", "notenoughroofs:copper_ore", "rustic:slate")));
        }
    }

    public static class Hacks {
        static void saveAndLoad(ModConfig.Type type) {
            Hacks.ConfigTracker_getConfig("nocubes", type).ifPresent(modConfig -> {
                modConfig.save();
                ((CommentedFileConfig)modConfig.getConfigData()).load();
                modConfig.getSpec().afterReload();
                Hacks.ModConfig_fireEvent(modConfig, IConfigEvent.reloading((ModConfig)modConfig));
            });
        }

        public static void loadDefaultServerConfig() {
            Hacks.ConfigTracker_getConfig("nocubes", ModConfig.Type.SERVER).ifPresent(modConfig -> {
                CommentedConfig config = CommentedConfig.inMemory();
                modConfig.getSpec().correct(config);
                Hacks.ModConfig_setConfigData(modConfig, config);
                Hacks.ModConfig_fireEvent(modConfig, IConfigEvent.loading((ModConfig)modConfig));
            });
        }

        private static Optional<ModConfig> ConfigTracker_getConfig(String modId, ModConfig.Type type) {
            Map configsByMod = (Map)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"configsByMod");
            return Optional.ofNullable(configsByMod.getOrDefault(modId, Collections.emptyMap()).getOrDefault(type, null));
        }

        private static void ModConfig_setConfigData(ModConfig modConfig, CommentedConfig data) {
            Method setConfigData = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
            try {
                setConfigData.invoke((Object)modConfig, data);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not set config data for config " + modConfig, e);
            }
        }

        private static void ModConfig_fireEvent(ModConfig modConfig, IConfigEvent event) {
            ((ModContainer)ModList.get().getModContainerById(modConfig.getModId()).get()).dispatchConfigEvent(event);
        }

        public static void receiveSyncedServerConfig(S2CUpdateServerConfig s2CConfigData) {
            assert (FMLEnvironment.dist.isClient());
            ModConfig modConfig = Hacks.ConfigTracker_getConfig("nocubes", ModConfig.Type.SERVER).get();
            ConfigParser parser = modConfig.getConfigData().configFormat().createParser();
            Hacks.ModConfig_setConfigData(modConfig, (CommentedConfig)parser.parse((InputStream)new ByteArrayInputStream(s2CConfigData.getBytes())));
            Hacks.ModConfig_fireEvent(modConfig, IConfigEvent.reloading((ModConfig)modConfig));
        }
    }
}

