/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import io.github.cadiboo.nocubes.repackage.org.beryx.awt.color.ColorFactory;

public final class ColorParser {
    public static Color parse(String color) {
        java.awt.Color parsed = ColorFactory.valueOf(color);
        return new Color(parsed.getRed(), parsed.getGreen(), parsed.getBlue(), parsed.getAlpha());
    }

    public static class Color {
        public final int red;
        public final int green;
        public final int blue;
        public final int alpha;

        public Color(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public Color(float red, float green, float blue, float alpha) {
            this((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
        }

        public int toRGBA() {
            return this.red << 24 | this.green << 16 | this.blue << 8 | this.alpha << 0;
        }

        public int toARGB() {
            return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue << 0;
        }
    }
}

