/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.OldNoCubes;
import io.github.cadiboo.nocubes.mesh.SurfaceNets;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class CollisionHandler {
    public static VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos blockPos, CollisionContext context) {
        boolean canCollide = state.m_60734_().f_60443_;
        try {
            return CollisionHandler.getCollisionShapeOrThrow(canCollide, state, reader, blockPos, (EntityCollisionContext)context);
        }
        catch (Throwable t) {
            if (!((Boolean)ModUtil.IS_DEVELOPER_WORKSPACE.get()).booleanValue()) {
                throw t;
            }
            return canCollide ? Shapes.m_83144_() : Shapes.m_83040_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VoxelShape getCollisionShapeOrThrow(boolean canCollide, BlockState state, BlockGetter reader, BlockPos blockPos, EntityCollisionContext context) {
        if (!canCollide) {
            return Shapes.m_83040_();
        }
        assert (NoCubesConfig.Server.collisionsEnabled);
        assert (NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state));
        Entity entity = context.m_193113_();
        if (entity instanceof FallingBlockEntity || entity == null || reader.m_8055_(blockPos) != state) {
            return state.m_60808_(reader, blockPos);
        }
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        VoxelShape[] ref = new VoxelShape[]{Shapes.m_83040_()};
        if (reader instanceof Level) {
            ((Level)reader).m_46473_().m_6180_("NoCubes collisions");
        }
        try (Area area = new Area(reader, blockPos, ModUtil.VEC_ONE, generator);){
            float dx = MeshGenerator.validateMeshOffset(area.start.m_123341_() - blockPos.m_123341_());
            float dy = MeshGenerator.validateMeshOffset(area.start.m_123342_() - blockPos.m_123342_());
            float dz = MeshGenerator.validateMeshOffset(area.start.m_123343_() - blockPos.m_123343_());
            CollisionHandler.generate(area, generator, (x0, y0, z0, x1, y1, z1) -> {
                VoxelShape shape = Shapes.m_83048_((double)((double)dx + x0), (double)((double)dy + y0), (double)((double)dz + z0), (double)((double)dx + x1), (double)((double)dy + y1), (double)((double)dz + z1));
                ref[0] = Shapes.m_83148_((VoxelShape)ref[0], (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
                return true;
            });
        }
        finally {
            if (reader instanceof Level) {
                ((Level)reader).m_46473_().m_7238_();
            }
        }
        return ref[0];
    }

    public static Deque<VoxelShape> createNoCubesIntersectingCollisionList(CollisionGetter world, AABB area, BlockPos.MutableBlockPos pos) {
        ArrayDeque<VoxelShape> shapes = new ArrayDeque<VoxelShape>();
        int minX = Mth.m_14107_((double)(area.f_82288_ - 1.0E-7)) - 1;
        int maxX = Mth.m_14107_((double)(area.f_82291_ + 1.0E-7)) + 1;
        int minY = Mth.m_14107_((double)(area.f_82289_ - 1.0E-7)) - 1;
        int maxY = Mth.m_14107_((double)(area.f_82292_ + 1.0E-7)) + 1;
        int minZ = Mth.m_14107_((double)(area.f_82290_ - 1.0E-7)) - 1;
        int maxZ = Mth.m_14107_((double)(area.f_82293_ + 1.0E-7)) + 1;
        CollisionHandler.forEachCollisionRelativeToStart(world, pos, minX, maxX, minY, maxY, minZ, maxZ, (x0, y0, z0, x1, y1, z1) -> {
            if (area.m_82314_(x0 += (double)minX, y0 += (double)minY, z0 += (double)minZ, x1 += (double)minX, y1 += (double)minY, z1 += (double)minZ)) {
                shapes.add(Shapes.m_83048_((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
            }
            return true;
        });
        return shapes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double collideAxisInArea(AABB aabb, LevelReader world, double motion, CollisionContext ctx, AxisCycle rotation, AxisCycle inverseRotation, BlockPos.MutableBlockPos pos, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        if (world instanceof Level) {
            ((Level)world).m_46473_().m_6180_("NoCubes collisions");
        }
        try {
            double[] motionRef = new double[]{motion};
            Direction.Axis axis = inverseRotation.m_7314_(Direction.Axis.Z);
            Predicate<VoxelShape> predicate = shape -> {
                assert (Math.abs(motionRef[0]) >= 1.0E-7);
                motionRef[0] = shape.m_83259_(axis, aabb, motionRef[0]);
                if (Math.abs(motionRef[0]) < 1.0E-7) {
                    motionRef[0] = 0.0;
                    return false;
                }
                return true;
            };
            CollisionHandler.forEachCollisionShapeRelativeToStart((CollisionGetter)world, pos, minX, maxX, minY, maxY, Math.min(minZ, maxZ), Math.max(minZ, maxZ), predicate);
            double d = motionRef[0];
            return d;
        }
        catch (Throwable t) {
            if (!((Boolean)ModUtil.IS_DEVELOPER_WORKSPACE.get()).booleanValue()) {
                throw t;
            }
            double d = motion;
            return d;
        }
        finally {
            if (world instanceof Level) {
                ((Level)world).m_46473_().m_7238_();
            }
        }
    }

    public static void forEachCollisionShapeRelativeToStart(CollisionGetter world, BlockPos.MutableBlockPos pos, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, Predicate<VoxelShape> predicate) {
        CollisionHandler.forEachCollisionRelativeToStart(world, pos, minX, maxX, minY, maxY, minZ, maxZ, (x0, y0, z0, x1, y1, z1) -> predicate.test(Shapes.m_83048_((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1)));
    }

    public static void forEachCollisionRelativeToStart(CollisionGetter world, BlockPos.MutableBlockPos pos, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, IShapeConsumer consumer) {
        assert (NoCubesConfig.Server.collisionsEnabled);
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        BlockPos start = new BlockPos(minX, minY, minZ);
        BlockPos.MutableBlockPos size = pos.m_122178_(maxX - minX, maxY - minY, maxZ - minZ);
        try (Area area = new Area((BlockGetter)world, start, (BlockPos)size, generator);){
            double dx = MeshGenerator.validateMeshOffset(area.start.m_123341_() - start.m_123341_());
            double dy = MeshGenerator.validateMeshOffset(area.start.m_123342_() - start.m_123342_());
            double dz = MeshGenerator.validateMeshOffset(area.start.m_123343_() - start.m_123343_());
            CollisionHandler.generate(area, generator, (x0, y0, z0, x1, y1, z1) -> consumer.accept(dx + x0, dy + y0, dz + z0, dx + x1, dy + y1, dz + z1));
        }
    }

    public static void generate(Area area, MeshGenerator generator, IShapeConsumer consumer) {
        Face vertexNormals = new Face();
        Vec faceNormal = new Vec();
        Vec centre = new Vec();
        Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
        generator.generate(area, isSmoothable, (pos, amount) -> {
            if (amount == 1.0f) {
                float x0 = pos.m_123341_();
                float y0 = pos.m_123342_();
                float z0 = pos.m_123343_();
                if (!NoCubesConfig.Server.extraSmoothMesh && generator instanceof SurfaceNets) {
                    x0 += 0.5f;
                    y0 += 0.5f;
                    z0 += 0.5f;
                }
                return consumer.accept(x0, y0, z0, x0 + 1.0f, y0 + 1.0f, z0 + 1.0f);
            }
            return true;
        }, (pos, face) -> {
            face.assignAverageTo(centre);
            face.assignNormalTo(vertexNormals);
            vertexNormals.assignAverageTo(faceNormal);
            if (generator instanceof OldNoCubes) {
                faceNormal.multiply(1.0E-5f);
            }
            if (!CollisionHandler.generateShape(centre, faceNormal, consumer, face.v0)) {
                return false;
            }
            if (!CollisionHandler.generateShape(centre, faceNormal, consumer, face.v1)) {
                return false;
            }
            if (!CollisionHandler.generateShape(centre, faceNormal, consumer, face.v2)) {
                return false;
            }
            return CollisionHandler.generateShape(centre, faceNormal, consumer, face.v3);
        });
    }

    private static boolean generateShape(Vec centre, Vec faceNormal, IShapeConsumer consumer, Vec v) {
        float vX = v.x;
        float vY = v.y;
        float vZ = v.z;
        float extX = centre.x + faceNormal.x;
        float extY = centre.y + faceNormal.y;
        float extZ = centre.z + faceNormal.z;
        return consumer.accept(Math.min(vX, extX), Math.min(vY, extY), Math.min(vZ, extZ), Math.max(vX, extX), Math.max(vY, extY), Math.max(vZ, extZ));
    }

    public static interface IShapeConsumer {
        public boolean accept(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

