/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.RollingProfiler;
import io.github.cadiboo.nocubes.client.render.LightCache;
import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.config.ColorParser;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class OverlayRenderer {
    private static final RollingProfiler meshProfiler = new RollingProfiler(600);

    @SubscribeEvent
    public static void onHighlightBlock(DrawSelectionEvent.HighlightBlock event) {
        if (!NoCubesConfig.Client.render) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        BlockPos lookingAtPos = event.getTarget().m_82425_();
        BlockState state = world.m_8055_(lookingAtPos);
        if (!NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return;
        }
        event.setCanceled(true);
        Vec3 camera = event.getCamera().m_90583_();
        PoseStack matrix = event.getPoseStack();
        VertexConsumer buffer = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        boolean stateSolidity = MeshRenderer.isSolidRender(state);
        try (Area area = new Area((BlockGetter)world, lookingAtPos, ModUtil.VEC_ONE, generator);){
            ColorParser.Color color = NoCubesConfig.Client.selectionBoxColor;
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            generator.generate(area, s -> isSmoothable.test((BlockState)s) && MeshRenderer.isSolidRender(s) == stateSolidity, (pos, face) -> {
                OverlayRenderer.drawFacePosColor(face, camera, area.start, color, buffer, matrix);
                return true;
            });
        }
    }

    @SubscribeEvent
    public static void onRenderLevelLastEvent(RenderLevelLastEvent event) {
        if (!NoCubesConfig.Client.debugEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        if (world == null) {
            return;
        }
        Camera cameraInfo = minecraft.f_91063_.m_109153_();
        Entity viewer = cameraInfo.m_90592_();
        if (viewer == null) {
            return;
        }
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        Vec3 camera = cameraInfo.m_90583_();
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        VertexConsumer bufferBuilder = bufferSource.m_6299_(RenderType.m_110504_());
        HitResult targeted = viewer.m_19907_(20.0, 0.0f, false);
        BlockPos targetedPos = targeted.m_6662_() != HitResult.Type.BLOCK ? viewer.m_142538_() : ((BlockHitResult)targeted).m_82425_();
        Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
        if (NoCubesConfig.Client.debugOutlineSmoothables) {
            ColorParser.Color color = new ColorParser.Color(0.0f, 1.0f, 0.0f, 0.4f);
            BlockPos start = viewer.m_142538_().m_142082_(-5, -5, -5);
            BlockPos end = viewer.m_142538_().m_142082_(5, 5, 5);
            BlockPos.m_121940_((BlockPos)start, (BlockPos)end).forEach(pos -> {
                if (isSmoothable.test(viewer.f_19853_.m_8055_(pos))) {
                    OverlayRenderer.drawShape(matrixStack, bufferBuilder, Shapes.m_83144_(), pos, camera, color);
                }
            });
        }
        if (NoCubesConfig.Client.debugVisualiseDensitiesGrid) {
            VoxelShape distanceIndicator = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)0.125, (double)0.125);
            ColorParser.Color densityColor = new ColorParser.Color(0.0f, 0.0f, 1.0f, 0.5f);
            try (Area area = new Area((BlockGetter)world, targetedPos.m_142082_(-2, -2, -2), new BlockPos(4, 4, 4), generator);){
                BlockState[] states = area.getAndCacheBlocks();
                float[] densities = new float[area.numBlocks()];
                for (int i = 0; i < densities.length; ++i) {
                    densities[i] = ModUtil.getBlockDensity(isSmoothable, states[i]);
                }
                int minZ = area.start.m_123343_();
                int minY = area.start.m_123342_();
                int minX = area.start.m_123341_();
                int width = area.size.m_123341_();
                int height = area.size.m_123342_();
                int maxZ = minZ + area.size.m_123343_();
                int maxY = minY + height;
                int maxX = minX + width;
                int zyxIndex = 0;
                BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
                for (int z = minZ; z < maxZ; ++z) {
                    for (int y = minY; y < maxY; ++y) {
                        int x = minX;
                        while (x < maxX) {
                            pos2.m_122178_(x, y, z);
                            float density = densities[zyxIndex];
                            float densityScale = 0.5f + density / 2.0f;
                            if ((double)densityScale > 0.01) {
                                VoxelShape box = Shapes.m_83048_((double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)));
                                OverlayRenderer.drawShape(matrixStack, bufferBuilder, box, (BlockPos)pos2, camera, densityColor);
                            }
                            if (x > minX && y > minY && z > minZ) {
                                float combinedDensity = 0.0f;
                                int idx = zyxIndex;
                                int cornerZ = 0;
                                while (cornerZ < 2) {
                                    int cornerY = 0;
                                    while (cornerY < 2) {
                                        int cornerX = 0;
                                        while (cornerX < 2) {
                                            combinedDensity += densities[idx];
                                            cornerX = (byte)(cornerX + 1);
                                            --idx;
                                        }
                                        ++cornerY;
                                        idx -= width - 2;
                                    }
                                    ++cornerZ;
                                    idx -= width * (height - 2);
                                }
                                float combinedDensityScale = 0.5f + combinedDensity / 16.0f;
                                OverlayRenderer.drawShape(matrixStack, bufferBuilder, distanceIndicator, (BlockPos)pos2, camera, new ColorParser.Color(combinedDensityScale, 1.0f - combinedDensityScale, 0.0f, 0.4f));
                            }
                            ++x;
                            ++zyxIndex;
                        }
                    }
                }
            }
        }
        int collisionsRenderRadius = 10;
        if (NoCubesConfig.Client.debugRenderCollisions) {
            ColorParser.Color intersectingColor = new ColorParser.Color(1.0f, 0.0f, 0.0f, 0.4f);
            ColorParser.Color deviatingColor = new ColorParser.Color(0.0f, 1.0f, 0.0f, 0.4f);
            VoxelShape viewerShape = Shapes.m_83064_((AABB)viewer.m_142469_());
            world.m_186434_(viewer, viewer.m_142469_().m_82400_(10.0)).forEach(voxelShape -> {
                boolean intersects = Shapes.m_83157_((VoxelShape)voxelShape, (VoxelShape)viewerShape, (BooleanOp)BooleanOp.f_82689_);
                OverlayRenderer.drawShape(matrixStack, bufferBuilder, voxelShape, BlockPos.f_121853_, camera, intersects ? intersectingColor : deviatingColor);
            });
        }
        if (NoCubesConfig.Client.debugRenderMeshCollisions) {
            ColorParser.Color color = new ColorParser.Color(NoCubesConfig.Client.debugRenderCollisions ? 1.0f : 0.0f, 1.0f, 0.0f, 0.4f);
            BlockPos start = viewer.m_142538_().m_142082_(-10, -10, -10);
            CollisionHandler.forEachCollisionShapeRelativeToStart((CollisionGetter)world, new BlockPos.MutableBlockPos(), start.m_123341_(), start.m_123341_() + 20, start.m_123342_(), start.m_123342_() + 20, start.m_123343_(), start.m_123343_() + 20, shape -> {
                OverlayRenderer.drawShape(matrixStack, bufferBuilder, shape, start, camera, color);
                return true;
            });
        }
        if (NoCubesConfig.Client.debugRecordMeshPerformance || NoCubesConfig.Client.debugOutlineNearbyMesh) {
            long startNanos = System.nanoTime();
            OverlayRenderer.drawNearbyMesh(viewer, matrixStack, camera, bufferBuilder);
            if (NoCubesConfig.Client.debugRecordMeshPerformance && meshProfiler.recordElapsedNanos(startNanos)) {
                LogManager.getLogger((String)("Calc" + (NoCubesConfig.Client.debugOutlineNearbyMesh ? " & outline" : "") + " nearby mesh")).debug("Average {}ms over the past {} frames", (Object)(meshProfiler.average() / 1000000.0), (Object)meshProfiler.size());
            }
        }
        bufferSource.m_109912_(RenderType.m_110504_());
    }

    private static void drawNearbyMesh(Entity viewer, PoseStack matrix, Vec3 camera, VertexConsumer buffer) {
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        BlockPos meshSize = new BlockPos(16, 16, 16);
        BlockPos meshStart = viewer.m_142538_().m_142082_(-meshSize.m_123341_() / 2, -meshSize.m_123342_() / 2 + 2, -meshSize.m_123343_() / 2);
        try (Area area = new Area((BlockGetter)viewer.f_19853_, meshStart, meshSize, generator);
             LightCache light = new LightCache((ClientLevel)viewer.f_19853_, meshStart, meshSize);){
            MeshRenderer.FaceInfo faceInfo = new MeshRenderer.FaceInfo();
            MeshRenderer.MutableObjects objects = new MeshRenderer.MutableObjects();
            Vec mutable = new Vec();
            ColorParser.Color faceColor = new ColorParser.Color(0.0f, 1.0f, 1.0f, 0.4f);
            ColorParser.Color normalColor = new ColorParser.Color(0.0f, 0.0f, 1.0f, 0.2f);
            ColorParser.Color averageNormalColor = new ColorParser.Color(1.0f, 0.0f, 0.0f, 0.4f);
            ColorParser.Color normalDirectionColor = new ColorParser.Color(0.0f, 1.0f, 0.0f, 1.0f);
            ColorParser.Color lightColor = new ColorParser.Color(1.0f, 1.0f, 0.0f, 1.0f);
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            generator.generate(area, isSmoothable, (pos, face) -> {
                if (!NoCubesConfig.Client.debugOutlineNearbyMesh) {
                    return true;
                }
                OverlayRenderer.drawFacePosColor(face, camera, area.start, faceColor, buffer, matrix);
                faceInfo.setup(face);
                float dirMul = 0.2f;
                OverlayRenderer.drawLinePosColorFromAdd(area.start, faceInfo.centre, mutable.set(faceInfo.normal).multiply(0.2f), averageNormalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, faceInfo.centre, mutable.set(faceInfo.approximateDirection.m_122429_(), faceInfo.approximateDirection.m_122430_(), faceInfo.approximateDirection.m_122431_()).multiply(0.2f), normalDirectionColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v0, mutable.set(faceInfo.vertexNormals.v0).multiply(0.2f), normalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v1, mutable.set(faceInfo.vertexNormals.v1).multiply(0.2f), normalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v2, mutable.set(faceInfo.vertexNormals.v2).multiply(0.2f), normalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v3, mutable.set(faceInfo.vertexNormals.v3).multiply(0.2f), normalColor, buffer, matrix, camera);
                mutable.set(0.5f, 0.5f, 0.5f);
                MeshRenderer.RenderableState.findAt(objects, area, faceInfo.normal, faceInfo.centre, isSmoothable);
                pos.m_122193_((Vec3i)area.start);
                OverlayRenderer.drawLinePosColorFromTo(area.start, faceInfo.centre, (BlockPos)pos, mutable, lightColor, buffer, matrix, camera);
                return true;
            });
        }
    }

    private static void drawLinePosColorFromAdd(BlockPos offset, Vec start, Vec add, ColorParser.Color color, VertexConsumer buffer, PoseStack matrix, Vec3 camera) {
        float startX = (float)((double)offset.m_123341_() - camera.f_82479_ + (double)start.x);
        float startY = (float)((double)offset.m_123342_() - camera.f_82480_ + (double)start.y);
        float startZ = (float)((double)offset.m_123343_() - camera.f_82481_ + (double)start.z);
        ClientUtil.lineVertex(buffer, matrix, startX, startY, startZ, color);
        ClientUtil.lineVertex(buffer, matrix, startX + add.x, startY + add.y, startZ + add.z, color);
    }

    private static void drawLinePosColorFromTo(BlockPos startOffset, Vec start, BlockPos endOffset, Vec end, ColorParser.Color color, VertexConsumer buffer, PoseStack matrix, Vec3 camera) {
        ClientUtil.lineVertex(buffer, matrix, (float)((double)((float)startOffset.m_123341_() + start.x) - camera.f_82479_), (float)((double)((float)startOffset.m_123342_() + start.y) - camera.f_82480_), (float)((double)((float)startOffset.m_123343_() + start.z) - camera.f_82481_), color);
        ClientUtil.lineVertex(buffer, matrix, (float)((double)((float)endOffset.m_123341_() + end.x) - camera.f_82479_), (float)((double)((float)endOffset.m_123342_() + end.y) - camera.f_82480_), (float)((double)((float)endOffset.m_123343_() + end.z) - camera.f_82481_), color);
    }

    private static void drawFacePosColor(Face face, Vec3 camera, BlockPos pos, ColorParser.Color color, VertexConsumer buffer, PoseStack matrix) {
        Vec v0 = face.v0;
        Vec v1 = face.v1;
        Vec v2 = face.v2;
        Vec v3 = face.v3;
        double x = (double)pos.m_123341_() - camera.f_82479_;
        double y = (double)pos.m_123342_() - camera.f_82480_;
        double z = (double)pos.m_123343_() - camera.f_82481_;
        float v0x = (float)(x + (double)v0.x);
        float v1x = (float)(x + (double)v1.x);
        float v2x = (float)(x + (double)v2.x);
        float v3x = (float)(x + (double)v3.x);
        float v0y = (float)(y + (double)v0.y);
        float v1y = (float)(y + (double)v1.y);
        float v2y = (float)(y + (double)v2.y);
        float v3y = (float)(y + (double)v3.y);
        float v0z = (float)(z + (double)v0.z);
        float v1z = (float)(z + (double)v1.z);
        float v2z = (float)(z + (double)v2.z);
        float v3z = (float)(z + (double)v3.z);
        ClientUtil.lineVertex(buffer, matrix, v0x, v0y, v0z, color);
        ClientUtil.lineVertex(buffer, matrix, v1x, v1y, v1z, color);
        ClientUtil.lineVertex(buffer, matrix, v1x, v1y, v1z, color);
        ClientUtil.lineVertex(buffer, matrix, v2x, v2y, v2z, color);
        ClientUtil.lineVertex(buffer, matrix, v2x, v2y, v2z, color);
        ClientUtil.lineVertex(buffer, matrix, v3x, v3y, v3z, color);
        ClientUtil.lineVertex(buffer, matrix, v3x, v3y, v3z, color);
        ClientUtil.lineVertex(buffer, matrix, v0x, v0y, v0z, color);
    }

    private static void drawShape(PoseStack stack, VertexConsumer buffer, VoxelShape shape, BlockPos pos, Vec3 camera, ColorParser.Color color) {
        double x = (double)pos.m_123341_() - camera.f_82479_;
        double y = (double)pos.m_123342_() - camera.f_82480_;
        double z = (double)pos.m_123343_() - camera.f_82481_;
        shape.m_83224_((x0, y0, z0, x1, y1, z1) -> {
            ClientUtil.lineVertex(buffer, stack, (float)(x + x0), (float)(y + y0), (float)(z + z0), color);
            ClientUtil.lineVertex(buffer, stack, (float)(x + x1), (float)(y + y1), (float)(z + z1), color);
        });
    }

    private static /* synthetic */ void lambda$onRenderLevelLastEvent$2(Minecraft minecraft, int[] i, BlockPos pos) {
        int n = i[0];
        i[0] = n + 1;
        minecraft.f_91060_.m_109774_(100 + n, pos, 9);
    }
}

