/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.client.render.struct.FaceLight;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.ThreadLocalArrayCache;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.Arrays;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public final class LightCache
implements AutoCloseable {
    public static final int MAX_BRIGHTNESS = LightTexture.m_109885_((int)15, (int)15);
    private static final ThreadLocalArrayCache<int[]> CACHE = new ThreadLocalArrayCache<int[]>(int[]::new, array -> ((int[])array).length, LightCache::resetIntArray);
    public final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    public final BlockPos start;
    public final BlockPos size;
    private final ClientLevel world;
    private int[] array;

    public LightCache(ClientLevel world, BlockPos meshStart, BlockPos meshSize) {
        this.world = world;
        this.start = meshStart.m_142082_(-1, -1, -1).m_7949_();
        this.size = meshSize.m_142082_(2, 2, 2).m_7949_();
    }

    private static void resetIntArray(int[] array, int length) {
        Arrays.fill(array, 0, length, -1);
    }

    public BlockPos.MutableBlockPos lightWorldPos(BlockPos relativeTo, Vec vec, Vec normal) {
        float vx = -0.5f + vec.x + Mth.m_14036_((float)(normal.x * 4.0f), (float)-1.0f, (float)1.0f);
        float vy = -0.5f + vec.y + Mth.m_14036_((float)(normal.y * 4.0f), (float)-1.0f, (float)1.0f);
        float vz = -0.5f + vec.z + Mth.m_14036_((float)(normal.z * 4.0f), (float)-1.0f, (float)1.0f);
        int x = Math.round(vx);
        int y = Math.round(vy);
        int z = Math.round(vz);
        return this.mutablePos.m_122190_((Vec3i)relativeTo).m_122184_(x, y, z);
    }

    public FaceLight get(BlockPos relativeTo, MeshRenderer.FaceInfo faceInfo, FaceLight faceLight) {
        return this.get(relativeTo, faceInfo.face, faceInfo.normal, faceLight);
    }

    public FaceLight get(BlockPos relativeTo, Face face, Vec faceNormal, FaceLight faceLight) {
        faceLight.v0 = this.get(relativeTo, face.v0, faceNormal);
        faceLight.v1 = this.get(relativeTo, face.v1, faceNormal);
        faceLight.v2 = this.get(relativeTo, face.v2, faceNormal);
        faceLight.v3 = this.get(relativeTo, face.v3, faceNormal);
        return faceLight;
    }

    public int get(BlockPos relativeTo, Vec vec, Vec faceNormal) {
        BlockPos.MutableBlockPos lightWorldPos = this.lightWorldPos(relativeTo, vec, faceNormal);
        int light = this.get((BlockPos)lightWorldPos);
        if (light == 0) {
            light = this.get((BlockPos)lightWorldPos.m_122184_(0, -1, 0));
        }
        if (light == 0) {
            light = this.get((BlockPos)lightWorldPos.m_122184_(0, 2, 0));
        }
        if (light == 0) {
            light = this.get((BlockPos)lightWorldPos.m_122184_(-1, -1, 0));
        }
        if (light == 0) {
            light = this.get((BlockPos)lightWorldPos.m_122184_(2, 0, 0));
        }
        if (light == 0) {
            light = this.get((BlockPos)lightWorldPos.m_122184_(-1, 0, -1));
        }
        if (light == 0) {
            light = this.get((BlockPos)lightWorldPos.m_122184_(0, 0, 2));
        }
        return light;
    }

    private int max(int a, int b, int c, int d, int e, int f, int g, int h) {
        int max = a;
        if (b > max) {
            max = b;
        }
        if (c > max) {
            max = c;
        }
        if (d > max) {
            max = d;
        }
        if (e > max) {
            max = e;
        }
        if (f > max) {
            max = f;
        }
        if (g > max) {
            max = g;
        }
        if (h > max) {
            max = h;
        }
        return max;
    }

    private static int triLerp(int l000, int l001, int l010, int l011, int l100, int l101, int l110, int l111, float x, float y, float z) {
        return LightCache.lerp(LightCache.biLerp(l000, l001, l010, l011, y, z), LightCache.biLerp(l100, l101, l110, l111, y, z), x);
    }

    private static int biLerp(int l00, int l10, int l01, int l11, float y, float z) {
        return LightCache.lerp(LightCache.lerp(l00, l10, y), LightCache.lerp(l01, l11, y), z);
    }

    private static int lerp(int a, int b, float t) {
        return Math.round((float)a + t * (float)(b - a));
    }

    private int get(BlockPos worldPos) {
        int index = this.indexIfInsideCache(worldPos);
        if (index == -1) {
            return this.fetchCombinedLight(worldPos);
        }
        int[] array = this.getArray();
        int light = array[index];
        if (light == -1) {
            array[index] = light = this.fetchCombinedLight(worldPos);
        }
        return light;
    }

    private int fetchCombinedLight(BlockPos worldPos) {
        ClientLevel world = this.world;
        BlockState state = world.m_8055_(worldPos);
        return LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)worldPos);
    }

    private int[] getArray() {
        int[] array = this.array;
        if (array == null) {
            this.array = array = CACHE.takeArray(this.numBlocks());
        }
        return array;
    }

    private int numBlocks() {
        BlockPos size = this.size;
        return size.m_123341_() * size.m_123342_() * size.m_123343_();
    }

    private int indexIfInsideCache(BlockPos worldPos) {
        BlockPos start = this.start;
        BlockPos size = this.size;
        int x = worldPos.m_123341_() - start.m_123341_();
        int y = worldPos.m_123342_() - start.m_123342_();
        int z = worldPos.m_123343_() - start.m_123343_();
        if (x < 0 || x >= size.m_123341_() || y < 0 || y >= size.m_123342_() || z < 0 || z >= size.m_123343_()) {
            return -1;
        }
        return ModUtil.get3dIndexInto1dArray(x, y, z, size.m_123341_(), size.m_123342_());
    }

    @Override
    public void close() {
    }
}

