/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.optifine;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.cadiboo.nocubes.client.optifine.OptiFineProxy;
import io.github.cadiboo.nocubes.client.optifine.Reflector;
import io.github.cadiboo.nocubes.client.render.RendererDispatcher;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.coremod.api.ASMAPI;
import org.apache.logging.log4j.LogManager;

class HD_U_G8
implements OptiFineProxy {
    static final RenderType[] OVERLAY_LAYERS = new RenderType[]{RenderType.m_110463_(), RenderType.m_110457_(), RenderType.m_110466_()};

    HD_U_G8() {
    }

    @Override
    public boolean initialisedAndUsable() {
        for (Field field : Reflect.class.getDeclaredFields()) {
            try {
                if (field.get(null) != null) continue;
                LogManager.getLogger((String)"NoCubes OptiFine Compatibility").info("{}: Proxy not usable because reflection was unable to find field {}", (Object)this.getClass().getSimpleName(), (Object)field.getName());
                return false;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't access my own fields...?", e);
            }
        }
        return true;
    }

    @Override
    public void preRenderChunk(ChunkRenderDispatcher.RenderChunk chunkRender, BlockPos chunkPos, PoseStack matrix) {
        matrix.m_85837_((double)Reflect.ChunkRender_regionDX(chunkRender), (double)Reflect.ChunkRender_regionDY(chunkRender), (double)Reflect.ChunkRender_regionDZ(chunkRender));
    }

    @Override
    public long getSeed(long originalSeed) {
        return Reflect.Config_isAlternateBlocks() ? 0L : originalSeed;
    }

    @Override
    public Object preRenderBlock(ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack builder, BlockAndTintGetter chunkCacheOF, RenderType renderType, BufferBuilder buffer, BlockState state, BlockPos pos) {
        boolean shadersMidBlock;
        Reflect.BufferBuilder_setBlockLayer(buffer, renderType);
        Object renderEnv = Reflect.BufferBuilder_getRenderEnv(buffer, state, pos);
        Reflect.RenderEnv_setRegionRenderCacheBuilder(renderEnv, builder);
        Reflect.ChunkCacheOF_setRenderEnv(chunkCacheOF, renderEnv);
        boolean shaders = Reflect.Config_isShaders();
        boolean bl = shadersMidBlock = shaders && Reflect.Shaders_useMidBlockAttrib();
        if (shadersMidBlock) {
            Reflect.BufferBuilder_setMidBlock(buffer, 0.5f + (float)Reflect.ChunkRender_regionDX(chunkRender) + (float)(pos.m_123341_() & 0xF), 0.5f + (float)Reflect.ChunkRender_regionDY(chunkRender) + (float)(pos.m_123342_() & 0xF), 0.5f + (float)Reflect.ChunkRender_regionDZ(chunkRender) + (float)(pos.m_123343_() & 0xF));
        }
        if (shaders) {
            Reflect.SVertexBuilder_pushEntity(state, (VertexConsumer)buffer);
        }
        return renderEnv;
    }

    @Override
    public Object preRenderFluid(ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack buffers, BlockAndTintGetter chunkCache, RenderType layer, BufferBuilder buffer, BlockState block, FluidState fluid, BlockPos worldPos) {
        return this.preRenderBlock(chunkRender, buffers, chunkCache, layer, buffer, block, worldPos);
    }

    @Override
    public BakedModel getModel(Object renderEnv, BakedModel originalModel, BlockState state) {
        return Reflect.BlockModelCustomizer_getRenderModel(originalModel, state, renderEnv);
    }

    @Override
    public void postRenderBlock(Object renderEnv, BufferBuilder buffer, ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack builder, ChunkRenderDispatcher.CompiledChunk compiledChunk) {
        if (Reflect.Config_isShaders()) {
            Reflect.SVertexBuilder_popEntity((VertexConsumer)buffer);
        }
        if (Reflect.RenderEnv_isOverlaysRendered(renderEnv)) {
            Reflect.ChunkRender_postRenderOverlays(chunkRender, builder, compiledChunk);
            Reflect.RenderEnv_setOverlaysRendered(renderEnv, false);
        }
    }

    @Override
    public void postRenderFluid(Object renderEnv, BufferBuilder buffer, ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack builder, ChunkRenderDispatcher.CompiledChunk compiledChunk) {
        this.postRenderBlock(renderEnv, buffer, chunkRender, builder, compiledChunk);
    }

    @Override
    @Nullable
    public BakedQuad getQuadEmissive(BakedQuad quad) {
        return Reflect.BakedQuad_getQuadEmissive(quad);
    }

    @Override
    public void preRenderQuad(Object renderEnv, BakedQuad quad, BlockState state, BlockPos pos) {
        Reflect.RenderEnv_reset(renderEnv, state, pos);
    }

    @Override
    public void markRenderLayerUsed(ChunkRenderDispatcher.CompiledChunk compiledChunk, RenderType renderType) {
        Reflect.CompiledChunk_hasBlocks(compiledChunk).add(renderType);
        Reflect.ChunkLayerSet_add(Reflect.CompiledChunk_hasBlocks(compiledChunk), renderType);
    }

    @Override
    public List<BakedQuad> getQuadsAndStoreOverlays(List<BakedQuad> quads, BlockAndTintGetter world, BlockState state, BlockPos worldPos, Direction direction, RenderType layer, long rand, Object renderEnv) {
        return Reflect.BlockModelCustomizer_getRenderQuads(quads, world, state, worldPos, direction, layer, rand, renderEnv);
    }

    @Override
    public int forEachOverlayQuad(RendererDispatcher.ChunkRenderInfo renderer, BlockState state, BlockPos worldPos, RendererDispatcher.ChunkRenderInfo.ColorSupplier colorSupplier, RendererDispatcher.ChunkRenderInfo.QuadConsumer action, Object renderEnv) {
        int totalSize = 0;
        for (int i = 0; i < OVERLAY_LAYERS.length; ++i) {
            RenderType overlayLayer = OVERLAY_LAYERS[i];
            Object overlay = Reflect.RenderEnv_getListQuadsOverlay(renderEnv, overlayLayer);
            int size = Reflect.ListQuadsOverlay_size(overlay);
            if (size <= 0) continue;
            totalSize += size;
            BufferBuilder overlayBuffer = renderer.getAndStartBuffer(overlayLayer);
            for (int j = 0; j < size; ++j) {
                List<BakedQuad> quads = Reflect.ListQuadsOverlay_getListQuadsSingle(overlay, Reflect.ListQuadsOverlay_getQuad(overlay, j));
                BlockState overlayState = Reflect.ListQuadsOverlay_getBlockState(overlay, j);
                renderer.forEachQuad(quads, overlayState, worldPos, colorSupplier, overlayLayer, overlayBuffer, renderEnv, action);
                Reflect.RenderEnv_reset(renderEnv, overlayState, worldPos);
            }
            Reflect.ListQuadsOverlay_clear(overlay);
            renderer.markLayerUsed(overlayLayer);
        }
        return totalSize;
    }

    static interface Reflect {
        public static final Field VERSION = Reflector.tryGetField("net.optifine.Config", "VERSION");
        public static final MethodHandle isShaders = Reflector.tryGetMethod("net.optifine.Config", "isShaders", new Object[0]);
        public static final MethodHandle isAlternateBlocks = Reflector.tryGetMethod("net.optifine.Config", "isAlternateBlocks", new Object[0]);
        public static final Field useMidBlockAttrib = Reflector.tryGetField("net.optifine.shaders.Shaders", "useMidBlockAttrib");
        public static final MethodHandle pushEntity = Reflector.tryGetMethod("net.optifine.shaders.SVertexBuilder", "pushEntity", BlockState.class, VertexConsumer.class);
        public static final MethodHandle popEntity = Reflector.tryGetMethod("net.optifine.shaders.SVertexBuilder", "popEntity", VertexConsumer.class);
        public static final MethodHandle postRenderOverlays = Reflector.tryGetMethod("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$ChunkRender", "postRenderOverlays", ChunkBufferBuilderPack.class, ChunkRenderDispatcher.CompiledChunk.class);
        public static final Field regionDX = Reflector.tryGetField("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$ChunkRender", "regionDX");
        public static final Field regionDY = Reflector.tryGetField("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$ChunkRender", "regionDY");
        public static final Field regionDZ = Reflector.tryGetField("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$ChunkRender", "regionDZ");
        public static final MethodHandle getQuadEmissive = Reflector.tryGetMethod("net.minecraft.client.renderer.model.BakedQuad", "getQuadEmissive", new Object[0]);
        public static final MethodHandle setBlockLayer = Reflector.tryGetMethod("net.minecraft.client.renderer.BufferBuilder", "setBlockLayer", RenderType.class);
        public static final MethodHandle setMidBlock = Reflector.tryGetMethod("net.minecraft.client.renderer.BufferBuilder", "setMidBlock", Float.TYPE, Float.TYPE, Float.TYPE);
        public static final MethodHandle getRenderEnv = Reflector.tryGetMethod("net.minecraft.client.renderer.BufferBuilder", "getRenderEnv", BlockState.class, BlockPos.class);
        public static final MethodHandle reset = Reflector.tryGetMethod("net.optifine.render.RenderEnv", "reset", BlockState.class, BlockPos.class);
        public static final MethodHandle setRegionRenderCacheBuilder = Reflector.tryGetMethod("net.optifine.render.RenderEnv", "setRegionRenderCacheBuilder", ChunkBufferBuilderPack.class);
        public static final MethodHandle isOverlaysRendered = Reflector.tryGetMethod("net.optifine.render.RenderEnv", "isOverlaysRendered", new Object[0]);
        public static final MethodHandle setOverlaysRendered = Reflector.tryGetMethod("net.optifine.render.RenderEnv", "setOverlaysRendered", Boolean.TYPE);
        public static final MethodHandle getListQuadsOverlay = Reflector.tryGetMethod("net.optifine.render.RenderEnv", "getListQuadsOverlay", RenderType.class);
        public static final MethodHandle size = Reflector.tryGetMethod("net.optifine.model.ListQuadsOverlay", "size", new Object[0]);
        public static final MethodHandle clear = Reflector.tryGetMethod("net.optifine.model.ListQuadsOverlay", "clear", new Object[0]);
        public static final MethodHandle getQuad = Reflector.tryGetMethod("net.optifine.model.ListQuadsOverlay", "getQuad", Integer.TYPE);
        public static final MethodHandle getBlockState = Reflector.tryGetMethod("net.optifine.model.ListQuadsOverlay", "getBlockState", Integer.TYPE);
        public static final MethodHandle getListQuadsSingle = Reflector.tryGetMethod("net.optifine.model.ListQuadsOverlay", "getListQuadsSingle", BakedQuad.class);
        public static final MethodHandle setRenderEnv = Reflector.tryGetMethod("net.optifine.override.ChunkCacheOF", "setRenderEnv", "net.optifine.render.RenderEnv");
        public static final MethodHandle getRenderModel = Reflector.tryGetMethod("net.optifine.model.BlockModelCustomizer", "getRenderModel", BakedModel.class, BlockState.class, "net.optifine.render.RenderEnv");
        public static final MethodHandle getRenderQuads = Reflector.tryGetMethod("net.optifine.model.BlockModelCustomizer", "getRenderQuads", List.class, BlockAndTintGetter.class, BlockState.class, BlockPos.class, Direction.class, RenderType.class, Long.TYPE, "net.optifine.render.RenderEnv");
        public static final MethodHandle chunkLayerSet_add = Reflector.tryGetMethod("net.optifine.render.ChunkLayerSet", "add", RenderType.class);
        public static final Field hasBlocks = Reflector.tryGetField("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$CompiledChunk", ASMAPI.mapField((String)"f_112749_"));

        public static boolean Config_isShaders() {
            try {
                return isShaders.invokeExact();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static boolean Config_isAlternateBlocks() {
            try {
                return isAlternateBlocks.invokeExact();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static boolean Shaders_useMidBlockAttrib() {
            try {
                return useMidBlockAttrib.getBoolean(null);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static int ChunkRender_regionDX(ChunkRenderDispatcher.RenderChunk chunkRender) {
            try {
                return regionDX.getInt(chunkRender);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static int ChunkRender_regionDY(ChunkRenderDispatcher.RenderChunk chunkRender) {
            try {
                return regionDY.getInt(chunkRender);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static int ChunkRender_regionDZ(ChunkRenderDispatcher.RenderChunk chunkRender) {
            try {
                return regionDZ.getInt(chunkRender);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static Set<RenderType> CompiledChunk_hasBlocks(ChunkRenderDispatcher.CompiledChunk compiledChunk) {
            try {
                return (Set)hasBlocks.get(compiledChunk);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        @Nullable
        public static BakedQuad BakedQuad_getQuadEmissive(BakedQuad quad) {
            try {
                return getQuadEmissive.invokeExact(quad);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void SVertexBuilder_pushEntity(BlockState state, VertexConsumer buffer) {
            try {
                pushEntity.invokeExact(state, buffer);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void SVertexBuilder_popEntity(VertexConsumer buffer) {
            try {
                popEntity.invokeExact(buffer);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void RenderEnv_reset(Object renderEnv, BlockState state, BlockPos pos) {
            try {
                reset.invoke(renderEnv, state, pos);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static BakedModel BlockModelCustomizer_getRenderModel(BakedModel originalModel, BlockState state, Object renderEnv) {
            try {
                return getRenderModel.invoke(originalModel, state, renderEnv);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static List<BakedQuad> BlockModelCustomizer_getRenderQuads(List<BakedQuad> quads, BlockAndTintGetter world, BlockState state, BlockPos worldPos, Direction direction, RenderType layer, long rand, Object renderEnv) {
            try {
                return getRenderQuads.invoke(quads, world, state, worldPos, direction, layer, rand, renderEnv);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void BufferBuilder_setMidBlock(BufferBuilder buffer, float x, float y, float z) {
            try {
                setMidBlock.invokeExact(buffer, x, y, z);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void ChunkCacheOF_setRenderEnv(BlockAndTintGetter chunkCacheOF, Object renderEnv) {
            try {
                setRenderEnv.invoke(chunkCacheOF, renderEnv);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void RenderEnv_setRegionRenderCacheBuilder(Object renderEnv, ChunkBufferBuilderPack builder) {
            try {
                setRegionRenderCacheBuilder.invoke(renderEnv, builder);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static Object BufferBuilder_getRenderEnv(BufferBuilder buffer, BlockState state, BlockPos pos) {
            try {
                return getRenderEnv.invoke(buffer, state, pos);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void BufferBuilder_setBlockLayer(BufferBuilder buffer, RenderType renderType) {
            try {
                setBlockLayer.invokeExact(buffer, renderType);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static boolean RenderEnv_isOverlaysRendered(Object renderEnv) {
            try {
                return isOverlaysRendered.invoke(renderEnv);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void ChunkRender_postRenderOverlays(ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack builder, ChunkRenderDispatcher.CompiledChunk compiledChunk) {
            try {
                postRenderOverlays.invokeExact(chunkRender, builder, compiledChunk);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void RenderEnv_setOverlaysRendered(Object renderEnv, boolean rendered) {
            try {
                setOverlaysRendered.invoke(renderEnv, rendered);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static Object RenderEnv_getListQuadsOverlay(Object renderEnv, RenderType layer) {
            try {
                return getListQuadsOverlay.invoke(renderEnv, layer);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static int ListQuadsOverlay_size(Object overlay) {
            try {
                return size.invoke(overlay);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static List<BakedQuad> ListQuadsOverlay_getListQuadsSingle(Object overlay, BakedQuad quad) {
            try {
                return getListQuadsSingle.invoke(overlay, quad);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static BakedQuad ListQuadsOverlay_getQuad(Object overlay, int index) {
            try {
                return getQuad.invoke(overlay, index);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static BlockState ListQuadsOverlay_getBlockState(Object overlay, int index) {
            try {
                return getBlockState.invoke(overlay, index);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void ListQuadsOverlay_clear(Object overlay) {
            try {
                clear.invoke(overlay);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static void ChunkLayerSet_add(Object chunkLayerSet, RenderType renderType) {
            try {
                chunkLayerSet_add.invoke(chunkLayerSet, renderType);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

