/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.network.C2SRequestUpdateSmoothable;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="nocubes", value={Dist.CLIENT})
public final class KeybindingHandler {
    private static final List<Pair<KeyMapping, Runnable>> KEYBINDS = new LinkedList<Pair<KeyMapping, Runnable>>();

    public static void registerKeybindings() {
        KEYBINDS.clear();
        KEYBINDS.add(KeybindingHandler.makeKeybinding("toggleVisuals", 79, KeybindingHandler::toggleVisuals));
        KEYBINDS.add(KeybindingHandler.makeKeybinding("toggleSmoothable", 78, KeybindingHandler::toggleLookedAtSmoothable));
    }

    private static Pair<KeyMapping, Runnable> makeKeybinding(String name, int key, Runnable action) {
        KeyMapping mapping = new KeyMapping("nocubes.key." + name, key, "nocubes.keycategory");
        ClientRegistry.registerKeyBinding((KeyMapping)mapping);
        return Pair.of((Object)mapping, (Object)action);
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Pair<KeyMapping, Runnable> keybind : KEYBINDS) {
            if (!((KeyMapping)keybind.getKey()).m_90859_()) continue;
            ((Runnable)keybind.getValue()).run();
        }
    }

    private static void toggleVisuals() {
        if (NoCubesConfig.Client.render && NoCubesConfig.Server.forceVisuals) {
            Minecraft.m_91087_().f_91074_.m_6352_((Component)new TranslatableComponent("nocubes.notification.visualsForcedByServer").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return;
        }
        NoCubesConfig.Client.updateRender(!NoCubesConfig.Client.render);
        ClientUtil.reloadAllChunks();
    }

    private static void toggleLookedAtSmoothable() {
        boolean newValue;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel world = minecraft.f_91073_;
        LocalPlayer player = minecraft.f_91074_;
        HitResult lookingAt = minecraft.f_91077_;
        if (world == null || player == null || lookingAt == null || lookingAt.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult lookingAtBlock = (BlockHitResult)lookingAt;
        BlockState state = world.m_8055_(lookingAtBlock.m_82425_());
        boolean bl = newValue = !NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state);
        if (!NoCubesNetwork.currentServerHasNoCubes) {
            NoCubes.smoothableHandler.setSmoothable(newValue, (BlockBehaviour.BlockStateBase)state);
            ClientUtil.reloadAllChunks();
        } else {
            if (!player.m_20310_(2)) {
                return;
            }
            NoCubesNetwork.CHANNEL.sendToServer((Object)new C2SRequestUpdateSmoothable(state, newValue));
        }
    }
}

