/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import io.github.cadiboo.nocubes.config.ColorParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;

public final class ClientUtil {
    public static void reloadAllChunks() {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.execute(() -> {
            LevelRenderer worldRenderer = minecraft.f_91060_;
            if (worldRenderer != null) {
                worldRenderer.m_109818_();
            }
        });
    }

    public static void lineVertex(VertexConsumer buffer, PoseStack stack, float x, float y, float z, ColorParser.Color color) {
        Matrix4f matrix = stack.m_85850_().m_85861_();
        float transformedX = ClientUtil.getTransformX(matrix, x, y, z, 1.0f);
        float transformedY = ClientUtil.getTransformY(matrix, x, y, z, 1.0f);
        float transformedZ = ClientUtil.getTransformZ(matrix, x, y, z, 1.0f);
        buffer.m_5483_((double)transformedX, (double)transformedY, (double)transformedZ).m_6122_(color.red, color.green, color.blue, color.alpha).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void vertex(VertexConsumer buffer, PoseStack matrix, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        PoseStack.Pose currentTransform = matrix.m_85850_();
        Matrix4f pose = currentTransform.m_85861_();
        Matrix3f normal = currentTransform.m_85864_();
        float transformedX = ClientUtil.getTransformX(pose, x, y, z, 1.0f);
        float transformedY = ClientUtil.getTransformY(pose, x, y, z, 1.0f);
        float transformedZ = ClientUtil.getTransformZ(pose, x, y, z, 1.0f);
        float transformedNormalX = ClientUtil.getTransformX(normal, normalX, normalY, normalZ);
        float transformedNormalY = ClientUtil.getTransformY(normal, normalX, normalY, normalZ);
        float transformedNormalZ = ClientUtil.getTransformZ(normal, normalX, normalY, normalZ);
        buffer.m_5954_(transformedX, transformedY, transformedZ, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, transformedNormalX, transformedNormalY, transformedNormalZ);
    }

    public static float getTransformX(Matrix3f matrix, float x, float y, float z) {
        return matrix.f_8134_ * x + matrix.f_8135_ * y + matrix.f_8136_ * z;
    }

    public static float getTransformY(Matrix3f matrix, float x, float y, float z) {
        return matrix.f_8137_ * x + matrix.f_8138_ * y + matrix.f_8139_ * z;
    }

    public static float getTransformZ(Matrix3f matrix, float x, float y, float z) {
        return matrix.f_8140_ * x + matrix.f_8141_ * y + matrix.f_8142_ * z;
    }

    public static float getTransformX(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27603_ * x + matrix.f_27604_ * y + matrix.f_27605_ * z + matrix.f_27606_ * w;
    }

    public static float getTransformY(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27607_ * x + matrix.f_27608_ * y + matrix.f_27609_ * z + matrix.f_27610_ * w;
    }

    public static float getTransformZ(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27611_ * x + matrix.f_27612_ * y + matrix.f_27613_ * z + matrix.f_27614_ * w;
    }

    public static float getTransformW(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.f_27615_ * x + matrix.f_27616_ * y + matrix.f_27617_ * z + matrix.f_27618_ * w;
    }
}

