/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.hooks.SelfCheck;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class ClientEventSubscriber {
    private static long selfCheckInfoPrintedAt = Long.MIN_VALUE;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (NoCubesConfig.Client.debugEnabled && Screen.m_96639_()) {
            ClientEventSubscriber.printDebugInfo();
        }
        if (NoCubesConfig.Server.collisionsEnabled && !NoCubesNetwork.currentServerHasNoCubes) {
            NoCubesConfig.Server.collisionsEnabled = false;
            String msg_key = "nocubes.notification.nocubesNotInstalledOnServerCollisionsUnavailable";
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                LogManager.getLogger((String)"NoCubes notification fallback").warn(I18n.m_118938_((String)msg_key, (Object[])new Object[0]));
            } else {
                player.m_6352_((Component)new TranslatableComponent(msg_key).m_130940_(ChatFormatting.RED), Util.f_137441_);
            }
        }
    }

    private static void printDebugInfo() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        long time = world.m_46467_();
        if (time - 200L > selfCheckInfoPrintedAt) {
            selfCheckInfoPrintedAt = time;
            LogManager.getLogger((String)"NoCubes Hooks SelfCheck").debug(String.join((CharSequence)"\n", SelfCheck.info()));
        }
    }
}

