/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager;

import com.legacy.conjurer_illager.IllagerConfig;
import com.legacy.conjurer_illager.IllagerEvents;
import com.legacy.conjurer_illager.IllagerRegistry;
import com.legacy.conjurer_illager.MLSupporter;
import com.legacy.conjurer_illager.client.IllagerClient;
import com.legacy.conjurer_illager.client.render.IllagerEntityRendering;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import com.legacy.structure_gel.api.events.AddStructureToBiomeEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="conjurer_illager")
public class TheConjurerMod {
    public static final String NAME = "The Conjurer";
    public static final String MODID = "conjurer_illager";
    public static final MLSupporter SUPPORTERS = new MLSupporter("conjurer_illager");

    public TheConjurerMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)IllagerConfig.COMMON_SPEC);
        IEventBus mod = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forge = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            IllagerEntityRendering.init();
            mod.addListener(IllagerClient::initialization);
        });
        mod.addListener(TheConjurerMod::commonInit);
        mod.addListener(IllagerEntityTypes::onAttributesRegistered);
        mod.register(IllagerRegistry.class);
        forge.register(IllagerEvents.class);
        forge.addListener(TheConjurerMod::addStructures);
    }

    private static void commonInit(FMLCommonSetupEvent event) {
        SUPPORTERS.refresh();
    }

    public static void addStructures(AddStructureToBiomeEvent event) {
        event.register(IllagerStructures.THEATER);
    }

    public static ResourceLocation locate(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static String find(String name) {
        return new String("conjurer_illager:" + name);
    }
}

