/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager;

import com.legacy.conjurer_illager.TheConjurerMod;
import com.legacy.conjurer_illager.item.ConjurerHatItem;
import com.legacy.conjurer_illager.item.IllagerArmorMaterial;
import com.legacy.conjurer_illager.item.IllagerRecordItem;
import com.legacy.conjurer_illager.item.ThrowableBallItem;
import com.legacy.conjurer_illager.item.ThrowableCardItem;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerParticles;
import com.legacy.conjurer_illager.registry.IllagerSounds;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IllagerRegistry {
    public static final Item CONJURER_HAT = new ConjurerHatItem(IllagerArmorMaterial.CONJURER_HAT, EquipmentSlot.HEAD, new Item.Properties().m_41491_(CreativeModeTab.f_40757_));
    public static final Item CONJURER_SPAWN_EGG = new ForgeSpawnEggItem(() -> IllagerEntityTypes.CONJURER, 7415387, 15179338, new Item.Properties().m_41491_(CreativeModeTab.f_40753_));
    public static final Item THROWABLE_BALL = new ThrowableBallItem(new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(8));
    public static final Item THROWING_CARD = new ThrowableCardItem(new Item.Properties().m_41491_(CreativeModeTab.f_40757_).m_41487_(52));
    public static final Item DELVE_DEEPER_RECORD = new IllagerRecordItem(13, "Jesterguy", "Delve Deeper", () -> IllagerSounds.RECORD_DELVE_DEEPER, new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.RARE).m_41487_(1));
    public static final Motive THEATER_PAINTING = new Motive(32, 32);

    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
        IllagerParticles.init(event);
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        IllagerParticles.registerFactories(event);
    }

    @SubscribeEvent
    public static void onRegisterPaintings(RegistryEvent.Register<Motive> event) {
        IllagerRegistry.register(event.getRegistry(), "theater", THEATER_PAINTING);
    }

    @SubscribeEvent
    public static void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        IllagerSounds.init();
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IllagerRegistry.register(event.getRegistry(), "conjurer_hat", CONJURER_HAT);
        IllagerRegistry.register(event.getRegistry(), "conjurer_spawn_egg", CONJURER_SPAWN_EGG);
        IllagerRegistry.register(event.getRegistry(), "throwable_ball", THROWABLE_BALL);
        IllagerRegistry.register(event.getRegistry(), "throwing_card", THROWING_CARD);
        IllagerRegistry.register(event.getRegistry(), "music_disc_delve_deeper", DELVE_DEEPER_RECORD);
    }

    @SubscribeEvent
    public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        IllagerEntityTypes.init(event);
    }

    @SubscribeEvent
    public static void onRegisterStructures(RegistryEvent.Register<StructureFeature<?>> event) {
        IllagerStructures.init(event);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T object) {
        object.setRegistryName(TheConjurerMod.locate(name));
        registry.register(object);
    }
}

