/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager;

import com.legacy.conjurer_illager.IllagerRegistry;
import com.legacy.conjurer_illager.entity.ConjurerEntity;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class IllagerEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Villager || event.getEntity() instanceof WanderingTrader) {
            AbstractVillager villager = (AbstractVillager)event.getEntity();
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, ConjurerEntity.class, 8.0f, 0.6, 0.6));
        }
    }

    @SubscribeEvent
    public static void onPotionEffectGiven(PotionEvent.PotionApplicableEvent event) {
        if (event.getPotionEffect().m_19544_() == MobEffects.f_19594_ && event.getEntityLiving().m_6844_(EquipmentSlot.HEAD).m_41720_() == IllagerRegistry.CONJURER_HAT) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getAmount() > 0.0f && event.getSource().m_7640_() instanceof Rabbit) {
            event.getSource().m_7640_().m_5496_(SoundEvents.f_12298_, 1.0f, (event.getEntityLiving().f_19853_.f_46441_.nextFloat() - event.getEntityLiving().f_19853_.f_46441_.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (event.getSource().m_19387_() && event.getEntityLiving().m_6844_(EquipmentSlot.HEAD).m_41720_() == IllagerRegistry.CONJURER_HAT) {
            event.setAmount(event.getAmount() * 0.7f);
        }
    }

    @SubscribeEvent
    public static void onVillagerTradesAssigned(VillagerTradesEvent event) {
        try {
            if (event.getType() == VillagerProfession.f_35588_) {
                ((List)event.getTrades().get(2)).add(new EmeraldForMapTrade(11, IllagerStructures.THEATER.getStructure(), MapDecoration.Type.RED_X, 15, 5));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ItemListing {
        private final int count;
        private final StructureFeature<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(int emeraldCountIn, StructureFeature<?> structureNameIn, MapDecoration.Type mapTypeIn, int maxUsesIn, int experienceValueIn) {
            this.count = emeraldCountIn;
            this.structureName = structureNameIn;
            this.mapDecorationType = mapTypeIn;
            this.maxUses = maxUsesIn;
            this.xpValue = experienceValueIn;
        }

        @Nullable
        public MerchantOffer m_5670_(Entity trader, Random rand) {
            if (!(trader.f_19853_ instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverworld = (ServerLevel)trader.f_19853_;
            BlockPos blockpos = serverworld.m_8717_(this.structureName, trader.m_142538_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverworld, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverworld, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.m_41714_((Component)new TranslatableComponent("filled_map." + this.structureName.m_67098_().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.count), new ItemStack((ItemLike)Items.f_42522_), itemstack, this.maxUses, this.xpValue, 0.2f);
            }
            return null;
        }
    }
}

