/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import com.google.common.collect.ImmutableList;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.util.Lazy;

public class ModUtil {
    public static final BlockPos VEC_ZERO = new BlockPos(0, 0, 0);
    public static final BlockPos VEC_ONE = new BlockPos(1, 1, 1);
    public static final BlockPos VEC_TWO = new BlockPos(2, 2, 2);
    public static final BlockPos CHUNK_SIZE = new BlockPos(16, 16, 16);
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Lazy<Boolean> IS_DEVELOPER_WORKSPACE = Lazy.concurrentOf(() -> {
        String target = System.getenv().get("target");
        if (target == null) {
            return false;
        }
        return target.contains("userdev");
    });
    public static final float FULLY_SMOOTHABLE = 1.0f;
    public static final float NOT_SMOOTHABLE = -1.0f;

    public static ImmutableList<BlockState> getStates(Block block) {
        return block.func_176194_O().func_177619_a();
    }

    public static void traverseArea(Vector3i startInclusive, Vector3i endInclusive, BlockPos.Mutable currentPosition, IWorldReader world, Traverser func) {
        ModUtil.traverseArea(startInclusive.func_177958_n(), startInclusive.func_177956_o(), startInclusive.func_177952_p(), endInclusive.func_177958_n(), endInclusive.func_177956_o(), endInclusive.func_177952_p(), currentPosition, world, func);
    }

    public static void traverseArea(int startXInclusive, int startYInclusive, int startZInclusive, int endXInclusive, int endYInclusive, int endZInclusive, BlockPos.Mutable currentPosition, IWorldReader world, Traverser func) {
        BlockState air = Blocks.field_150350_a.func_176223_P();
        int endXPlus1 = endXInclusive + 1;
        int endYPlus1 = endYInclusive + 1;
        int endZPlus1 = endZInclusive + 1;
        int maxX = endXInclusive + 16 & 0xFFFFFFF0;
        int maxY = endYInclusive + 16 & 0xFFFFFFF0;
        int maxZ = endZInclusive + 16 & 0xFFFFFFF0;
        int width = endXPlus1 - startXInclusive;
        int height = endYPlus1 - startYInclusive;
        int widthMulHeight = width * height;
        for (int blockChunkX = startXInclusive; blockChunkX < maxX; blockChunkX += 16) {
            int maskedBlockChunkX = blockChunkX & 0xFFFFFFF0;
            int maskedNextBlockChunkX = blockChunkX + 16 & 0xFFFFFFF0;
            for (int blockChunkZ = startZInclusive; blockChunkZ < maxZ; blockChunkZ += 16) {
                int maskedBlockChunkZ = blockChunkZ & 0xFFFFFFF0;
                int maskedNextBlockChunkZ = blockChunkZ + 16 & 0xFFFFFFF0;
                int chunkX = blockChunkX >> 4;
                int chunkZ = blockChunkZ >> 4;
                IChunk chunk = world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_223226_a_, false);
                ChunkSection[] chunkSections = chunk == null ? null : chunk.func_76587_i();
                for (int blockChunkY = startYInclusive; blockChunkY < maxY; blockChunkY += 16) {
                    int maskedBlockChunkY = blockChunkY & 0xFFFFFFF0;
                    int maskedNextBlockChunkY = blockChunkY + 16 & 0xFFFFFFF0;
                    int chunkSectionIndex = blockChunkY >> 4;
                    ChunkSection chunkSection = chunkSections == null || chunkSectionIndex < 0 || chunkSectionIndex >= chunkSections.length ? null : chunkSections[chunkSectionIndex];
                    int sectionMinX = Math.max(maskedBlockChunkX, startXInclusive);
                    int sectionMinY = Math.max(maskedBlockChunkY, startYInclusive);
                    int sectionMinZ = Math.max(maskedBlockChunkZ, startZInclusive);
                    int sectionMaxX = Math.min(maskedNextBlockChunkX, endXPlus1);
                    int sectionMaxY = Math.min(maskedNextBlockChunkY, endYPlus1);
                    int sectionMaxZ = Math.min(maskedNextBlockChunkZ, endZPlus1);
                    for (int y = sectionMinY; y < sectionMaxY; ++y) {
                        int maskedY = y & 0xF;
                        for (int z = sectionMinZ; z < sectionMaxZ; ++z) {
                            int maskedZ = z & 0xF;
                            for (int x = sectionMinX; x < sectionMaxX; ++x) {
                                BlockState blockState = chunkSection == null ? air : chunkSection.func_177485_a(x & 0xF, maskedY, maskedZ);
                                currentPosition.func_181079_c(x, y, z);
                                int zyxIndex = (z - startZInclusive) * widthMulHeight + (y - startYInclusive) * width + (x - startXInclusive);
                                func.accept(blockState, currentPosition, zyxIndex);
                            }
                        }
                    }
                }
            }
        }
    }

    public static float getBlockDensity(Predicate<BlockState> isSmoothable, BlockState state) {
        return ModUtil.getBlockDensity(isSmoothable.test(state), state);
    }

    public static float getBlockDensity(boolean shouldSmooth, BlockState state) {
        if (!shouldSmooth) {
            return -1.0f;
        }
        if (ModUtil.isSnowLayer(state)) {
            return ModUtil.mapSnowHeight((Integer)state.func_177229_b((Property)SnowBlock.field_176315_a));
        }
        return 1.0f;
    }

    private static float mapSnowHeight(int value) {
        return -1.0f + (float)(value - 1) * 0.25f;
    }

    public static boolean isSnowLayer(BlockState state) {
        return state.func_235901_b_((Property)SnowBlock.field_176315_a);
    }

    public static boolean isShortPlant(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof BushBlock && !(block instanceof DoublePlantBlock) && !(block instanceof CropsBlock) && !(block instanceof StemBlock);
    }

    public static boolean isPlant(BlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151585_k || material == Material.field_203243_f || material == Material.field_151582_l || material == Material.field_242934_h || material == Material.field_204868_h || material == Material.field_215712_y || material == Material.field_215713_z || material == Material.field_151572_C;
    }

    public static int get3dIndexInto1dArray(int x, int y, int z, int xSize, int ySize) {
        return xSize * ySize * z + xSize * y + x;
    }

    public static FluidState getExtendedFluidState(World world, BlockPos pos) {
        int extendRange = NoCubesConfig.Server.extendFluidsRange;
        assert (extendRange > 0);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int chunkX = x >> 4;
        int z = pos.func_177952_p();
        int chunkZ = z >> 4;
        Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
        FluidState fluid = chunk.func_205751_b(x, y, z);
        if (!fluid.func_206888_e() || !NoCubes.smoothableHandler.isSmoothable(chunk.func_180495_p(pos))) {
            return fluid;
        }
        fluid = chunk.func_205751_b(x, y + 1, z);
        if (fluid.func_206889_d()) {
            return fluid;
        }
        for (int extendZ = z - extendRange; extendZ <= z + extendRange; ++extendZ) {
            for (int extendX = x - extendRange; extendX <= x + extendRange; ++extendX) {
                if (extendZ == z && extendX == x) continue;
                if (chunkX != extendZ >> 4 || chunkZ != extendX >> 4) {
                    chunkZ = extendZ >> 4;
                    chunkX = extendX >> 4;
                    chunk = world.func_212866_a_(chunkX, chunkZ);
                }
                if (!(fluid = chunk.func_205751_b(extendX, y, extendZ)).func_206889_d()) continue;
                return fluid;
            }
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    public static interface Traverser {
        public void accept(BlockState var1, BlockPos.Mutable var2, int var3);
    }
}

