/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.util.Vec;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public final class Face {
    public Vec v0;
    public Vec v1;
    public Vec v2;
    public Vec v3;

    public Face() {
        this(new Vec(), new Vec(), new Vec(), new Vec());
    }

    public Face(Vec v0, Vec v1, Vec v2, Vec v3) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public Face assignNormalTo(Face toUse) {
        Vec v0 = this.v0;
        Vec v1 = this.v1;
        Vec v2 = this.v2;
        Vec v3 = this.v3;
        Vec.normal(v3, v0, v1, toUse.v0);
        Vec.normal(v0, v1, v2, toUse.v1);
        Vec.normal(v1, v2, v3, toUse.v2);
        Vec.normal(v2, v3, v0, toUse.v3);
        return toUse;
    }

    public Vec assignAverageTo(Vec toUse) {
        Vec v0 = this.v0;
        Vec v1 = this.v1;
        Vec v2 = this.v2;
        Vec v3 = this.v3;
        toUse.x = (v0.x + v1.x + v2.x + v3.x) / 4.0f;
        toUse.y = (v0.y + v1.y + v2.y + v3.y) / 4.0f;
        toUse.z = (v0.z + v1.z + v2.z + v3.z) / 4.0f;
        return toUse;
    }

    public void setValuesFrom(Face other) {
        this.v0.set(other.v0);
        this.v1.set(other.v1);
        this.v2.set(other.v2);
        this.v3.set(other.v3);
    }

    public Face set(float v0x, float v0y, float v0z, float v1x, float v1y, float v1z, float v2x, float v2y, float v2z, float v3x, float v3y, float v3z) {
        this.v0.set(v0x, v0y, v0z);
        this.v1.set(v1x, v1y, v1z);
        this.v2.set(v2x, v2y, v2z);
        this.v3.set(v3x, v3y, v3z);
        return this;
    }

    public Face set(Vec v0, Vec v1, Vec v2, Vec v3) {
        this.v0.set(v0);
        this.v1.set(v1);
        this.v2.set(v2);
        this.v3.set(v3);
        return this;
    }

    public Face add(float x, float y, float z) {
        this.v0.add(x, y, z);
        this.v1.add(x, y, z);
        this.v2.add(x, y, z);
        this.v3.add(x, y, z);
        return this;
    }

    public Face subtract(float x, float y, float z) {
        this.v0.subtract(x, y, z);
        this.v1.subtract(x, y, z);
        this.v2.subtract(x, y, z);
        this.v3.subtract(x, y, z);
        return this;
    }

    public Face multiply(float d) {
        this.v0.multiply(d);
        this.v1.multiply(d);
        this.v2.multiply(d);
        this.v3.multiply(d);
        return this;
    }

    public Face transform(Matrix3f matrix) {
        this.v0.transform(matrix);
        this.v1.transform(matrix);
        this.v2.transform(matrix);
        this.v3.transform(matrix);
        return this;
    }

    public Face transform(Matrix4f matrix) {
        this.v0.transform(matrix);
        this.v1.transform(matrix);
        this.v2.transform(matrix);
        this.v3.transform(matrix);
        return this;
    }
}

