/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.state.Property;
import net.minecraft.util.Util;

public interface BlockStateConverter {
    public static final BlockStateArgument PARSER = new BlockStateArgument();

    public static BlockState fromId(int id) {
        BlockState state = (BlockState)Block.field_176229_d.func_148745_a(id);
        if (state == null) {
            throw new IllegalStateException("Unknown blockstate id" + id);
        }
        return state;
    }

    public static int toId(BlockState state) {
        int id = Block.field_176229_d.func_148757_b((Object)state);
        if (id == -1) {
            throw new IllegalStateException("Unknown blockstate " + state);
        }
        return id;
    }

    public static BlockState fromStringOrNull(String string) {
        try {
            return PARSER.parse(new StringReader(string)).func_197231_a();
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static String toString(BlockState state) {
        String block = state.func_177230_c().getRegistryName().toString();
        ImmutableMap values = state.func_206871_b();
        if (values.isEmpty()) {
            return block;
        }
        return values.entrySet().stream().map(e -> ((Property)e.getKey()).func_177701_a() + "=" + Util.func_200269_a((Property)((Property)e.getKey()), e.getValue())).collect(Collectors.joining(",", block + "[", "]"));
    }
}

