/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.ThreadLocalArrayCache;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class Area
implements AutoCloseable {
    private static final ThreadLocalArrayCache<BlockState[]> BLOCKS_CACHE = new ThreadLocalArrayCache<BlockState[]>(BlockState[]::new, array -> ((BlockState[])array).length);
    private static final ThreadLocalArrayCache<FluidState[]> FLUIDS_CACHE = new ThreadLocalArrayCache<FluidState[]>(FluidState[]::new, array -> ((FluidState[])array).length);
    public final BlockPos start;
    public final BlockPos size;
    private final IBlockReader world;
    private BlockState[] blocks;
    private FluidState[] fluids;

    public Area(IBlockReader world, BlockPos startInclusive, BlockPos size) {
        this.world = world;
        this.start = startInclusive.func_185334_h();
        this.size = size.func_185334_h();
    }

    public Area(IBlockReader world, BlockPos startInclusive, BlockPos size, MeshGenerator generator) {
        this.world = world;
        Vector3i negativeExtension = generator.getNegativeAreaExtension();
        Vector3i positiveExtension = generator.getPositiveAreaExtension();
        this.start = startInclusive.func_177973_b(negativeExtension).func_185334_h();
        this.size = new BlockPos(size.func_177958_n() + negativeExtension.func_177958_n() + positiveExtension.func_177958_n(), size.func_177956_o() + negativeExtension.func_177956_o() + positiveExtension.func_177956_o(), size.func_177952_p() + negativeExtension.func_177952_p() + positiveExtension.func_177952_p());
    }

    public BlockState[] getAndCacheBlocks() {
        if (this.blocks == null) {
            this.blocks = BLOCKS_CACHE.takeArray(this.numBlocks());
            BlockState[] array = this.blocks;
            BlockPos start = this.start;
            int startX = start.func_177958_n();
            int startY = start.func_177956_o();
            int startZ = start.func_177952_p();
            BlockPos size = this.size;
            int endX = startX + size.func_177958_n();
            int endY = startY + size.func_177956_o();
            int endZ = startZ + size.func_177952_p();
            IBlockReader world = this.world;
            if (world instanceof IWorldReader) {
                BlockPos endInclusive = new BlockPos(endX - 1, endY - 1, endZ - 1);
                ModUtil.traverseArea((Vector3i)start, (Vector3i)endInclusive, new BlockPos.Mutable(), (IWorldReader)world, (state, pos, zyxIndex) -> {
                    array[zyxIndex] = state;
                });
            } else {
                BlockPos.Mutable pos2 = new BlockPos.Mutable();
                int zyxIndex2 = 0;
                for (int z = startZ; z < endZ; ++z) {
                    for (int y = startY; y < endY; ++y) {
                        int x = startX;
                        while (x < endX) {
                            array[zyxIndex2] = world.func_180495_p((BlockPos)pos2.func_181079_c(x, y, z));
                            ++x;
                            ++zyxIndex2;
                        }
                    }
                }
            }
        }
        return this.blocks;
    }

    public FluidState[] getAndCacheFluids() {
        if (this.fluids == null) {
            int numBlocks = this.numBlocks();
            this.fluids = FLUIDS_CACHE.takeArray(numBlocks);
            FluidState[] array = this.fluids;
            BlockPos start = this.start;
            int startX = start.func_177958_n();
            int startY = start.func_177956_o();
            int startZ = start.func_177952_p();
            BlockPos size = this.size;
            int endX = startX + size.func_177958_n();
            int endY = startY + size.func_177956_o();
            int endZ = startZ + size.func_177952_p();
            IBlockReader world = this.world;
            BlockPos.Mutable pos = new BlockPos.Mutable();
            int zyxIndex = 0;
            for (int z = startZ; z < endZ; ++z) {
                for (int y = startY; y < endY; ++y) {
                    int x = startX;
                    while (x < endX) {
                        array[zyxIndex] = world.func_204610_c((BlockPos)pos.func_181079_c(x, y, z));
                        ++x;
                        ++zyxIndex;
                    }
                }
            }
        }
        return this.fluids;
    }

    public int numBlocks() {
        BlockPos size = this.size;
        return size.func_177958_n() * size.func_177956_o() * size.func_177952_p();
    }

    public int index(BlockPos relativePos) {
        int index = this.indexIfInsideCache(relativePos);
        if (index == -1) {
            throw new IndexOutOfBoundsException("relativePos was " + relativePos + " but should have been within " + ModUtil.VEC_ZERO + " and " + this.size);
        }
        return index;
    }

    public int indexIfInsideCache(BlockPos relativePos) {
        return this.indexIfInsideCache(relativePos.func_177958_n(), relativePos.func_177956_o(), relativePos.func_177952_p());
    }

    public int indexIfInsideCache(int relativeX, int relativeY, int relativeZ) {
        BlockPos size = this.size;
        int sizeX = size.func_177958_n();
        int sizeY = size.func_177956_o();
        if (relativeX < 0 || relativeX >= sizeX || relativeY < 0 || relativeY >= sizeY || relativeZ < 0 || relativeZ >= size.func_177952_p()) {
            return -1;
        }
        return ModUtil.get3dIndexInto1dArray(relativeX, relativeY, relativeZ, sizeX, sizeY);
    }

    @Override
    public void close() {
    }

    public BlockState getBlockState(BlockPos.Mutable relativePos) {
        int index = this.indexIfInsideCache((BlockPos)relativePos);
        if (index == -1) {
            int x = relativePos.func_177958_n();
            int y = relativePos.func_177956_o();
            int z = relativePos.func_177952_p();
            BlockState state = this.world.func_180495_p((BlockPos)relativePos.func_243531_h((Vector3i)this.start));
            relativePos.func_181079_c(x, y, z);
            return state;
        }
        return this.getAndCacheBlocks()[index];
    }
}

