/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.smoothable;

import com.google.common.collect.Sets;
import net.minecraft.block.BlockState;
import org.apache.logging.log4j.LogManager;

public interface SmoothableHandler {
    public static SmoothableHandler create(BlockState test) {
        try {
            ASM asm = new ASM();
            asm.isSmoothable(test);
            return asm;
        }
        catch (NoSuchFieldError e) {
            LogManager.getLogger().warn("Failed to create optimised ASM based handler, falling back to Set implementation, performance may suffer slightly", (Throwable)e);
            return new Set();
        }
    }

    public void addSmoothable(BlockState var1);

    public void removeSmoothable(BlockState var1);

    public boolean isSmoothable(BlockState var1);

    public void setSmoothable(boolean var1, BlockState var2);

    public static class Set
    implements SmoothableHandler {
        private final java.util.Set<BlockState> smoothables = Sets.newIdentityHashSet();

        @Override
        public void addSmoothable(BlockState state) {
            this.smoothables.add(state);
        }

        @Override
        public void removeSmoothable(BlockState state) {
            this.smoothables.remove(state);
        }

        @Override
        public boolean isSmoothable(BlockState state) {
            return this.smoothables.contains(state);
        }

        @Override
        public void setSmoothable(boolean newValue, BlockState state) {
            if (newValue) {
                this.addSmoothable(state);
            } else {
                this.removeSmoothable(state);
            }
        }
    }

    public static class ASM
    implements SmoothableHandler {
        @Override
        public void addSmoothable(BlockState state) {
            state.nocubes_isTerrainSmoothable = true;
        }

        @Override
        public void removeSmoothable(BlockState state) {
            state.nocubes_isTerrainSmoothable = false;
        }

        @Override
        public boolean isSmoothable(BlockState state) {
            return state.nocubes_isTerrainSmoothable;
        }

        @Override
        public void setSmoothable(boolean newValue, BlockState state) {
            state.nocubes_isTerrainSmoothable = newValue;
        }
    }
}

