/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2CUpdateSmoothable {
    private final BlockState state;
    private final boolean newValue;

    public S2CUpdateSmoothable(BlockState state, boolean newValue) {
        this.state = state;
        this.newValue = newValue;
    }

    public static void encode(S2CUpdateSmoothable msg, PacketBuffer buffer) {
        buffer.func_150787_b(BlockStateConverter.toId(msg.state));
        buffer.writeBoolean(msg.newValue);
    }

    public static S2CUpdateSmoothable decode(PacketBuffer buffer) {
        BlockState state = BlockStateConverter.fromId(buffer.func_150792_a());
        boolean newValue = buffer.readBoolean();
        return new S2CUpdateSmoothable(state, newValue);
    }

    public static void handle(S2CUpdateSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            NoCubes.smoothableHandler.setSmoothable(msg.newValue, msg.state);
            ClientUtil.reloadAllChunks();
        });
        ctx.setPacketHandled(true);
    }
}

