/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.network.S2CUpdateSmoothable;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class C2SRequestUpdateSmoothable {
    private final BlockState state;
    private final boolean newValue;

    public C2SRequestUpdateSmoothable(BlockState state, boolean newValue) {
        this.state = state;
        this.newValue = newValue;
    }

    public static void encode(C2SRequestUpdateSmoothable msg, PacketBuffer buffer) {
        buffer.func_150787_b(BlockStateConverter.toId(msg.state));
        buffer.writeBoolean(msg.newValue);
    }

    public static C2SRequestUpdateSmoothable decode(PacketBuffer buffer) {
        BlockState state = BlockStateConverter.fromId(buffer.func_150792_a());
        boolean newValue = buffer.readBoolean();
        return new C2SRequestUpdateSmoothable(state, newValue);
    }

    public static void handle(C2SRequestUpdateSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity sender = ctx.getSender();
        boolean hasPermission = sender.func_211513_k(2);
        if (hasPermission) {
            BlockState state = msg.state;
            boolean newValue = msg.newValue;
            if (NoCubes.smoothableHandler.isSmoothable(state) != newValue) {
                ctx.enqueueWork(() -> NoCubesConfig.Server.updateSmoothable(newValue, state));
                NoCubesNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CUpdateSmoothable(state, newValue));
            } else {
                NoCubesNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new S2CUpdateSmoothable(state, newValue));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.command.addSmoothableNoPermission"), Util.field_240973_b_);
        }
        ctx.setPacketHandled(true);
    }
}

