/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.ThreadLocalArrayCache;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class SurfaceNets
implements MeshGenerator {
    private static final ThreadLocalArrayCache<float[]> DENSITY_CACHE = new ThreadLocalArrayCache<float[]>(float[]::new, array -> ((float[])array).length);

    @Override
    public Vector3i getPositiveAreaExtension() {
        return ModUtil.VEC_ONE;
    }

    @Override
    public Vector3i getNegativeAreaExtension() {
        return ModUtil.VEC_ONE;
    }

    @Override
    public void generateOrThrow(Area area, Predicate<BlockState> isSmoothable, MeshGenerator.VoxelAction voxelAction, MeshGenerator.FaceAction faceAction) {
        SurfaceNets.generateOrThrow(SurfaceNets.generateDistanceField(area, isSmoothable), area.size, voxelAction, faceAction);
    }

    public static float[] generateDistanceField(Area area, Predicate<BlockState> isSmoothable) {
        BlockState[] states = area.getAndCacheBlocks();
        int length = area.numBlocks();
        float[] densityField = DENSITY_CACHE.takeArray(length);
        for (int i = 0; i < length; ++i) {
            BlockState state = states[i];
            boolean isStateSmoothable = isSmoothable.test(state);
            densityField[i] = ModUtil.getBlockDensity(isStateSmoothable, state);
        }
        return densityField;
    }

    private static void generateOrThrow(float[] densityField, BlockPos dims, MeshGenerator.VoxelAction voxelAction, MeshGenerator.FaceAction faceAction) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        Face face = new Face();
        int n = 0;
        int[] axisMultipliers = new int[]{1, dims.func_177958_n() + 1, (dims.func_177958_n() + 1) * (dims.func_177956_o() + 1)};
        float[] grid = new float[8];
        int buf_no = 1;
        Vec[] verticesBuffer = new Vec[axisMultipliers[2] * 2];
        float[] vertexUntilIFigureOutTheInterpolationAndIntersection = new float[]{0.0f, 0.0f, 0.0f};
        int z = 0;
        while (z < dims.func_177952_p() - 1) {
            int bufferPointer = 1 + (dims.func_177958_n() + 1) * (1 + buf_no * (dims.func_177956_o() + 1));
            int y = 0;
            while (y < dims.func_177956_o() - 1) {
                int x = 0;
                while (x < dims.func_177958_n() - 1) {
                    int mask = 0;
                    int corner = 0;
                    int idx = n;
                    int neighbourZ = 0;
                    while (neighbourZ < 2) {
                        int neighbourY = 0;
                        while (neighbourY < 2) {
                            int neighbourX = 0;
                            while (neighbourX < 2) {
                                float signedDistance;
                                grid[corner] = signedDistance = densityField[idx];
                                boolean insideIsosurface = signedDistance < 0.0f;
                                mask |= insideIsosurface ? 1 << corner : 0;
                                neighbourX = (byte)(neighbourX + 1);
                                ++corner;
                                ++idx;
                            }
                            ++neighbourY;
                            idx += dims.func_177958_n() - 2;
                        }
                        ++neighbourZ;
                        idx += dims.func_177958_n() * (dims.func_177956_o() - 2);
                    }
                    if (mask == 0 && !voxelAction.apply(pos.func_181079_c(x, y, z), (grid[0] + 1.0f) / 2.0f)) {
                        return;
                    }
                    if (mask != 0 && mask != 255) {
                        int edge_mask = Lookup.EDGE_TABLE[mask];
                        vertexUntilIFigureOutTheInterpolationAndIntersection[2] = 0.0f;
                        vertexUntilIFigureOutTheInterpolationAndIntersection[1] = 0.0f;
                        vertexUntilIFigureOutTheInterpolationAndIntersection[0] = 0.0f;
                        int edgeCrossings = 0;
                        for (int edge = 0; edge < 12; ++edge) {
                            if ((edge_mask & 1 << edge) == 0) continue;
                            ++edgeCrossings;
                            int edgeStart = Lookup.CUBE_EDGES[edge << 1];
                            float edgeStartValue = grid[edgeStart];
                            int edgeEnd = Lookup.CUBE_EDGES[(edge << 1) + 1];
                            float edgeEndValue = grid[edgeEnd];
                            float t = edgeStartValue - edgeEndValue;
                            if (!(Math.abs(t) > 1.0E-8f)) continue;
                            t = edgeStartValue / t;
                            int j = 0;
                            int k = 1;
                            while (j < 3) {
                                int a = edgeStart & k;
                                int b = edgeEnd & k;
                                if (a != b) {
                                    int n2 = j;
                                    vertexUntilIFigureOutTheInterpolationAndIntersection[n2] = vertexUntilIFigureOutTheInterpolationAndIntersection[n2] + (a != 0 ? 1.0f - t : t);
                                } else {
                                    int n3 = j;
                                    vertexUntilIFigureOutTheInterpolationAndIntersection[n3] = vertexUntilIFigureOutTheInterpolationAndIntersection[n3] + (a != 0 ? 1.0f : 0.0f);
                                }
                                ++j;
                                k <<= 1;
                            }
                        }
                        float s = 1.0f / (float)edgeCrossings;
                        Vec vertex = new Vec(vertexUntilIFigureOutTheInterpolationAndIntersection[0], vertexUntilIFigureOutTheInterpolationAndIntersection[1], vertexUntilIFigureOutTheInterpolationAndIntersection[2]);
                        vertex.x = (float)x + s * vertex.x;
                        vertex.y = (float)y + s * vertex.y;
                        vertex.z = (float)z + s * vertex.z;
                        vertex.add(0.5f, 0.5f, 0.5f);
                        verticesBuffer[bufferPointer] = vertex;
                        for (int axis = 0; axis < 3; ++axis) {
                            if ((edge_mask & 1 << axis) == 0) continue;
                            int nextAxis = (axis + 1) % 3;
                            int nextNextAxis = (axis + 2) % 3;
                            if (nextAxis == 0 && x == 0 || nextAxis == 1 && y == 0 || nextAxis == 2 && z == 0 || nextNextAxis == 0 && x == 0 || nextNextAxis == 1 && y == 0 || nextNextAxis == 2 && z == 0) continue;
                            int du = axisMultipliers[nextAxis];
                            int dv = axisMultipliers[nextNextAxis];
                            if ((mask & 1) != 0) {
                                face.v0.set(verticesBuffer[bufferPointer]);
                                face.v1.set(verticesBuffer[bufferPointer - dv]);
                                face.v2.set(verticesBuffer[bufferPointer - du - dv]);
                                face.v3.set(verticesBuffer[bufferPointer - du]);
                            } else {
                                face.v0.set(verticesBuffer[bufferPointer]);
                                face.v1.set(verticesBuffer[bufferPointer - du]);
                                face.v2.set(verticesBuffer[bufferPointer - du - dv]);
                                face.v3.set(verticesBuffer[bufferPointer - dv]);
                            }
                            pos.func_181079_c(x, y, z);
                            if (faceAction.apply(pos, face)) continue;
                            return;
                        }
                    }
                    ++x;
                    ++n;
                    ++bufferPointer;
                }
                ++y;
                ++n;
                bufferPointer += 2;
            }
            ++z;
            n += dims.func_177958_n();
            buf_no ^= 1;
            axisMultipliers[2] = -axisMultipliers[2];
        }
    }

    static final class Lookup {
        public static final int[] CUBE_EDGES = new int[24];
        public static final int[] EDGE_TABLE = new int[256];

        Lookup() {
        }

        private static void generateCubeEdgesTable() {
            int cubeEdgesIndex = 0;
            for (int cubeCornerIndex = 0; cubeCornerIndex < 8; cubeCornerIndex = (int)((byte)(cubeCornerIndex + 1))) {
                for (int em = 1; em <= 4; em <<= 1) {
                    int j = cubeCornerIndex ^ em;
                    if (cubeCornerIndex > j) continue;
                    Lookup.CUBE_EDGES[cubeEdgesIndex++] = cubeCornerIndex;
                    Lookup.CUBE_EDGES[cubeEdgesIndex++] = j;
                }
            }
        }

        private static void generateIntersectionTable() {
            for (int edgeTableIndex = 0; edgeTableIndex < 256; edgeTableIndex = (int)((short)(edgeTableIndex + 1))) {
                int em = 0;
                for (int cubeEdgesIndex = 0; cubeEdgesIndex < 24; cubeEdgesIndex += 2) {
                    boolean a = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex]) != 0;
                    boolean b = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex + 1]) != 0;
                    em = (short)(em | (a != b ? 1 << (cubeEdgesIndex >> 1) : 0));
                }
                Lookup.EDGE_TABLE[edgeTableIndex] = em;
            }
        }

        static {
            Lookup.generateCubeEdgesTable();
            Lookup.generateIntersectionTable();
        }
    }
}

