/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public final class OldNoCubes
implements MeshGenerator {
    public static final int X0Y0Z0 = 0;
    public static final int X1Y0Z0 = 1;
    public static final int X1Y0Z1 = 2;
    public static final int X0Y0Z1 = 3;
    public static final int X0Y1Z0 = 4;
    public static final int X1Y1Z0 = 5;
    public static final int X1Y1Z1 = 6;
    public static final int X0Y1Z1 = 7;

    private static void resetPoints(Vec[] points) {
        points[0].set(0.0f, 0.0f, 0.0f);
        points[1].set(1.0f, 0.0f, 0.0f);
        points[2].set(1.0f, 0.0f, 1.0f);
        points[3].set(0.0f, 0.0f, 1.0f);
        points[4].set(0.0f, 1.0f, 0.0f);
        points[5].set(1.0f, 1.0f, 0.0f);
        points[6].set(1.0f, 1.0f, 1.0f);
        points[7].set(0.0f, 1.0f, 1.0f);
    }

    public BlockPos getPositiveAreaExtension() {
        return ModUtil.VEC_ONE;
    }

    public BlockPos getNegativeAreaExtension() {
        return ModUtil.VEC_ONE;
    }

    @Override
    public void generateOrThrow(Area area, Predicate<BlockState> isSmoothable, MeshGenerator.VoxelAction voxelAction, MeshGenerator.FaceAction faceAction) {
        BlockPos size = area.size;
        int depth = size.func_177952_p();
        int height = size.func_177956_o();
        int width = size.func_177958_n();
        BlockState[] blocks = area.getAndCacheBlocks();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        Face face = new Face();
        Vec[] points = new Vec[]{new Vec(), new Vec(), new Vec(), new Vec(), new Vec(), new Vec(), new Vec(), new Vec()};
        Direction[] directions = ModUtil.DIRECTIONS;
        int directionsLength = directions.length;
        float[] neighboursSmoothability = new float[directionsLength];
        float roughness = NoCubesConfig.Server.oldNoCubesRoughness;
        int index = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    BlockState state;
                    if (!this.isOutsideMesh(x, y, z, size) && isSmoothable.test(state = blocks[index])) {
                        float combinedNeighboursSmoothability = 0.0f;
                        for (int i = 0; i < directionsLength; ++i) {
                            Direction direction = directions[i];
                            pos.func_181079_c(x, y, z).func_189536_c(direction);
                            BlockState neighbour = blocks[area.index((BlockPos)pos)];
                            float density = ModUtil.getBlockDensity(isSmoothable, neighbour);
                            combinedNeighboursSmoothability += density;
                            neighboursSmoothability[i] = density;
                        }
                        float amountInsideIsosurface = combinedNeighboursSmoothability / (float)directionsLength / 2.0f + 0.5f;
                        if (!voxelAction.apply(pos.func_181079_c(x, y, z), amountInsideIsosurface)) {
                            return;
                        }
                        if (amountInsideIsosurface != 0.0f && !ModUtil.isSnowLayer(state)) {
                            OldNoCubes.resetPoints(points);
                            for (int pointIndex = 0; pointIndex < 8; ++pointIndex) {
                                Vec point = points[pointIndex];
                                point.x += (float)x;
                                point.y += (float)y;
                                point.z += (float)z;
                                if (OldNoCubes.doesPointIntersectWithManufactured(area, point, isSmoothable, pos)) continue;
                                if (pointIndex < 4 && OldNoCubes.doesPointBottomIntersectWithAir(area, point, pos)) {
                                    point.y = (float)y + 1.0f - 1.0E-4f;
                                } else if (pointIndex >= 4 && OldNoCubes.doesPointTopIntersectWithAir(area, point, pos)) {
                                    point.y = (float)y + 0.0f + 1.0E-4f;
                                }
                                OldNoCubes.givePointRoughness(roughness, area, point);
                            }
                            for (int i = 0; i < directionsLength; ++i) {
                                Direction direction = directions[i];
                                if (neighboursSmoothability[i] == 1.0f) continue;
                                switch (direction) {
                                    default: {
                                        face.v0.set(points[2]);
                                        face.v1.set(points[3]);
                                        face.v2.set(points[0]);
                                        face.v3.set(points[1]);
                                        break;
                                    }
                                    case UP: {
                                        face.v0.set(points[6]);
                                        face.v1.set(points[5]);
                                        face.v2.set(points[4]);
                                        face.v3.set(points[7]);
                                        break;
                                    }
                                    case NORTH: {
                                        face.v0.set(points[5]);
                                        face.v1.set(points[1]);
                                        face.v2.set(points[0]);
                                        face.v3.set(points[4]);
                                        break;
                                    }
                                    case SOUTH: {
                                        face.v0.set(points[6]);
                                        face.v1.set(points[7]);
                                        face.v2.set(points[3]);
                                        face.v3.set(points[2]);
                                        break;
                                    }
                                    case WEST: {
                                        face.v0.set(points[7]);
                                        face.v1.set(points[4]);
                                        face.v2.set(points[0]);
                                        face.v3.set(points[3]);
                                        break;
                                    }
                                    case EAST: {
                                        face.v0.set(points[6]);
                                        face.v1.set(points[2]);
                                        face.v2.set(points[1]);
                                        face.v3.set(points[5]);
                                    }
                                }
                                if (faceAction.apply(pos.func_181079_c(x, y, z), face)) continue;
                                return;
                            }
                        }
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    private static float max(float a, float b, float c, float d, float e, float f, float g, float h) {
        float max = a;
        if (b > max) {
            max = b;
        }
        if (c > max) {
            max = c;
        }
        if (d > max) {
            max = d;
        }
        if (e > max) {
            max = e;
        }
        if (f > max) {
            max = f;
        }
        if (g > max) {
            max = g;
        }
        if (h > max) {
            max = h;
        }
        return max;
    }

    private static float min(float a, float b, float c, float d, float e, float f, float g, float h) {
        float min = a;
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        if (d < min) {
            min = d;
        }
        if (e < min) {
            min = e;
        }
        if (f < min) {
            min = f;
        }
        if (g < min) {
            min = g;
        }
        if (h < min) {
            min = h;
        }
        return min;
    }

    public static void givePointRoughness(float roughness, Area area, Vec point) {
        double worldX = (float)area.start.func_177958_n() + point.x;
        double worldY = (float)area.start.func_177956_o() + point.y;
        double worldZ = (float)area.start.func_177952_p() + point.z;
        long i = (long)(worldX * 3129871.0) ^ (long)worldY * 116129781L ^ (long)worldZ;
        i = i * i * 42317861L + i * 11L;
        point.x += ((float)(i >> 16 & 0xFL) / 15.0f - 0.5f) * roughness;
        point.y += ((float)(i >> 20 & 0xFL) / 15.0f - 0.5f) * roughness;
        point.z += ((float)(i >> 24 & 0xFL) / 15.0f - 0.5f) * roughness;
    }

    public static boolean isBlockAirPlantOrSnowLayer(BlockState state) {
        return state.func_185904_a() == Material.field_151579_a || ModUtil.isPlant(state) || ModUtil.isSnowLayer(state);
    }

    public static boolean doesPointTopIntersectWithAir(Area area, Vec point, BlockPos.Mutable pos) {
        boolean intersects = false;
        for (int i = 0; i < 4; ++i) {
            int x = (int)(point.x - (float)(i & 1));
            int y = (int)point.y;
            int z = (int)(point.z - (float)(i >> 1 & 1));
            if (!OldNoCubes.isBlockAirPlantOrSnowLayer(area.getBlockState(pos.func_181079_c(x, y, z)))) {
                return false;
            }
            if (!OldNoCubes.isBlockAirPlantOrSnowLayer(area.getBlockState(pos.func_181079_c(x, y - 1, z)))) continue;
            intersects = true;
        }
        return intersects;
    }

    public static boolean doesPointBottomIntersectWithAir(Area area, Vec point, BlockPos.Mutable pos) {
        boolean intersects = false;
        boolean notOnly = false;
        for (int i = 0; i < 4; ++i) {
            int x = (int)(point.x - (float)(i & 1));
            int y = (int)point.y;
            int z = (int)(point.z - (float)(i >> 1 & 1));
            if (!OldNoCubes.isBlockAirPlantOrSnowLayer(area.getBlockState(pos.func_181079_c(x, y - 1, z)))) {
                return false;
            }
            if (!OldNoCubes.isBlockAirPlantOrSnowLayer(area.getBlockState(pos.func_181079_c(x, y + 1, z)))) {
                notOnly = true;
            }
            if (!OldNoCubes.isBlockAirPlantOrSnowLayer(area.getBlockState(pos.func_181079_c(x, y, z)))) continue;
            intersects = true;
        }
        return intersects && notOnly;
    }

    public static boolean doesPointIntersectWithManufactured(Area area, Vec point, Predicate<BlockState> isSmoothable, BlockPos.Mutable pos) {
        for (int i = 0; i < 4; ++i) {
            int x = (int)(point.x - (float)(i & 1));
            int y = (int)point.y;
            int z = (int)(point.z - (float)(i >> 1 & 1));
            BlockState state0 = area.getBlockState(pos.func_181079_c(x, y, z));
            if (!OldNoCubes.isBlockAirPlantOrSnowLayer(state0) && !isSmoothable.test(state0)) {
                return true;
            }
            BlockState state1 = area.getBlockState(pos.func_181079_c(x, y - 1, z));
            if (OldNoCubes.isBlockAirPlantOrSnowLayer(state1) || isSmoothable.test(state1)) continue;
            return true;
        }
        return false;
    }
}

