/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public interface MeshGenerator {
    public static final VoxelAction DEFAULT_VOXEL_ACTION;

    default public void generate(Area area, Predicate<BlockState> isSmoothable, FaceAction action) {
        this.generate(area, isSmoothable, DEFAULT_VOXEL_ACTION, action);
    }

    default public void generate(Area area, Predicate<BlockState> isSmoothable, VoxelAction voxelAction, FaceAction faceAction) {
        try {
            this.generateOrThrow(area, isSmoothable, voxelAction, faceAction);
        }
        catch (Throwable t) {
            if (!((Boolean)ModUtil.IS_DEVELOPER_WORKSPACE.get()).booleanValue()) {
                throw t;
            }
            t.getCause();
        }
    }

    public void generateOrThrow(Area var1, Predicate<BlockState> var2, VoxelAction var3, FaceAction var4);

    public Vector3i getPositiveAreaExtension();

    public Vector3i getNegativeAreaExtension();

    default public boolean isOutsideMesh(int x, int y, int z, BlockPos size) {
        Vector3i negativeExtension = this.getNegativeAreaExtension();
        Vector3i positiveExtension = this.getPositiveAreaExtension();
        return x >= size.func_177958_n() - positiveExtension.func_177958_n() || x < negativeExtension.func_177958_n() || y >= size.func_177956_o() - positiveExtension.func_177956_o() || y < negativeExtension.func_177956_o() || z >= size.func_177952_p() - positiveExtension.func_177952_p() || z < negativeExtension.func_177952_p();
    }

    public static void translateToMeshStart(MatrixStack matrix, BlockPos areaStart, BlockPos renderStartPos) {
        matrix.func_227861_a_((double)MeshGenerator.validateMeshOffset(areaStart.func_177958_n() - renderStartPos.func_177958_n()), (double)MeshGenerator.validateMeshOffset(areaStart.func_177956_o() - renderStartPos.func_177956_o()), (double)MeshGenerator.validateMeshOffset(areaStart.func_177952_p() - renderStartPos.func_177952_p()));
    }

    public static int validateMeshOffset(int meshOffset) {
        if (!1.$assertionsDisabled && meshOffset > 0) {
            throw new AssertionError((Object)"Mesh generators won't require a smaller area than they are generating a mesh for");
        }
        if (!1.$assertionsDisabled && meshOffset <= -2) {
            throw new AssertionError((Object)"Mesh generators won't require more than 2 extra blocks on each axis");
        }
        return meshOffset;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        DEFAULT_VOXEL_ACTION = (pos, amount) -> true;
    }

    public static interface VoxelAction {
        public boolean apply(BlockPos.Mutable var1, float var2);
    }

    public static interface FaceAction {
        public boolean apply(BlockPos.Mutable var1, Face var2);
    }
}

