/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.hooks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.render.RendererDispatcher;
import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.hooks.SelfCheck;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;

public final class Hooks {
    @OnlyIn(value=Dist.CLIENT)
    public static void preIteration(ChunkRenderDispatcher.ChunkRender.RebuildTask rebuildTask, ChunkRenderDispatcher.ChunkRender chunkRender, ChunkRenderDispatcher.CompiledChunk compiledChunkIn, RegionRenderCacheBuilder builderIn, BlockPos blockpos, IBlockDisplayReader chunkrendercache, MatrixStack matrixstack, Random random, BlockRendererDispatcher blockrendererdispatcher) {
        SelfCheck.preIteration = true;
        RendererDispatcher.renderChunk(rebuildTask, chunkRender, compiledChunkIn, builderIn, blockpos, chunkrendercache, matrixstack, random, blockrendererdispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FluidState getRenderFluidState(BlockPos pos) {
        SelfCheck.getRenderFluidState = true;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return Fluids.field_204541_a.func_207188_f();
        }
        return world.func_204610_c(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canBlockStateRender(BlockState state) {
        SelfCheck.canBlockStateRender = true;
        return !NoCubesConfig.Client.render || !NoCubes.smoothableHandler.isSmoothable(state) && (!NoCubesConfig.Client.fixPlantHeight || !ModUtil.isShortPlant(state));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderBlockDamage(BlockRendererDispatcher dispatcher, BlockState state, BlockPos pos, IBlockDisplayReader world, MatrixStack matrix, IVertexBuilder buffer, IModelData modelData) {
        SelfCheck.renderBlockDamage = true;
        if (!NoCubesConfig.Client.render || !NoCubes.smoothableHandler.isSmoothable(state)) {
            return false;
        }
        RendererDispatcher.renderBreakingTexture(dispatcher, state, pos, world, matrix, buffer, modelData);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setBlocksDirty(Minecraft minecraft, WorldRenderer worldRenderer, BlockPos pos, BlockState oldState, BlockState newState) {
        SelfCheck.setBlocksDirty = true;
        if (minecraft.func_209506_al().func_224742_a(oldState, newState)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int extension = NoCubesConfig.Client.render ? 2 : 1;
            worldRenderer.func_147585_a(x - extension, y - extension, z - extension, x + extension, y + extension, z + extension);
        }
    }

    @Nullable
    public static Boolean canOccludeOverride(BlockState state) {
        SelfCheck.canOccludeOverride = true;
        if (NoCubesConfig.Client.render && NoCubes.smoothableHandler.isSmoothable(state)) {
            return false;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FluidBlockRenderer createFluidBlockRenderer(FluidBlockRenderer original) {
        SelfCheck.createFluidBlockRenderer = true;
        return new FluidBlockRenderer(){

            public boolean func_228796_a_(IBlockDisplayReader ignored, BlockPos posIn, IVertexBuilder vertexBuilderIn, FluidState fluidStateIn) {
                return super.func_228796_a_((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, posIn, vertexBuilderIn, fluidStateIn);
            }
        };
    }

    @Nullable
    public static VoxelShape getCollisionShapeOverride(BlockState state, IBlockReader world, BlockPos pos) {
        SelfCheck.getCollisionShapeNoContextOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable(state)) {
            return CollisionHandler.getCollisionShape(state, world, pos, ISelectionContext.func_216377_a());
        }
        return null;
    }

    @Nullable
    public static VoxelShape getCollisionShapeOverride(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        SelfCheck.getCollisionShapeWithContextOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable(state)) {
            return CollisionHandler.getCollisionShape(state, world, pos, context);
        }
        return null;
    }

    @Nullable
    public static Boolean isCollisionShapeFullBlockOverride(BlockState state, IBlockReader reader, BlockPos pos) {
        SelfCheck.isCollisionShapeFullBlockOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable(state)) {
            return false;
        }
        return null;
    }

    @Nullable
    public static Boolean hasLargeCollisionShapeOverride(BlockState state) {
        SelfCheck.hasLargeCollisionShapeOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable(state)) {
            return true;
        }
        return null;
    }

    @Nullable
    public static Boolean isSuffocatingOverride(BlockState state, IBlockReader world, BlockPos pos) {
        SelfCheck.isSuffocatingOverride = true;
        if (NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable(state)) {
            return false;
        }
        return null;
    }

    @Nullable
    public static FluidState getFluidStateOverride(World world, BlockPos pos) {
        SelfCheck.getFluidStateOverride = true;
        if (NoCubesConfig.Server.extendFluidsRange <= 0) {
            return null;
        }
        return ModUtil.getExtendedFluidState(world, pos);
    }

    public static void loadClasses(Dist dist) {
        Hooks.loadClass("net.minecraft.block.AbstractBlock$AbstractBlockState");
        Hooks.loadClass("net.minecraft.block.BlockState");
        Hooks.loadClass("net.minecraft.world.World");
        if (dist.isClient()) {
            Hooks.loadClass("net.minecraft.client.renderer.BlockRendererDispatcher");
            Hooks.loadClass("net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$ChunkRender$RebuildTask");
            Hooks.loadClass("net.minecraft.client.world.ClientWorld");
            Hooks.loadClass("net.minecraft.client.renderer.chunk.ChunkRenderCache");
        }
    }

    private static void loadClass(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class \"" + className + "\", probably a coremod issue", e);
        }
        try {
            Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to initialise class \"" + className + "\", probably a coremod issue", e);
        }
    }
}

