/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.config.ColorParser;
import io.github.cadiboo.nocubes.mesh.CullingCubic;
import io.github.cadiboo.nocubes.mesh.MarchingCubes;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.OldNoCubes;
import io.github.cadiboo.nocubes.mesh.StupidCubic;
import io.github.cadiboo.nocubes.mesh.SurfaceNets;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.network.S2CUpdateServerConfig;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="nocubes", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class NoCubesConfig {
    private static long lastSavedClientConfigAt = -1L;
    private static long lastSavedServerConfigAt = -1L;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, Client.SPEC);
        context.registerConfig(ModConfig.Type.SERVER, Server.SPEC);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        ForgeConfigSpec spec = config.getSpec();
        if (spec == Client.SPEC && NoCubesConfig.didNotSaveConfigRecently(lastSavedClientConfigAt)) {
            Client.bake(config);
            lastSavedClientConfigAt = -1L;
        } else if (spec == Server.SPEC && NoCubesConfig.didNotSaveConfigRecently(lastSavedServerConfigAt)) {
            Server.bake(config);
            lastSavedServerConfigAt = -1L;
        }
    }

    static boolean didNotSaveConfigRecently(long lastSavedConfigAt) {
        long ten_seconds = 10000000000L;
        long now = System.nanoTime();
        return now - 10000000000L > lastSavedConfigAt;
    }

    public static class Smoothables {
        private static final Set<BlockState> DEFAULT_SMOOTHABLES = Sets.newIdentityHashSet();

        static void updateSmoothables(boolean newValue, BlockState[] states, List<String> whitelist, List<String> blacklist) {
            List<String> toAddTo = newValue ? whitelist : blacklist;
            List<String> toRemoveFrom = newValue ? blacklist : whitelist;
            for (BlockState state : states) {
                String string = BlockStateConverter.toString(state);
                NoCubes.smoothableHandler.setSmoothable(newValue, state);
                if (!toAddTo.contains(string)) {
                    toAddTo.add(string);
                }
                while (toRemoveFrom.remove(string)) {
                }
            }
        }

        static void recomputeInMemoryLookup(List<? extends String> whitelist, List<? extends String> blacklist) {
            Set<BlockState> whitelisted = Smoothables.parseBlockStates(whitelist);
            Set<BlockState> blacklisted = Smoothables.parseBlockStates(blacklist);
            ForgeRegistries.BLOCKS.getValues().parallelStream().flatMap(block -> ModUtil.getStates(block).parallelStream()).forEach(state -> {
                if (blacklisted.contains(state)) {
                    NoCubes.smoothableHandler.removeSmoothable((BlockState)state);
                } else if (whitelisted.contains(state) || DEFAULT_SMOOTHABLES.contains(state)) {
                    NoCubes.smoothableHandler.addSmoothable((BlockState)state);
                }
            });
        }

        static Set<BlockState> parseBlockStates(List<? extends String> list) {
            Set set = Sets.newIdentityHashSet();
            list.parallelStream().map(BlockStateConverter::fromStringOrNull).filter(Objects::nonNull).forEach(set::add);
            return set;
        }

        public static void addDefault(BlockState ... states) {
            DEFAULT_SMOOTHABLES.addAll(Arrays.asList(states));
        }

        static {
            ArrayList vanilla = Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150348_b.func_176223_P(), (BlockState)Blocks.field_196658_i.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(false)), (BlockState)Blocks.field_196658_i.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(true)), Blocks.field_150348_b.func_176223_P(), Blocks.field_196650_c.func_176223_P(), Blocks.field_196654_e.func_176223_P(), Blocks.field_196656_g.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_196660_k.func_176223_P(), (BlockState)Blocks.field_196661_l.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(false)), (BlockState)Blocks.field_196661_l.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(true)), Blocks.field_150354_m.func_176223_P(), Blocks.field_196611_F.func_176223_P(), Blocks.field_150322_A.func_176223_P(), Blocks.field_180395_cM.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150365_q.func_176223_P(), Blocks.field_150366_p.func_176223_P(), Blocks.field_150352_o.func_176223_P(), (BlockState)Blocks.field_150450_ax.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)), (BlockState)Blocks.field_150450_ax.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), Blocks.field_150482_ag.func_176223_P(), Blocks.field_150369_x.func_176223_P(), Blocks.field_150412_bA.func_176223_P(), Blocks.field_196766_fg.func_176223_P(), Blocks.field_235334_I_.func_176223_P(), Blocks.field_196686_dc.func_176223_P(), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Y), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Z), Blocks.field_185774_da.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), Blocks.field_196777_fo.func_176223_P(), Blocks.field_196778_fp.func_176223_P(), Blocks.field_196780_fq.func_176223_P(), Blocks.field_196782_fr.func_176223_P(), Blocks.field_196783_fs.func_176223_P(), Blocks.field_196785_ft.func_176223_P(), Blocks.field_196787_fu.func_176223_P(), Blocks.field_196789_fv.func_176223_P(), Blocks.field_196791_fw.func_176223_P(), Blocks.field_196793_fx.func_176223_P(), Blocks.field_196795_fy.func_176223_P(), Blocks.field_196797_fz.func_176223_P(), Blocks.field_196719_fA.func_176223_P(), Blocks.field_196720_fB.func_176223_P(), Blocks.field_196721_fC.func_176223_P(), Blocks.field_196722_fD.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), Blocks.field_150403_cj.func_176223_P(), (BlockState)Blocks.field_185778_de.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208168_U, (Comparable)Integer.valueOf(0)), (BlockState)Blocks.field_185778_de.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208168_U, (Comparable)Integer.valueOf(1)), (BlockState)Blocks.field_185778_de.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208168_U, (Comparable)Integer.valueOf(2)), (BlockState)Blocks.field_185778_de.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208168_U, (Comparable)Integer.valueOf(3)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(1)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(2)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(3)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(4)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(5)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(6)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(7)), (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(8)), Blocks.field_196604_cC.func_176223_P(), Blocks.field_150357_h.func_176223_P(), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), Blocks.field_235336_cN_.func_176223_P(), Blocks.field_235337_cO_.func_176223_P(), Blocks.field_196814_hQ.func_176223_P(), Blocks.field_150426_aN.func_176223_P(), Blocks.field_189878_dg.func_176223_P(), Blocks.field_235377_mq_.func_176223_P(), Blocks.field_235372_ml_.func_176223_P(), Blocks.field_235374_mn_.func_176223_P(), Blocks.field_235368_mh_.func_176223_P(), Blocks.field_150377_bs.func_176223_P(), (BlockState)Blocks.field_150391_bh.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(false)), (BlockState)Blocks.field_150391_bh.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(true))});
            for (Block log : new Block[]{Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_196619_M, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P}) {
                for (Direction.Axis axis : Direction.Axis.values()) {
                    vanilla.add(log.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)axis));
                }
            }
            for (Block leaves : new Block[]{Blocks.field_196642_W, Blocks.field_196645_X, Blocks.field_196647_Y, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196574_ab}) {
                for (int distance = 1; distance <= 7; ++distance) {
                    vanilla.add(leaves.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(distance)));
                }
            }
            String[] modded = new String[]{"biomesoplenty:grass[snowy=false,variant=sandy]", "biomesoplenty:dirt[coarse=false,variant=sandy]", "biomesoplenty:white_sand", "biomesoplenty:grass[snowy=false,variant=silty]", "biomesoplenty:dirt[coarse=false,variant=loamy]", "biomesoplenty:grass[snowy=false,variant=loamy]", "biomesoplenty:dried_sand", "biomesoplenty:hard_ice", "biomesoplenty:mud[variant=mud]", "biomesoplenty:dirt[coarse=false,variant=silty]", "chisel:marble2[variation=7]", "chisel:limestone2[variation=7]", "dynamictrees:rootydirtspecies[life=0]", "dynamictrees:rootysand[life=0]", "iceandfire:ash", "iceandfire:sapphire_ore", "iceandfire:chared_grass", "iceandfire:chared_stone", "iceandfire:frozen_grass_path", "notenoughroofs:copper_ore", "rustic:slate"};
            DEFAULT_SMOOTHABLES.addAll(vanilla);
            DEFAULT_SMOOTHABLES.addAll(Smoothables.parseBlockStates(Arrays.asList(modded)));
        }
    }

    public static class ReloadHacks {
        static void saveAndLoad(ModConfig.Type type) {
            ReloadHacks.ConfigTracker_getConfig("nocubes", type).ifPresent(modConfig -> {
                modConfig.save();
                ((CommentedFileConfig)modConfig.getConfigData()).load();
                modConfig.getSpec().afterReload();
                ReloadHacks.fireReloadEvent(modConfig);
            });
        }

        private static Optional<ModConfig> ConfigTracker_getConfig(String modId, ModConfig.Type type) {
            Map configsByMod = (Map)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"configsByMod");
            return Optional.ofNullable(configsByMod.getOrDefault(modId, Collections.emptyMap()).getOrDefault(type, null));
        }

        private static void ModConfig_setConfigData(ModConfig modConfig, CommentedConfig data) {
            Method setConfigData = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
            try {
                setConfigData.invoke((Object)modConfig, data);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not set config data for config " + modConfig, e);
            }
        }

        private static void fireReloadEvent(ModConfig modConfig) {
            ModConfig.Reloading event;
            ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(modConfig.getModId()).get();
            try {
                event = (ModConfig.Reloading)ObfuscationReflectionHelper.findConstructor(ModConfig.Reloading.class, (Class[])new Class[]{ModConfig.class}).newInstance(modConfig);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            modContainer.dispatchConfigEvent((ModConfig.ModConfigEvent)event);
        }

        public static void receiveSyncedServerConfig(S2CUpdateServerConfig s2CConfigData) {
            assert (FMLEnvironment.dist.isClient());
            ModConfig modConfig = ReloadHacks.ConfigTracker_getConfig("nocubes", ModConfig.Type.SERVER).get();
            ConfigParser parser = modConfig.getConfigData().configFormat().createParser();
            ReloadHacks.ModConfig_setConfigData(modConfig, (CommentedConfig)parser.parse((InputStream)new ByteArrayInputStream(s2CConfigData.getBytes())));
            ReloadHacks.fireReloadEvent(modConfig);
        }
    }

    public static class Server {
        public static final Impl INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public static MeshGenerator meshGenerator;
        public static boolean collisionsEnabled;
        public static boolean forceVisuals;
        public static int extendFluidsRange;
        public static float oldNoCubesRoughness;

        public static void bake(ModConfig config) {
            int oldChunkRenderSettingsHash = Server.hashChunkRenderSettings();
            Smoothables.recomputeInMemoryLookup((List)Server.INSTANCE.smoothableWhitelist.get(), (List)Server.INSTANCE.smoothableBlacklist.get());
            meshGenerator = ((MeshGeneratorEnum)((Object)Server.INSTANCE.meshGenerator.get())).generator;
            collisionsEnabled = (Boolean)Server.INSTANCE.collisionsEnabled.get();
            forceVisuals = (Boolean)Server.INSTANCE.forceVisuals.get();
            if (forceVisuals) {
                Client.render = true;
            }
            if ((extendFluidsRange = ((Integer)Server.INSTANCE.extendFluidsRange.get()).intValue()) < 0 || extendFluidsRange > 2) {
                throw new IllegalStateException("Config was not validated! 'extendFluidsRange' must be between 0 and 2 but was " + extendFluidsRange);
            }
            oldNoCubesRoughness = ((Double)Server.INSTANCE.oldNoCubesRoughness.get()).floatValue();
            if (oldNoCubesRoughness < 0.0f || oldNoCubesRoughness > 1.0f) {
                throw new IllegalStateException("Config was not validated! 'oldNoCubesRoughness' must be between 0 and 1 but was " + oldNoCubesRoughness);
            }
            if (oldChunkRenderSettingsHash != Server.hashChunkRenderSettings()) {
                DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtil::reloadAllChunks);
            }
            if (FMLEnvironment.dist.isDedicatedServer()) {
                NoCubesNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)S2CUpdateServerConfig.create(config));
            }
        }

        private static int hashChunkRenderSettings() {
            return Objects.hash(meshGenerator, forceVisuals);
        }

        public static void updateSmoothable(boolean newValue, BlockState ... states) {
            Smoothables.updateSmoothables(newValue, states, (List)Server.INSTANCE.smoothableWhitelist.get(), (List)Server.INSTANCE.smoothableBlacklist.get());
            Server.saveAndLoad();
        }

        private static void saveAndLoad() {
            lastSavedServerConfigAt = -1L;
            ReloadHacks.saveAndLoad(ModConfig.Type.SERVER);
            lastSavedServerConfigAt = System.nanoTime();
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(x$0 -> new Impl((ForgeConfigSpec.Builder)x$0));
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Impl)specPair.getLeft();
        }

        static class Impl {
            final ForgeConfigSpec.ConfigValue<List<? extends String>> smoothableWhitelist;
            final ForgeConfigSpec.ConfigValue<List<? extends String>> smoothableBlacklist;
            final ForgeConfigSpec.EnumValue<MeshGeneratorEnum> meshGenerator;
            final ForgeConfigSpec.BooleanValue collisionsEnabled;
            final ForgeConfigSpec.BooleanValue forceVisuals;
            final ForgeConfigSpec.IntValue extendFluidsRange;
            final ForgeConfigSpec.DoubleValue oldNoCubesRoughness;

            private Impl(ForgeConfigSpec.Builder builder) {
                this.smoothableWhitelist = builder.translation("nocubes.config.smoothableWhitelist").comment("What blocks should be smoothed by NoCubes").defineListAllowEmpty(Collections.singletonList("smoothableWhitelist"), Lists::newArrayList, String.class::isInstance);
                this.smoothableBlacklist = builder.translation("nocubes.config.smoothableBlacklist").comment("What blocks should not be smoothed by NoCubes").defineListAllowEmpty(Collections.singletonList("smoothableBlacklist"), Lists::newArrayList, String.class::isInstance);
                this.collisionsEnabled = builder.translation("nocubes.config.collisionsEnabled").comment("If players should be able to walk up the smooth slopes generated by NoCubes").define("collisionsEnabled", true);
                this.meshGenerator = builder.translation("nocubes.config.meshGenerator").comment("meshGenerator").defineEnum("meshGenerator", (Enum)MeshGeneratorEnum.SurfaceNets);
                this.forceVisuals = builder.translation("nocubes.config.forceVisuals").comment(new String[]{"For MMO servers that require NoCubes to be enabled for a proper player experience.", "If you enable this make sure that you've manually checked that every chunk is navigable!"}).define("forceVisuals", false);
                this.extendFluidsRange = builder.translation("nocubes.config.extendFluidsRange").comment("The range at which to extend fluids (water & lava) into smoothable blocks").defineInRange("extendFluidsRange", 1, 0, 2);
                this.oldNoCubesRoughness = builder.translation("nocubes.config.oldNoCubesRoughness").comment("How much pseudo-random roughness should be applied to mesh generated by OldNoCubes").defineInRange("oldNoCubesRoughness", 0.5, 0.0, 1.0);
            }
        }

        public static enum MeshGeneratorEnum {
            SurfaceNets(new SurfaceNets()),
            OldNoCubes(new OldNoCubes()),
            Debug_MarchingCubes(new MarchingCubes()),
            Debug_CullingCubic(new CullingCubic()),
            Debug_StupidCubic(new StupidCubic());

            public final MeshGenerator generator;

            private MeshGeneratorEnum(MeshGenerator generator) {
                this.generator = generator;
            }
        }
    }

    public static class Client {
        public static final Impl INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public static boolean render;
        public static ColorParser.Color selectionBoxColor;
        public static boolean betterGrassSides;
        public static boolean moreSnow;
        public static boolean fixPlantHeight;
        public static boolean grassTufts;
        public static boolean debugEnabled;
        public static boolean debugOutlineSmoothables;
        public static boolean debugVisualiseDensitiesGrid;
        public static boolean debugRenderCollisions;
        public static boolean debugRenderMeshCollisions;
        public static boolean debugRecordMeshPerformance;
        public static boolean debugOutlineNearbyMesh;

        public static void bake(ModConfig config) {
            boolean oldRender = render;
            int oldChunkRenderSettingsHash = Client.hashChunkRenderSettings();
            render = Server.forceVisuals || (Boolean)Client.INSTANCE.render.get() != false;
            selectionBoxColor = ColorParser.parse((String)Client.INSTANCE.selectionBoxColor.get());
            betterGrassSides = (Boolean)Client.INSTANCE.betterGrassSides.get();
            moreSnow = (Boolean)Client.INSTANCE.moreSnow.get();
            fixPlantHeight = (Boolean)Client.INSTANCE.fixPlantHeight.get();
            grassTufts = (Boolean)Client.INSTANCE.grassTufts.get();
            if (oldRender != render || render && oldChunkRenderSettingsHash != Client.hashChunkRenderSettings()) {
                ClientUtil.reloadAllChunks();
            }
            debugEnabled = (Boolean)Client.INSTANCE.debugEnabled.get();
            debugOutlineSmoothables = (Boolean)Client.INSTANCE.debugOutlineSmoothables.get();
            debugVisualiseDensitiesGrid = (Boolean)Client.INSTANCE.debugVisualiseDensitiesGrid.get();
            debugRenderCollisions = (Boolean)Client.INSTANCE.debugRenderCollisions.get();
            debugRenderMeshCollisions = (Boolean)Client.INSTANCE.debugRenderMeshCollisions.get();
            debugRecordMeshPerformance = (Boolean)Client.INSTANCE.debugRecordMeshPerformance.get();
            debugOutlineNearbyMesh = (Boolean)Client.INSTANCE.debugOutlineNearbyMesh.get();
        }

        private static int hashChunkRenderSettings() {
            return Objects.hash(betterGrassSides, moreSnow, fixPlantHeight, grassTufts);
        }

        public static void updateRender(boolean newValue) {
            Client.INSTANCE.render.set((Object)newValue);
            Client.saveAndLoad();
        }

        private static void saveAndLoad() {
            lastSavedClientConfigAt = -1L;
            ReloadHacks.saveAndLoad(ModConfig.Type.CLIENT);
            lastSavedClientConfigAt = System.nanoTime();
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(x$0 -> new Impl((ForgeConfigSpec.Builder)x$0));
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Impl)specPair.getLeft();
        }

        static class Impl {
            final ForgeConfigSpec.BooleanValue render;
            final ForgeConfigSpec.ConfigValue<String> selectionBoxColor;
            final ForgeConfigSpec.BooleanValue betterGrassSides;
            final ForgeConfigSpec.BooleanValue moreSnow;
            final ForgeConfigSpec.BooleanValue fixPlantHeight;
            final ForgeConfigSpec.BooleanValue grassTufts;
            final ForgeConfigSpec.BooleanValue debugEnabled;
            final ForgeConfigSpec.BooleanValue debugOutlineSmoothables;
            final ForgeConfigSpec.BooleanValue debugVisualiseDensitiesGrid;
            final ForgeConfigSpec.BooleanValue debugRenderCollisions;
            final ForgeConfigSpec.BooleanValue debugRenderMeshCollisions;
            final ForgeConfigSpec.BooleanValue debugRecordMeshPerformance;
            final ForgeConfigSpec.BooleanValue debugOutlineNearbyMesh;

            private Impl(ForgeConfigSpec.Builder builder) {
                this.render = builder.translation("nocubes.config.render").comment("If NoCubes' custom rendering is enabled").define("render", true);
                this.selectionBoxColor = builder.translation("nocubes.config.selectionBoxColor").comment(new String[]{"The color of the outline (selection box) over a smoothed block.", "Supports pretty much any format you can imagine.", "Some examples of ways to define colors:", "By name: \"red\"", "By name: \"firebrick\" (a red-orangeish color)", "By name: \"gainsboro\" (a light gray color)", "With RGB (red, green, blue) integers (0-255): \"rgb(255, 0, 0)\" (pure red)", "With RGB (red, green, blue) floats (0.0-1.0): \"rgb(1.0, 0, 0)\" (also pure red)", "With RGBA (red, green, blue, alpha) integers (0-255): \"rgba(255, 0, 0, 0.5)\" (partially transparent pure red)", "With RGBA (red, green, blue, alpha) integers (0-255): \"rgba(1.0, 0, 0, 1.0)\" (also partially transparent pure red)", "With hexadecimal (case insensitive) RGB (red, green, blue) integers (00-FF): \"0x0ff\" (aqua)", "With hexadecimal (case insensitive) RGBA (red, green, blue, alpha) integers (00-FF): \"#0FF6\" (partially transparent aqua)", "With HSL (hue, saturation, lightness): \"hsl(270, 100%, 100%)\" (a dark purple)", "With HSLA (hue, saturation, lightness, alpha): \"hsla(270, 100%, 100%, 0.5)\" (a partially transparent dark purple)"}).define("selectionBoxColor", (Object)"#0006");
                this.betterGrassSides = builder.translation("nocubes.config.betterGrassSides").comment(new String[]{"Similar to OptiFine's 'Better Grass' feature", "OFF - The sides of grass blocks have the default texture", "ON - The sides of grass blocks have the texture of the top of the block"}).define("betterGrassSides", false);
                this.moreSnow = builder.translation("nocubes.config.moreSnow").comment(new String[]{"Similar to OptiFine's 'Better Snow' feature", "OFF - The sides of blocks nearby snow have their own texture", "ON - The sides of blocks nearby snow have the snow texture"}).define("moreSnow", false);
                this.fixPlantHeight = builder.translation("nocubes.config.fixPlantHeight").comment("If small plants like flowers and grass should be moved onto NoCubes' terrain").define("fixPlantHeight", false);
                this.grassTufts = builder.translation("nocubes.config.grassTufts").comment("If small tufts of grass should be rendered on top of grass blocks, similar to BetterFoliage's 'Short Grass' feature").define("grassTufts", false);
                builder.push("debug");
                this.debugEnabled = builder.translation("nocubes.config.debugEnabled").comment("If debugging features should be enabled").define("debugEnabled", false);
                this.debugOutlineSmoothables = builder.define("debugOutlineSmoothables", false);
                this.debugVisualiseDensitiesGrid = builder.define("debugVisualiseDensitiesGrid", false);
                this.debugRenderCollisions = builder.define("debugRenderCollisions", false);
                this.debugRenderMeshCollisions = builder.define("debugRenderMeshCollisions", false);
                this.debugRecordMeshPerformance = builder.define("debugRecordMeshPerformance", false);
                this.debugOutlineNearbyMesh = builder.define("debugOutlineNearbyMesh", false);
                builder.pop();
            }
        }
    }
}

