/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.collision;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.OldNoCubes;
import io.github.cadiboo.nocubes.mesh.SurfaceNets;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class CollisionHandler {
    public static VoxelShape getCollisionShape(BlockState state, IBlockReader reader, BlockPos blockPos, ISelectionContext context) {
        boolean canCollide = state.func_177230_c().field_235688_at_;
        try {
            return CollisionHandler.getCollisionShapeOrThrow(canCollide, state, reader, blockPos, context);
        }
        catch (Throwable t) {
            if (!((Boolean)ModUtil.IS_DEVELOPER_WORKSPACE.get()).booleanValue()) {
                throw t;
            }
            return canCollide ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VoxelShape getCollisionShapeOrThrow(boolean canCollide, BlockState state, IBlockReader reader, BlockPos blockPos, ISelectionContext context) {
        if (!canCollide) {
            return VoxelShapes.func_197880_a();
        }
        assert (NoCubesConfig.Server.collisionsEnabled);
        assert (NoCubes.smoothableHandler.isSmoothable(state));
        Entity entity = context.getEntity();
        if (entity instanceof FallingBlockEntity || entity == null || reader.func_180495_p(blockPos) != state) {
            return state.func_196954_c(reader, blockPos);
        }
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        VoxelShape[] ref = new VoxelShape[]{VoxelShapes.func_197880_a()};
        if (reader instanceof World) {
            ((World)reader).func_217381_Z().func_76320_a("NoCubes collisions");
        }
        try (Area area = new Area(reader, blockPos, ModUtil.VEC_ONE, generator);){
            float dx = MeshGenerator.validateMeshOffset(area.start.func_177958_n() - blockPos.func_177958_n());
            float dy = MeshGenerator.validateMeshOffset(area.start.func_177956_o() - blockPos.func_177956_o());
            float dz = MeshGenerator.validateMeshOffset(area.start.func_177952_p() - blockPos.func_177952_p());
            CollisionHandler.generate(area, generator, (x0, y0, z0, x1, y1, z1) -> {
                VoxelShape shape = VoxelShapes.func_197873_a((double)(x0 + dx), (double)(y0 + dy), (double)(z0 + dz), (double)(x1 + dx), (double)(y1 + dy), (double)(z1 + dz));
                ref[0] = VoxelShapes.func_197882_b((VoxelShape)ref[0], (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            });
        }
        finally {
            if (reader instanceof World) {
                ((World)reader).func_217381_Z().func_76319_b();
            }
        }
        return ref[0];
    }

    public static void generate(Area area, MeshGenerator generator, IShapeConsumer consumer) {
        Face vertexNormals = new Face();
        Vec faceNormal = new Vec();
        Vec centre = new Vec();
        Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
        generator.generate(area, isSmoothable, (pos, amount) -> {
            if (amount == 1.0f) {
                float x0 = pos.func_177958_n();
                float y0 = pos.func_177956_o();
                float z0 = pos.func_177952_p();
                if (generator instanceof SurfaceNets) {
                    x0 += 0.5f;
                    y0 += 0.5f;
                    z0 += 0.5f;
                }
                consumer.accept(x0, y0, z0, x0 + 1.0f, y0 + 1.0f, z0 + 1.0f);
            }
            return true;
        }, (pos, face) -> {
            face.assignAverageTo(centre);
            face.assignNormalTo(vertexNormals);
            vertexNormals.assignAverageTo(faceNormal);
            if (generator instanceof OldNoCubes) {
                faceNormal.multiply(1.0E-5f);
            }
            CollisionHandler.generateShape(centre, faceNormal, consumer, face.v0);
            CollisionHandler.generateShape(centre, faceNormal, consumer, face.v1);
            CollisionHandler.generateShape(centre, faceNormal, consumer, face.v2);
            CollisionHandler.generateShape(centre, faceNormal, consumer, face.v3);
            return true;
        });
    }

    private static void generateShape(Vec centre, Vec faceNormal, IShapeConsumer consumer, Vec v) {
        consumer.accept(v.x, v.y, v.z, centre.x + faceNormal.x, centre.y + faceNormal.y, centre.z + faceNormal.z);
    }

    public static interface IShapeConsumer {
        public void accept(float var1, float var2, float var3, float var4, float var5, float var6);
    }
}

