/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.RollingProfiler;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.client.optifine.OptiFineProxy;
import io.github.cadiboo.nocubes.client.render.FluentMatrixStack;
import io.github.cadiboo.nocubes.client.render.LightCache;
import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.client.render.struct.Color;
import io.github.cadiboo.nocubes.client.render.struct.FaceLight;
import io.github.cadiboo.nocubes.client.render.struct.Texture;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.IModelData;

public final class RendererDispatcher {
    private static final RollingProfiler totalProfiler = new RollingProfiler(256);
    private static final RollingProfiler fluidsProfiler = new RollingProfiler(256);
    private static final RollingProfiler meshProfiler = new RollingProfiler(256);

    public static void renderChunk(ChunkRenderDispatcher.ChunkRender.RebuildTask rebuildTask, ChunkRenderDispatcher.ChunkRender chunkRender, ChunkRenderDispatcher.CompiledChunk compiledChunk, RegionRenderCacheBuilder buffers, BlockPos chunkPos, IBlockDisplayReader world, MatrixStack matrixStack, Random random, BlockRendererDispatcher dispatcher) {
        long start = System.nanoTime();
        FluentMatrixStack matrix = new FluentMatrixStack(matrixStack);
        try (LightCache light = new LightCache(Minecraft.func_71410_x().field_71441_e, chunkPos, ModUtil.CHUNK_SIZE);
             FluentMatrixStack ignored = matrix.push();){
            OptiFineProxy optiFine = OptiFineCompatibility.proxy();
            optiFine.preRenderChunk(chunkRender, chunkPos, matrixStack);
            ChunkRenderInfo renderer = new ChunkRenderInfo(rebuildTask, chunkRender, compiledChunk, buffers, chunkPos, world, matrix, random, dispatcher, light, optiFine);
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            RendererDispatcher.renderChunkFluids(renderer);
            if (NoCubesConfig.Client.render) {
                RendererDispatcher.renderChunkMesh(renderer, isSmoothable);
            }
        }
        totalProfiler.recordAndLogElapsedNanosChunk(start, "total");
    }

    public static void renderBreakingTexture(BlockRendererDispatcher dispatcher, BlockState state, BlockPos pos, IBlockDisplayReader world, MatrixStack matrix, IVertexBuilder buffer, IModelData modelData) {
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        try (Area area = new Area((IBlockReader)Minecraft.func_71410_x().field_71441_e, pos, ModUtil.VEC_ONE, generator);){
            MeshRenderer.renderBreakingTexture(state, pos, matrix, buffer, generator, area);
        }
    }

    private static void renderChunkFluids(ChunkRenderInfo renderer) {
    }

    private static void renderChunkMesh(ChunkRenderInfo renderer, Predicate<BlockState> isSmoothable) {
        long start = System.nanoTime();
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        try (Area area = new Area((IBlockReader)Minecraft.func_71410_x().field_71441_e, renderer.chunkPos, ModUtil.CHUNK_SIZE, generator);
             FluentMatrixStack ignored = renderer.matrix.push();){
            MeshRenderer.renderArea(renderer, isSmoothable, generator, area);
        }
        meshProfiler.recordAndLogElapsedNanosChunk(start, "mesh");
    }

    public static void renderInLayers(ChunkRenderDispatcher.ChunkRender chunkRender, ChunkRenderDispatcher.CompiledChunk compiledChunk, RegionRenderCacheBuilder buffers, OptiFineProxy optiFine, Predicate<RenderType> predicate, BiFunction<RenderType, BufferBuilder, Object> preRender, RenderInLayer render, BiConsumer<BufferBuilder, Object> postRender) {
        List chunkBufferLayers = RenderType.func_228661_n_();
        int chunkBufferLayersSize = chunkBufferLayers.size();
        for (int i = 0; i < chunkBufferLayersSize; ++i) {
            RenderType layer = (RenderType)chunkBufferLayers.get(i);
            if (!predicate.test(layer)) continue;
            BufferBuilder buffer = RendererDispatcher.getAndStartBuffer(chunkRender, compiledChunk, buffers, layer);
            Object renderEnv = preRender.apply(layer, buffer);
            boolean used = render.render(layer, buffer, renderEnv);
            postRender.accept(buffer, renderEnv);
            if (!used) continue;
            RendererDispatcher.markLayerUsed(compiledChunk, optiFine, layer);
        }
    }

    public static BufferBuilder getAndStartBuffer(ChunkRenderDispatcher.ChunkRender chunkRender, ChunkRenderDispatcher.CompiledChunk compiledChunk, RegionRenderCacheBuilder buffers, RenderType layer) {
        ForgeHooksClient.setRenderLayer((RenderType)layer);
        BufferBuilder buffer = buffers.func_228366_a_(layer);
        if (compiledChunk.field_178501_c.add(layer)) {
            chunkRender.func_228923_a_(buffer);
        }
        return buffer;
    }

    static void markLayerUsed(ChunkRenderDispatcher.CompiledChunk compiledChunk, OptiFineProxy optiFine, RenderType layer) {
        compiledChunk.field_178498_d = false;
        optiFine.markRenderLayerUsed(compiledChunk, layer);
    }

    static void quad(IVertexBuilder buffer, MatrixStack matrix, Face face, Vec faceNormal, Color color, Texture uvs, FaceLight light, boolean doubleSided) {
        RendererDispatcher.quad(buffer, matrix, doubleSided, face, color, uvs, OverlayTexture.field_229196_a_, light, faceNormal);
    }

    static void quad(IVertexBuilder buffer, MatrixStack matrix, boolean doubleSided, Face face, Color color, Texture texture, int overlay, FaceLight light, Vec normal) {
        RendererDispatcher.quad(buffer, matrix, doubleSided, face.v0, color, texture.u0, texture.v0, overlay, light.v0, normal, face.v1, color, texture.u1, texture.v1, overlay, light.v1, normal, face.v2, color, texture.u2, texture.v2, overlay, light.v2, normal, face.v3, color, texture.u3, texture.v3, overlay, light.v3, normal);
    }

    static void quad(IVertexBuilder buffer, MatrixStack matrix, boolean doubleSided, Vec vec0, Color color0, float u0, float v0, int overlay0, int light0, Vec normal0, Vec vec1, Color color1, float u1, float v1, int overlay1, int light1, Vec normal1, Vec vec2, Color color2, float u2, float v2, int overlay2, int light2, Vec normal2, Vec vec3, Color color3, float u3, float v3, int overlay3, int light3, Vec normal3) {
        RendererDispatcher.quad(buffer, matrix, doubleSided, vec0.x, vec0.y, vec0.z, color0.red, color0.green, color0.blue, color0.alpha, u0, v0, overlay0, light0, normal0.x, normal0.y, normal0.z, vec1.x, vec1.y, vec1.z, color1.red, color1.green, color1.blue, color1.alpha, u1, v1, overlay1, light1, normal1.x, normal1.y, normal1.z, vec2.x, vec2.y, vec2.z, color2.red, color2.green, color2.blue, color2.alpha, u2, v2, overlay2, light2, normal2.x, normal2.y, normal2.z, vec3.x, vec3.y, vec3.z, color3.red, color3.green, color3.blue, color3.alpha, u3, v3, overlay3, light3, normal3.x, normal3.y, normal3.z);
    }

    static void quad(IVertexBuilder buffer, MatrixStack matrix, boolean doubleSided, float v0x, float v0y, float v0z, float red0, float green0, float blue0, float alpha0, float u0, float v0, int overlay0, int light0, float n0x, float n0y, float n0z, float v1x, float v1y, float v1z, float red1, float green1, float blue1, float alpha1, float u1, float v1, int overlay1, int light1, float n1x, float n1y, float n1z, float v2x, float v2y, float v2z, float red2, float green2, float blue2, float alpha2, float u2, float v2, int overlay2, int light2, float n2x, float n2y, float n2z, float v3x, float v3y, float v3z, float red3, float green3, float blue3, float alpha3, float u3, float v3, int overlay3, int light3, float n3x, float n3y, float n3z) {
        ClientUtil.vertex(buffer, matrix, v0x, v0y, v0z, red0, green0, blue0, alpha0, u0, v0, overlay0, light0, n0x, n0y, n0z);
        ClientUtil.vertex(buffer, matrix, v1x, v1y, v1z, red1, green1, blue1, alpha1, u1, v1, overlay1, light1, n1x, n1y, n1z);
        ClientUtil.vertex(buffer, matrix, v2x, v2y, v2z, red2, green2, blue2, alpha2, u2, v2, overlay2, light2, n2x, n2y, n2z);
        ClientUtil.vertex(buffer, matrix, v3x, v3y, v3z, red3, green3, blue3, alpha3, u3, v3, overlay3, light3, n3x, n3y, n3z);
        if (doubleSided) {
            ClientUtil.vertex(buffer, matrix, v3x, v3y, v3z, red3, green3, blue3, alpha3, u3, v3, overlay3, light3, n3x, n3y, n3z);
            ClientUtil.vertex(buffer, matrix, v2x, v2y, v2z, red2, green2, blue2, alpha2, u2, v2, overlay2, light2, n2x, n2y, n2z);
            ClientUtil.vertex(buffer, matrix, v1x, v1y, v1z, red1, green1, blue1, alpha1, u1, v1, overlay1, light1, n1x, n1y, n1z);
            ClientUtil.vertex(buffer, matrix, v0x, v0y, v0z, red0, green0, blue0, alpha0, u0, v0, overlay0, light0, n0x, n0y, n0z);
        }
    }

    static interface RenderInLayer {
        public boolean render(RenderType var1, BufferBuilder var2, Object var3);
    }

    public static class ChunkRenderInfo {
        public final ChunkRenderDispatcher.ChunkRender.RebuildTask rebuildTask;
        public final ChunkRenderDispatcher.ChunkRender chunkRender;
        public final ChunkRenderDispatcher.CompiledChunk compiledChunk;
        public final RegionRenderCacheBuilder buffers;
        public final BlockPos chunkPos;
        public final IBlockDisplayReader world;
        public final FluentMatrixStack matrix;
        public final Random random;
        public final BlockRendererDispatcher dispatcher;
        public final LightCache light;
        public final OptiFineProxy optiFine;
        public final BlockColors blockColors;

        public ChunkRenderInfo(ChunkRenderDispatcher.ChunkRender.RebuildTask rebuildTask, ChunkRenderDispatcher.ChunkRender chunkRender, ChunkRenderDispatcher.CompiledChunk compiledChunk, RegionRenderCacheBuilder buffers, BlockPos chunkPos, IBlockDisplayReader world, FluentMatrixStack matrix, Random random, BlockRendererDispatcher dispatcher, LightCache light, OptiFineProxy optiFine) {
            this.rebuildTask = rebuildTask;
            this.chunkRender = chunkRender;
            this.compiledChunk = compiledChunk;
            this.buffers = buffers;
            this.chunkPos = chunkPos;
            this.world = world;
            this.matrix = matrix;
            this.random = random;
            this.dispatcher = dispatcher;
            this.light = light;
            this.optiFine = optiFine;
            this.blockColors = Minecraft.func_71410_x().func_184125_al();
        }

        public void renderInLayers(Predicate<RenderType> predicate, BiFunction<RenderType, BufferBuilder, Object> preRender, RenderInLayer render, BiConsumer<BufferBuilder, Object> postRender) {
            RendererDispatcher.renderInLayers(this.chunkRender, this.compiledChunk, this.buffers, this.optiFine, predicate, preRender, render, postRender);
        }

        public Color getColor(Color color, BakedQuad quad, BlockState state, BlockPos pos, float shade) {
            if (!quad.func_178212_b()) {
                color.red = shade;
                color.green = shade;
                color.blue = shade;
                return color;
            }
            int packedColor = this.blockColors.func_228054_a_(state, this.world, pos, quad.func_178211_c());
            color.red = (float)(packedColor >> 16 & 0xFF) / 255.0f * shade;
            color.green = (float)(packedColor >> 8 & 0xFF) / 255.0f * shade;
            color.blue = (float)(packedColor & 0xFF) / 255.0f * shade;
            return color;
        }

        public void renderBlock(BlockState state, BlockPos.Mutable worldPos) {
            IModelData modelData = this.rebuildTask.getModelData((BlockPos)worldPos);
            RendererDispatcher.renderInLayers(this.chunkRender, this.compiledChunk, this.buffers, this.optiFine, layer -> RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer), (layer, buffer) -> this.optiFine.preRenderBlock(this.chunkRender, this.buffers, this.world, (RenderType)layer, (BufferBuilder)buffer, state, (BlockPos)worldPos), (layer, buffer, renderEnv) -> this.dispatcher.renderModel(state, (BlockPos)worldPos, this.world, this.matrix.matrix, (IVertexBuilder)buffer, false, this.random, modelData), (buffer, renderEnv) -> this.optiFine.postRenderBlock(renderEnv, (BufferBuilder)buffer, this.chunkRender, this.buffers, this.compiledChunk));
        }

        public float getShade(Direction direction) {
            return this.world.func_230487_a_(direction, true);
        }

        public BufferBuilder getAndStartBuffer(RenderType layer) {
            return RendererDispatcher.getAndStartBuffer(this.chunkRender, this.compiledChunk, this.buffers, layer);
        }

        public void forEachQuad(BlockState state, BlockPos worldPos, Direction direction, ColorSupplier colorSupplier, QuadConsumer action) {
            int[] numQuadsRendered = new int[]{0};
            long rand = this.optiFine.getSeed(state.func_209533_a(worldPos));
            IModelData modelData = this.rebuildTask.getModelData(worldPos);
            this.renderInLayers(layer -> RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer), (layer, buffer) -> this.optiFine.preRenderBlock(this.chunkRender, this.buffers, this.world, (RenderType)layer, (BufferBuilder)buffer, state, worldPos), (layer, buffer, renderEnv) -> {
                List<BakedQuad> dirQuads;
                IBakedModel model = this.getModel(state, renderEnv);
                List<BakedQuad> nullQuads = this.getQuadsAndStoreOverlays(state, worldPos, rand, modelData, layer, renderEnv, model, null);
                boolean anyQuadsFound = this.forEachQuad(nullQuads, state, worldPos, colorSupplier, layer, buffer, renderEnv, action);
                numQuadsRendered[0] = numQuadsRendered[0] + nullQuads.size();
                if (!state.func_235901_b_((Property)BlockStateProperties.field_208196_w)) {
                    dirQuads = this.getQuadsAndStoreOverlays(state, worldPos, rand, modelData, layer, renderEnv, model, direction);
                } else if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208196_w)).booleanValue()) {
                    dirQuads = this.getQuadsAndStoreOverlays(state, worldPos, rand, modelData, layer, renderEnv, model, NoCubesConfig.Client.betterGrassSides ? Direction.UP : direction);
                } else {
                    BlockState snow = Blocks.field_150433_aE.func_176223_P();
                    IBakedModel snowModel = this.getModel(snow, renderEnv);
                    dirQuads = this.getQuadsAndStoreOverlays(snow, worldPos, rand, modelData, layer, renderEnv, snowModel, null);
                }
                anyQuadsFound |= this.forEachQuad(dirQuads, state, worldPos, colorSupplier, layer, buffer, renderEnv, action);
                numQuadsRendered[0] = numQuadsRendered[0] + dirQuads.size();
                int numOverlaysRendered = this.optiFine.forEachOverlayQuad(this, state, worldPos, colorSupplier, action, renderEnv);
                numQuadsRendered[0] = numQuadsRendered[0] + numOverlaysRendered;
                if (!(anyQuadsFound |= numOverlaysRendered > 0)) {
                    this.forEachQuad(this.getMissingQuads(), state, worldPos, colorSupplier, layer, buffer, renderEnv, action);
                }
                return true;
            }, (buffer, renderEnv) -> this.optiFine.postRenderBlock(renderEnv, (BufferBuilder)buffer, this.chunkRender, this.buffers, this.compiledChunk));
            int quadsRendered = numQuadsRendered[0];
        }

        private IBakedModel getModel(BlockState state, Object renderEnv) {
            IBakedModel model = this.dispatcher.func_184389_a(state);
            model = this.optiFine.getModel(renderEnv, model, state);
            return model;
        }

        private List<BakedQuad> getQuadsAndStoreOverlays(BlockState state, BlockPos worldPos, long rand, IModelData modelData, RenderType layer, Object renderEnv, IBakedModel model, Direction direction) {
            this.random.setSeed(rand);
            List<BakedQuad> quads = model.getQuads(state, direction, this.random, modelData);
            quads = this.optiFine.getQuadsAndStoreOverlays(quads, this.world, state, worldPos, direction, layer, rand, renderEnv);
            return quads;
        }

        public boolean forEachQuad(List<BakedQuad> quads, BlockState state, BlockPos worldPos, ColorSupplier colorSupplier, RenderType layer, BufferBuilder buffer, Object renderEnv, QuadConsumer action) {
            int i;
            for (i = 0; i < quads.size(); ++i) {
                BakedQuad emissive;
                BakedQuad quad = quads.get(i);
                Color color = colorSupplier.apply(state, worldPos, quad);
                BakedQuad bakedQuad = emissive = this.optiFine == null ? null : this.optiFine.getQuadEmissive(quad);
                if (emissive != null) {
                    this.optiFine.preRenderQuad(renderEnv, emissive, state, worldPos);
                    action.accept(layer, (IVertexBuilder)buffer, quad, color, true);
                }
                if (this.optiFine != null) {
                    this.optiFine.preRenderQuad(renderEnv, quad, state, worldPos);
                }
                action.accept(layer, (IVertexBuilder)buffer, quad, color, false);
            }
            return i > 0;
        }

        private List<BakedQuad> getMissingQuads() {
            return this.dispatcher.func_175023_a().func_178126_b().func_174951_a().func_200117_a(Blocks.field_150350_a.func_176223_P(), null, this.random);
        }

        public static interface QuadConsumer {
            public void accept(RenderType var1, IVertexBuilder var2, BakedQuad var3, Color var4, boolean var5);
        }

        public static interface ColorSupplier {
            public Color apply(BlockState var1, BlockPos var2, BakedQuad var3);
        }
    }
}

