/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.RollingProfiler;
import io.github.cadiboo.nocubes.client.render.LightCache;
import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.config.ColorParser;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class OverlayRenderer {
    private static final RollingProfiler meshProfiler = new RollingProfiler(600);

    @SubscribeEvent
    public static void onHighlightBlock(DrawHighlightEvent.HighlightBlock event) {
        if (!NoCubesConfig.Client.render) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        BlockPos lookingAtPos = event.getTarget().func_216350_a();
        BlockState state = world.func_180495_p(lookingAtPos);
        if (!NoCubes.smoothableHandler.isSmoothable(state)) {
            return;
        }
        event.setCanceled(true);
        Vector3d camera = event.getInfo().func_216785_c();
        MatrixStack matrix = event.getMatrix();
        IVertexBuilder buffer = event.getBuffers().getBuffer(RenderType.func_228659_m_());
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        boolean stateSolidity = MeshRenderer.isSolidRender(state);
        try (Area area = new Area((IBlockReader)world, lookingAtPos, ModUtil.VEC_ONE, generator);){
            ColorParser.Color color = NoCubesConfig.Client.selectionBoxColor;
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            generator.generate(area, s -> isSmoothable.test((BlockState)s) && MeshRenderer.isSolidRender(s) == stateSolidity, (pos, face) -> {
                OverlayRenderer.drawFacePosColor(face, camera, area.start, color, buffer, matrix);
                return true;
            });
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        ColorParser.Color color;
        if (!NoCubesConfig.Client.debugEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientWorld world = minecraft.field_71441_e;
        if (world == null) {
            return;
        }
        Entity viewer = minecraft.field_71460_t.func_215316_n().func_216773_g();
        if (viewer == null) {
            return;
        }
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        Vector3d camera = minecraft.field_71460_t.func_215316_n().func_216785_c();
        MatrixStack matrixStack = event.getMatrixStack();
        IRenderTypeBuffer.Impl bufferSource = minecraft.func_228019_au_().func_228487_b_();
        IVertexBuilder bufferBuilder = bufferSource.getBuffer(RenderType.func_228659_m_());
        RayTraceResult targeted = viewer.func_213324_a(20.0, 0.0f, false);
        BlockPos targetedPos = targeted.func_216346_c() != RayTraceResult.Type.BLOCK ? viewer.func_233580_cy_() : ((BlockRayTraceResult)targeted).func_216350_a();
        Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
        if (NoCubesConfig.Client.debugOutlineSmoothables) {
            color = new ColorParser.Color(0.0f, 1.0f, 0.0f, 0.4f);
            BlockPos start = viewer.func_233580_cy_().func_177982_a(-5, -5, -5);
            BlockPos end = viewer.func_233580_cy_().func_177982_a(5, 5, 5);
            BlockPos.func_218278_a((BlockPos)start, (BlockPos)end).forEach(pos -> {
                if (isSmoothable.test(viewer.field_70170_p.func_180495_p(pos))) {
                    OverlayRenderer.drawShape(matrixStack, bufferBuilder, VoxelShapes.func_197868_b(), pos, camera, color);
                }
            });
        }
        if (NoCubesConfig.Client.debugVisualiseDensitiesGrid) {
            VoxelShape distanceIndicator = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)0.125, (double)0.125);
            ColorParser.Color densityColor = new ColorParser.Color(0.0f, 0.0f, 1.0f, 0.5f);
            try (Area area = new Area((IBlockReader)world, targetedPos.func_177982_a(-2, -2, -2), new BlockPos(4, 4, 4), generator);){
                BlockState[] states = area.getAndCacheBlocks();
                float[] densities = new float[area.numBlocks()];
                for (int i = 0; i < densities.length; ++i) {
                    densities[i] = ModUtil.getBlockDensity(isSmoothable, states[i]);
                }
                int minZ = area.start.func_177952_p();
                int minY = area.start.func_177956_o();
                int minX = area.start.func_177958_n();
                int width = area.size.func_177958_n();
                int height = area.size.func_177956_o();
                int maxZ = minZ + area.size.func_177952_p();
                int maxY = minY + height;
                int maxX = minX + width;
                int zyxIndex = 0;
                BlockPos.Mutable pos2 = new BlockPos.Mutable();
                for (int z = minZ; z < maxZ; ++z) {
                    for (int y = minY; y < maxY; ++y) {
                        int x = minX;
                        while (x < maxX) {
                            pos2.func_181079_c(x, y, z);
                            float density = densities[zyxIndex];
                            float densityScale = 0.5f + density / 2.0f;
                            if ((double)densityScale > 0.01) {
                                VoxelShape box = VoxelShapes.func_197873_a((double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)));
                                OverlayRenderer.drawShape(matrixStack, bufferBuilder, box, (BlockPos)pos2, camera, densityColor);
                            }
                            if (x > minX && y > minY && z > minZ) {
                                float combinedDensity = 0.0f;
                                int idx = zyxIndex;
                                int cornerZ = 0;
                                while (cornerZ < 2) {
                                    int cornerY = 0;
                                    while (cornerY < 2) {
                                        int cornerX = 0;
                                        while (cornerX < 2) {
                                            combinedDensity += densities[idx];
                                            cornerX = (byte)(cornerX + 1);
                                            --idx;
                                        }
                                        ++cornerY;
                                        idx -= width - 2;
                                    }
                                    ++cornerZ;
                                    idx -= width * (height - 2);
                                }
                                float combinedDensityScale = 0.5f + combinedDensity / 16.0f;
                                OverlayRenderer.drawShape(matrixStack, bufferBuilder, distanceIndicator, (BlockPos)pos2, camera, new ColorParser.Color(combinedDensityScale, 1.0f - combinedDensityScale, 0.0f, 0.4f));
                            }
                            ++x;
                            ++zyxIndex;
                        }
                    }
                }
            }
        }
        if (NoCubesConfig.Client.debugRenderCollisions) {
            ColorParser.Color intersectingColor = new ColorParser.Color(1.0f, 0.0f, 0.0f, 0.4f);
            ColorParser.Color deviatingColor = new ColorParser.Color(0.0f, 1.0f, 0.0f, 0.4f);
            VoxelShape viewerShape = VoxelShapes.func_197881_a((AxisAlignedBB)viewer.func_174813_aQ());
            world.func_226666_b_(viewer, viewer.func_174813_aQ().func_186662_g(1.0)).forEach(voxelShape -> {
                boolean intersects = VoxelShapes.func_197879_c((VoxelShape)voxelShape, (VoxelShape)viewerShape, (IBooleanFunction)IBooleanFunction.field_223238_i_);
                OverlayRenderer.drawShape(matrixStack, bufferBuilder, voxelShape, BlockPos.field_177992_a, camera, intersects ? intersectingColor : deviatingColor);
            });
        }
        if (NoCubesConfig.Client.debugRenderMeshCollisions) {
            color = new ColorParser.Color(NoCubesConfig.Client.debugRenderCollisions ? 1.0f : 0.0f, 1.0f, 0.0f, 0.4f);
            BlockPos size = new BlockPos(10, 10, 10);
            BlockPos start = viewer.func_233580_cy_().func_177982_a(-size.func_177958_n() / 2, -size.func_177956_o() / 2, -size.func_177952_p() / 2);
            try (Area area = new Area((IBlockReader)world, start, size, generator);){
                CollisionHandler.generate(area, generator, (x0, y0, z0, x1, y1, z1) -> {
                    VoxelShape voxelShape = VoxelShapes.func_197873_a((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
                    OverlayRenderer.drawShape(matrixStack, bufferBuilder, voxelShape, area.start, camera, color);
                });
            }
        }
        if (NoCubesConfig.Client.debugRecordMeshPerformance || NoCubesConfig.Client.debugOutlineNearbyMesh) {
            long startNanos = System.nanoTime();
            OverlayRenderer.drawNearbyMesh(viewer, matrixStack, camera, bufferBuilder);
            if (NoCubesConfig.Client.debugRecordMeshPerformance && meshProfiler.recordElapsedNanos(startNanos)) {
                LogManager.getLogger((String)("Calc" + (NoCubesConfig.Client.debugOutlineNearbyMesh ? " & outline" : "") + " nearby mesh")).debug("Average {}ms over the past {} frames", (Object)(meshProfiler.average() / 1000000.0), (Object)meshProfiler.size());
            }
        }
        bufferSource.func_228462_a_(RenderType.func_228659_m_());
    }

    private static void drawNearbyMesh(Entity viewer, MatrixStack matrix, Vector3d camera, IVertexBuilder buffer) {
        MeshGenerator generator = NoCubesConfig.Server.meshGenerator;
        BlockPos meshSize = new BlockPos(16, 16, 16);
        BlockPos meshStart = viewer.func_233580_cy_().func_177982_a(-meshSize.func_177958_n() / 2, -meshSize.func_177956_o() / 2 + 2, -meshSize.func_177952_p() / 2);
        try (Area area = new Area((IBlockReader)viewer.field_70170_p, meshStart, meshSize, generator);
             LightCache light = new LightCache((ClientWorld)viewer.field_70170_p, meshStart, meshSize);){
            MeshRenderer.FaceInfo faceInfo = new MeshRenderer.FaceInfo();
            MeshRenderer.MutableObjects objects = new MeshRenderer.MutableObjects();
            Vec mutable = new Vec();
            ColorParser.Color faceColor = new ColorParser.Color(0.0f, 1.0f, 1.0f, 0.4f);
            ColorParser.Color normalColor = new ColorParser.Color(0.0f, 0.0f, 1.0f, 0.2f);
            ColorParser.Color averageNormalColor = new ColorParser.Color(1.0f, 0.0f, 0.0f, 0.4f);
            ColorParser.Color normalDirectionColor = new ColorParser.Color(0.0f, 1.0f, 0.0f, 1.0f);
            ColorParser.Color lightColor = new ColorParser.Color(1.0f, 1.0f, 0.0f, 1.0f);
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            generator.generate(area, isSmoothable, (pos, face) -> {
                if (!NoCubesConfig.Client.debugOutlineNearbyMesh) {
                    return true;
                }
                OverlayRenderer.drawFacePosColor(face, camera, area.start, faceColor, buffer, matrix);
                faceInfo.setup(face);
                float dirMul = 0.2f;
                OverlayRenderer.drawLinePosColorFromAdd(area.start, faceInfo.centre, mutable.set(faceInfo.normal).multiply(0.2f), averageNormalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, faceInfo.centre, mutable.set(faceInfo.approximateDirection.func_82601_c(), faceInfo.approximateDirection.func_96559_d(), faceInfo.approximateDirection.func_82599_e()).multiply(0.2f), normalDirectionColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v0, mutable.set(faceInfo.vertexNormals.v0).multiply(0.2f), normalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v1, mutable.set(faceInfo.vertexNormals.v1).multiply(0.2f), normalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v2, mutable.set(faceInfo.vertexNormals.v2).multiply(0.2f), normalColor, buffer, matrix, camera);
                OverlayRenderer.drawLinePosColorFromAdd(area.start, face.v3, mutable.set(faceInfo.vertexNormals.v3).multiply(0.2f), normalColor, buffer, matrix, camera);
                mutable.set(0.5f, 0.5f, 0.5f);
                MeshRenderer.RenderableState.findAt(objects, area, faceInfo.normal, faceInfo.centre, isSmoothable);
                pos.func_243531_h((Vector3i)area.start);
                OverlayRenderer.drawLinePosColorFromTo(area.start, faceInfo.centre, (BlockPos)pos, mutable, lightColor, buffer, matrix, camera);
                return true;
            });
        }
    }

    private static void drawLinePosColorFromAdd(BlockPos offset, Vec start, Vec add, ColorParser.Color color, IVertexBuilder buffer, MatrixStack matrix, Vector3d camera) {
        int red = color.red;
        int blue = color.blue;
        int green = color.green;
        int alpha = color.alpha;
        float startX = (float)((double)offset.func_177958_n() - camera.field_72450_a + (double)start.x);
        float startY = (float)((double)offset.func_177956_o() - camera.field_72448_b + (double)start.y);
        float startZ = (float)((double)offset.func_177952_p() - camera.field_72449_c + (double)start.z);
        ClientUtil.vertex(buffer, matrix, startX, startY, startZ).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, startX + add.x, startY + add.y, startZ + add.z).func_225586_a_(red, green, blue, alpha).func_181675_d();
    }

    private static void drawLinePosColorFromTo(BlockPos startOffset, Vec start, BlockPos endOffset, Vec end, ColorParser.Color color, IVertexBuilder buffer, MatrixStack matrix, Vector3d camera) {
        int red = color.red;
        int blue = color.blue;
        int green = color.green;
        int alpha = color.alpha;
        ClientUtil.vertex(buffer, matrix, (float)((double)((float)startOffset.func_177958_n() + start.x) - camera.field_72450_a), (float)((double)((float)startOffset.func_177956_o() + start.y) - camera.field_72448_b), (float)((double)((float)startOffset.func_177952_p() + start.z) - camera.field_72449_c)).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, (float)((double)((float)endOffset.func_177958_n() + end.x) - camera.field_72450_a), (float)((double)((float)endOffset.func_177956_o() + end.y) - camera.field_72448_b), (float)((double)((float)endOffset.func_177952_p() + end.z) - camera.field_72449_c)).func_225586_a_(red, green, blue, alpha).func_181675_d();
    }

    private static void drawFacePosColor(Face face, Vector3d camera, BlockPos pos, ColorParser.Color color, IVertexBuilder buffer, MatrixStack matrix) {
        int red = color.red;
        int blue = color.blue;
        int green = color.green;
        int alpha = color.alpha;
        Vec v0 = face.v0;
        Vec v1 = face.v1;
        Vec v2 = face.v2;
        Vec v3 = face.v3;
        double x = (double)pos.func_177958_n() - camera.field_72450_a;
        double y = (double)pos.func_177956_o() - camera.field_72448_b;
        double z = (double)pos.func_177952_p() - camera.field_72449_c;
        float v0x = (float)(x + (double)v0.x);
        float v1x = (float)(x + (double)v1.x);
        float v2x = (float)(x + (double)v2.x);
        float v3x = (float)(x + (double)v3.x);
        float v0y = (float)(y + (double)v0.y);
        float v1y = (float)(y + (double)v1.y);
        float v2y = (float)(y + (double)v2.y);
        float v3y = (float)(y + (double)v3.y);
        float v0z = (float)(z + (double)v0.z);
        float v1z = (float)(z + (double)v1.z);
        float v2z = (float)(z + (double)v2.z);
        float v3z = (float)(z + (double)v3.z);
        ClientUtil.vertex(buffer, matrix, v0x, v0y, v0z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, v1x, v1y, v1z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, v1x, v1y, v1z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, v2x, v2y, v2z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, v2x, v2y, v2z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, v3x, v3y, v3z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, v3x, v3y, v3z).func_225586_a_(red, green, blue, alpha).func_181675_d();
        ClientUtil.vertex(buffer, matrix, v0x, v0y, v0z).func_225586_a_(red, green, blue, alpha).func_181675_d();
    }

    private static void drawShape(MatrixStack stack, IVertexBuilder buffer, VoxelShape shape, BlockPos pos, Vector3d camera, ColorParser.Color color) {
        Matrix4f pose = stack.func_227866_c_().func_227870_a_();
        double x = (double)pos.func_177958_n() - camera.field_72450_a;
        double y = (double)pos.func_177956_o() - camera.field_72448_b;
        double z = (double)pos.func_177952_p() - camera.field_72449_c;
        shape.func_197754_a((x0, y0, z0, x1, y1, z1) -> {
            ClientUtil.vertex(buffer, pose, (float)(x + x0), (float)(y + y0), (float)(z + z0)).func_225586_a_(color.red, color.green, color.blue, color.alpha).func_181675_d();
            ClientUtil.vertex(buffer, pose, (float)(x + x1), (float)(y + y1), (float)(z + z1)).func_225586_a_(color.red, color.green, color.blue, color.alpha).func_181675_d();
        });
    }

    private static /* synthetic */ void lambda$onRenderWorldLastEvent$2(Minecraft minecraft, int[] i, BlockPos pos) {
        int n = i[0];
        i[0] = n + 1;
        minecraft.field_71438_f.func_180441_b(100 + n, pos, 9);
    }
}

