/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.render.FluentMatrixStack;
import io.github.cadiboo.nocubes.client.render.RendererDispatcher;
import io.github.cadiboo.nocubes.client.render.struct.Color;
import io.github.cadiboo.nocubes.client.render.struct.FaceLight;
import io.github.cadiboo.nocubes.client.render.struct.Texture;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.MeshGenerator;
import io.github.cadiboo.nocubes.mesh.OldNoCubes;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;

public final class MeshRenderer {
    public static boolean isSolidRender(BlockState state) {
        return state.func_200015_d((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a) || state.func_177230_c() instanceof GrassPathBlock;
    }

    public static void runForSolidAndSeeThrough(Predicate<BlockState> isSmoothable, Consumer<Predicate<BlockState>> action) {
        action.accept(state -> isSmoothable.test((BlockState)state) && MeshRenderer.isSolidRender(state));
        action.accept(state -> isSmoothable.test((BlockState)state) && !MeshRenderer.isSolidRender(state));
    }

    public static void renderArea(RendererDispatcher.ChunkRenderInfo renderer, Predicate<BlockState> isSmoothableIn, MeshGenerator generator, Area area) {
        FaceInfo faceInfo = new FaceInfo();
        MutableObjects objects = new MutableObjects();
        MeshGenerator.translateToMeshStart(renderer.matrix.matrix, area.start, renderer.chunkPos);
        MeshRenderer.runForSolidAndSeeThrough(isSmoothableIn, isSmoothable -> generator.generate(area, (Predicate<BlockState>)isSmoothable, (ignored, face) -> {
            RenderableState foundState;
            faceInfo.setup(face);
            if (generator instanceof OldNoCubes) {
                foundState = objects.foundState;
                foundState.state = area.getBlockState(ignored);
                foundState.pos.func_189533_g((Vector3i)ignored);
            } else {
                foundState = RenderableState.findAt(objects, area, faceInfo.normal, faceInfo.centre, isSmoothable);
            }
            RenderableState renderState = RenderableState.findRenderFor(objects, foundState, area, faceInfo.approximateDirection);
            assert (renderState.state.func_185901_i() != BlockRenderType.INVISIBLE) : "We should not have gotten air as a renderable state";
            MeshRenderer.renderFaceWithConnectedTextures(renderer, objects, area, faceInfo, renderState);
            MeshRenderer.renderExtras(renderer, objects, area, foundState, renderState, faceInfo);
            return true;
        }));
        ForgeHooksClient.setRenderLayer(null);
    }

    static void renderBreakingTexture(BlockState state, BlockPos worldPos, MatrixStack matrix, IVertexBuilder buffer, MeshGenerator generator, Area area) {
        MeshGenerator.translateToMeshStart(matrix, area.start, worldPos);
        boolean stateSolidity = MeshRenderer.isSolidRender(state);
        Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
        FaceInfo faceInfo = new FaceInfo();
        generator.generate(area, s -> isSmoothable.test((BlockState)s) && MeshRenderer.isSolidRender(s) == stateSolidity, (relativePos, face) -> {
            faceInfo.setup(face);
            boolean renderBothSides = false;
            MeshRenderer.renderQuad(buffer, matrix, faceInfo, Color.WHITE, Texture.EVERYTHING, FaceLight.MAX_BRIGHTNESS, renderBothSides);
            return true;
        });
    }

    static void renderFaceWithConnectedTextures(RendererDispatcher.ChunkRenderInfo renderer, MutableObjects objects, Area area, FaceInfo faceInfo, RenderableState renderState) {
        BlockState state = renderState.state;
        BlockPos.Mutable worldPos = objects.pos.func_189533_g((Vector3i)renderState.relativePos()).func_243531_h((Vector3i)area.start);
        Material material = state.func_185904_a();
        boolean renderBothSides = material != Material.field_151592_s && material != Material.field_151567_E && material != Material.field_151597_y && !MeshRenderer.isSolidRender(state);
        FaceLight light = renderer.light.get(area.start, faceInfo.face, faceInfo.normal, objects.light);
        float shade = renderer.getShade(faceInfo.approximateDirection);
        renderer.forEachQuad(state, (BlockPos)worldPos, faceInfo.approximateDirection, (colorState, colorWorldPos, quad) -> renderer.getColor(objects.color, quad, colorState, colorWorldPos, shade), (layer, buffer, quad, color, emissive) -> {
            Texture texture = Texture.forQuadRearranged(objects.texture, quad, faceInfo.approximateDirection);
            MeshRenderer.renderQuad(buffer, renderer.matrix.matrix, faceInfo, color, texture, emissive ? FaceLight.MAX_BRIGHTNESS : light, renderBothSides);
        });
    }

    static void renderExtras(RendererDispatcher.ChunkRenderInfo renderer, MutableObjects objects, Area area, RenderableState foundState, RenderableState renderState, FaceInfo faceInfo) {
        BlockState stateAbove;
        boolean renderPlantsOffset = NoCubesConfig.Client.fixPlantHeight;
        boolean renderGrassTufts = NoCubesConfig.Client.grassTufts;
        if (!renderPlantsOffset && !renderGrassTufts) {
            return;
        }
        if (faceInfo.approximateDirection != Direction.UP) {
            return;
        }
        BlockPos.Mutable relativeAbove = objects.pos.func_189533_g((Vector3i)foundState.relativePos()).func_189536_c(Direction.UP);
        if (renderPlantsOffset && ModUtil.isShortPlant(stateAbove = area.getBlockState(relativeAbove))) {
            try (FluentMatrixStack ignored = renderer.matrix.push();){
                BlockPos.Mutable worldAbove = relativeAbove.func_243531_h((Vector3i)area.start);
                Vec center = faceInfo.centre;
                renderer.matrix.matrix.func_227861_a_((double)(center.x - 0.5f), (double)center.y, (double)(center.z - 0.5f));
                renderer.renderBlock(stateAbove, worldAbove);
                return;
            }
        }
        if (renderGrassTufts && foundState.state.func_235901_b_((Property)GrassBlock.field_196382_a)) {
            BlockState grass = Blocks.field_150349_c.func_176223_P();
            BlockPos.Mutable worldAbove = relativeAbove.func_243531_h((Vector3i)area.start);
            boolean renderBothSides = true;
            Vector3d offset = grass.func_191059_e((IBlockReader)renderer.world, (BlockPos)worldAbove);
            float xOff = (float)offset.field_72450_a;
            float zOff = (float)offset.field_72449_c;
            float yExt = 0.4f;
            boolean snowy = MeshRenderer.isSnow(renderState.state) || renderState.state.func_235901_b_((Property)GrassBlock.field_196382_a) && (Boolean)renderState.state.func_177229_b((Property)GrassBlock.field_196382_a) != false;
            Face face = faceInfo.face;
            FaceInfo grassTuft0 = objects.grassTuft0;
            MeshRenderer.setupGrassTuft(grassTuft0.face, face.v2, face.v0, xOff, yExt, zOff);
            FaceLight light0 = renderer.light.get(area.start, grassTuft0, objects.grassTuft0Light);
            float shade0 = renderer.getShade(grassTuft0.approximateDirection);
            FaceInfo grassTuft1 = objects.grassTuft1;
            MeshRenderer.setupGrassTuft(grassTuft1.face, face.v3, face.v1, xOff, yExt, zOff);
            FaceLight light1 = renderer.light.get(area.start, grassTuft1, objects.grassTuft1Light);
            float shade1 = renderer.getShade(grassTuft1.approximateDirection);
            MatrixStack matrix = renderer.matrix.matrix;
            renderer.forEachQuad(grass, (BlockPos)worldAbove, null, (state, worldPos, quad) -> snowy ? Color.WHITE : renderer.getColor(objects.color, quad, grass, (BlockPos)worldAbove, 1.0f), (layer, buffer, quad, color, emissive) -> {
                int argbTEMP = color.packToARGB();
                color.multiplyUNSAFENEEDSVALHALLA(shade0);
                MeshRenderer.renderQuad(buffer, matrix, grassTuft0, color, Texture.forQuadRearranged(objects.texture, quad, grassTuft0.approximateDirection), emissive ? FaceLight.MAX_BRIGHTNESS : light0, renderBothSides);
                color.unpackFromARGB(argbTEMP);
                color.multiplyUNSAFENEEDSVALHALLA(shade1);
                MeshRenderer.renderQuad(buffer, matrix, grassTuft1, color, Texture.forQuadRearranged(objects.texture, quad, grassTuft1.approximateDirection), emissive ? FaceLight.MAX_BRIGHTNESS : light1, renderBothSides);
                color.unpackFromARGB(argbTEMP);
            });
        }
    }

    private static void setupGrassTuft(Face face, Vec v0, Vec v1, float xOff, float yExt, float zOff) {
        face.set(v0, v0, v1, v1);
        face.v1.y += yExt;
        face.v2.y += yExt;
        face.add(xOff, 0.0f, zOff);
    }

    private static void renderQuad(IVertexBuilder buffer, MatrixStack matrix, FaceInfo faceInfo, Color color, Texture uvs, FaceLight light, boolean renderBothSides) {
        RendererDispatcher.quad(buffer, matrix, faceInfo.face, faceInfo.normal, color, uvs, light, renderBothSides);
    }

    private static boolean isSnow(BlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150433_aE || block == Blocks.field_196604_cC;
    }

    static final class RenderableState {
        private static final BlockPos[] OFFSETS_ORDERED = new BlockPos[]{new BlockPos(0, -1, 0), new BlockPos(0, 1, 0), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(0, 0, 1), new BlockPos(-1, -1, 0), new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, 1, 0), new BlockPos(0, -1, -1), new BlockPos(0, -1, 1), new BlockPos(0, 1, -1), new BlockPos(0, 1, 1), new BlockPos(1, -1, 0), new BlockPos(1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 1, 0), new BlockPos(1, 1, 1), new BlockPos(1, 1, -1), new BlockPos(-1, 1, 1), new BlockPos(-1, 1, -1), new BlockPos(1, -1, 1), new BlockPos(1, -1, -1), new BlockPos(-1, -1, 1), new BlockPos(-1, -1, -1)};
        private final BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockState state;

        RenderableState() {
        }

        public BlockPos relativePos() {
            return this.pos;
        }

        public static RenderableState findAt(MutableObjects objects, Area area, Vec faceNormal, Vec faceCentre, Predicate<BlockState> isSmoothable) {
            RenderableState foundState = objects.foundState;
            BlockPos.Mutable faceBlockPos = RenderableState.posForFace(objects.vec, faceNormal, faceCentre).assignTo(foundState.pos);
            BlockState state = area.getBlockState(faceBlockPos);
            assert ("true".equals("true"));
            foundState.state = state;
            return foundState;
        }

        public static RenderableState findRenderFor(MutableObjects objects, RenderableState foundState, Area area, Direction faceDirection) {
            boolean tryFindSnow;
            boolean bl = tryFindSnow = faceDirection == Direction.UP || NoCubesConfig.Client.moreSnow;
            if (!tryFindSnow) {
                return foundState;
            }
            return RenderableState.findNearbyOrDefault(foundState, objects.renderState, area, x$0 -> MeshRenderer.isSnow(x$0));
        }

        private static Vec posForFace(Vec pos, Vec faceNormal, Vec faceCentre) {
            return pos.set(faceNormal).normalise().multiply(-0.5f).add(faceCentre);
        }

        private static RenderableState findNearbyOrDefault(RenderableState original, RenderableState toUse, Area area, Predicate<BlockState> isSmoothable) {
            if (isSmoothable.test(original.state)) {
                return original;
            }
            BlockPos.Mutable origin = original.pos;
            BlockPos.Mutable relativePos = toUse.pos;
            for (BlockPos offset : OFFSETS_ORDERED) {
                relativePos.func_189533_g((Vector3i)origin).func_243531_h((Vector3i)offset);
                BlockState state = area.getBlockState(relativePos);
                if (!isSmoothable.test(state)) continue;
                toUse.state = state;
                return toUse;
            }
            return original;
        }
    }

    static final class MutableObjects {
        final FaceLight light = new FaceLight();
        final RenderableState foundState = new RenderableState();
        final RenderableState renderState = new RenderableState();
        final Vec vec = new Vec();
        final FaceInfo grassTuft0 = FaceInfo.withFace();
        final FaceLight grassTuft0Light = new FaceLight();
        final FaceInfo grassTuft1 = FaceInfo.withFace();
        final FaceLight grassTuft1Light = new FaceLight();
        final BlockPos.Mutable pos = new BlockPos.Mutable();
        final Color color = new Color();
        final Texture texture = new Texture();

        MutableObjects() {
        }
    }

    public static final class FaceInfo {
        public Face face;
        public final Vec centre = new Vec();
        public final Face vertexNormals = new Face();
        public final Vec normal = new Vec();
        public Direction approximateDirection;

        public void setup(Face face) {
            this.face = face;
            face.assignAverageTo(this.centre);
            face.assignNormalTo(this.vertexNormals);
            this.vertexNormals.multiply(-1.0f).assignAverageTo(this.normal);
            this.approximateDirection = this.normal.getDirectionFromNormal();
        }

        public static FaceInfo withFace() {
            FaceInfo faceInfo = new FaceInfo();
            faceInfo.setup(new Face());
            return faceInfo;
        }
    }
}

