/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import io.github.cadiboo.nocubes.client.render.LightCache;
import io.github.cadiboo.nocubes.client.render.struct.Color;
import io.github.cadiboo.nocubes.util.Area;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidAttributes;

public class FluidRenderer
extends FluidBlockRenderer {
    public static void render(Area area, LightCache light) {
        BlockPos size = area.size;
        int depth = size.func_177952_p();
        int height = size.func_177956_o();
        int width = size.func_177958_n();
        BlockState[] blocks = area.getAndCacheBlocks();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int index = 0;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (!FluidRenderer.isOutsideArea(x, y, z, size)) {
                        BlockState block = blocks[index];
                        FluidState fluidState = block.func_204520_s();
                    }
                    ++x;
                    ++index;
                }
            }
        }
    }

    private static boolean isOutsideArea(int x, int y, int z, BlockPos size) {
        return x < 1 || y < 1 || z < 1 || x >= size.func_177958_n() - 1 || y >= size.func_177956_o() - 1 || z >= size.func_177952_p() - 1;
    }

    private static TextureAtlasSprite[] getStaticAndFlowingSprites(FluidBlockRenderer fluidRenderer, IWorldReader world, BlockState block, FluidState fluid, BlockPos worldPos) {
        return ForgeHooksClient.getFluidSprites((IBlockDisplayReader)world, (BlockPos)worldPos, (FluidState)fluid);
    }

    private static void setColor(Color color, FluidState fluid, IBlockDisplayReader world, BlockPos worldPos) {
        FluidAttributes attributes = fluid.func_206886_c().getAttributes();
        color.unpackFromARGB(attributes.getColor(world, worldPos));
    }
}

