/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.network.C2SRequestUpdateSmoothable;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="nocubes", value={Dist.CLIENT})
public final class KeybindingHandler {
    private static final List<Pair<KeyBinding, Runnable>> KEYBINDS = new LinkedList<Pair<KeyBinding, Runnable>>();

    public static void registerKeybindings() {
        KEYBINDS.clear();
        KEYBINDS.add(KeybindingHandler.makeKeybinding("toggleVisuals", 79, KeybindingHandler::toggleVisuals));
        KEYBINDS.add(KeybindingHandler.makeKeybinding("toggleSmoothable", 78, KeybindingHandler::toggleLookedAtSmoothable));
    }

    private static Pair<KeyBinding, Runnable> makeKeybinding(String name, int key, Runnable action) {
        KeyBinding keyBinding = new KeyBinding("nocubes.key." + name, key, "nocubes.keycategory");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return Pair.of((Object)keyBinding, (Object)action);
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Pair<KeyBinding, Runnable> keybind : KEYBINDS) {
            if (!((KeyBinding)keybind.getKey()).func_151468_f()) continue;
            ((Runnable)keybind.getValue()).run();
        }
    }

    private static void toggleVisuals() {
        if (NoCubesConfig.Client.render && NoCubesConfig.Server.forceVisuals) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.notification.visualsForcedByServer").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return;
        }
        NoCubesConfig.Client.updateRender(!NoCubesConfig.Client.render);
        ClientUtil.reloadAllChunks();
    }

    private static void toggleLookedAtSmoothable() {
        boolean newValue;
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientWorld world = minecraft.field_71441_e;
        ClientPlayerEntity player = minecraft.field_71439_g;
        RayTraceResult lookingAt = minecraft.field_71476_x;
        if (world == null || player == null || lookingAt == null || lookingAt.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult lookingAtBlock = (BlockRayTraceResult)lookingAt;
        BlockState state = world.func_180495_p(lookingAtBlock.func_216350_a());
        boolean bl = newValue = !NoCubes.smoothableHandler.isSmoothable(state);
        if (!NoCubesNetwork.currentServerHasNoCubes) {
            NoCubes.smoothableHandler.setSmoothable(newValue, state);
            ClientUtil.reloadAllChunks();
        } else {
            if (!player.func_211513_k(2)) {
                return;
            }
            NoCubesNetwork.CHANNEL.sendToServer((Object)new C2SRequestUpdateSmoothable(state, newValue));
        }
    }
}

