/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public final class ClientUtil {
    public static void reloadAllChunks() {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.execute(() -> {
            WorldRenderer worldRenderer = minecraft.field_71438_f;
            if (worldRenderer != null) {
                worldRenderer.func_72712_a();
            }
        });
    }

    public static IVertexBuilder vertex(IVertexBuilder buffer, MatrixStack matrix, float x, float y, float z) {
        return ClientUtil.vertex(buffer, matrix.func_227866_c_().func_227870_a_(), x, y, z);
    }

    public static IVertexBuilder vertex(IVertexBuilder buffer, Matrix4f matrix, float x, float y, float z) {
        float transformedX = ClientUtil.getTransformX(matrix, x, y, z, 1.0f);
        float transformedY = ClientUtil.getTransformY(matrix, x, y, z, 1.0f);
        float transformedZ = ClientUtil.getTransformZ(matrix, x, y, z, 1.0f);
        return buffer.func_225582_a_((double)transformedX, (double)transformedY, (double)transformedZ);
    }

    public static void vertex(IVertexBuilder buffer, MatrixStack matrix, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        MatrixStack.Entry currentTransform = matrix.func_227866_c_();
        Matrix4f pose = currentTransform.func_227870_a_();
        Matrix3f normal = currentTransform.func_227872_b_();
        float transformedX = ClientUtil.getTransformX(pose, x, y, z, 1.0f);
        float transformedY = ClientUtil.getTransformY(pose, x, y, z, 1.0f);
        float transformedZ = ClientUtil.getTransformZ(pose, x, y, z, 1.0f);
        float transformedNormalX = ClientUtil.getTransformX(normal, normalX, normalY, normalZ);
        float transformedNormalY = ClientUtil.getTransformY(normal, normalX, normalY, normalZ);
        float transformedNormalZ = ClientUtil.getTransformZ(normal, normalX, normalY, normalZ);
        buffer.func_225588_a_(transformedX, transformedY, transformedZ, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, transformedNormalX, transformedNormalY, transformedNormalZ);
    }

    public static float getTransformX(Matrix3f matrix, float x, float y, float z) {
        return matrix.field_226097_a_ * x + matrix.field_226098_b_ * y + matrix.field_226099_c_ * z;
    }

    public static float getTransformY(Matrix3f matrix, float x, float y, float z) {
        return matrix.field_226100_d_ * x + matrix.field_226101_e_ * y + matrix.field_226102_f_ * z;
    }

    public static float getTransformZ(Matrix3f matrix, float x, float y, float z) {
        return matrix.field_226103_g_ * x + matrix.field_226104_h_ * y + matrix.field_226105_i_ * z;
    }

    public static float getTransformX(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.field_226575_a_ * x + matrix.field_226576_b_ * y + matrix.field_226577_c_ * z + matrix.field_226578_d_ * w;
    }

    public static float getTransformY(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.field_226579_e_ * x + matrix.field_226580_f_ * y + matrix.field_226581_g_ * z + matrix.field_226582_h_ * w;
    }

    public static float getTransformZ(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.field_226583_i_ * x + matrix.field_226584_j_ * y + matrix.field_226585_k_ * z + matrix.field_226586_l_ * w;
    }

    public static float getTransformW(Matrix4f matrix, float x, float y, float z, float w) {
        return matrix.field_226587_m_ * x + matrix.field_226588_n_ * y + matrix.field_226589_o_ * z + matrix.field_226590_p_ * w;
    }
}

