/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client;

import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.hooks.SelfCheck;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class ClientEventSubscriber {
    private static long selfCheckInfoPrintedAt = Long.MIN_VALUE;

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player;
        long time;
        if (!NoCubesConfig.Client.debugEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientWorld world = minecraft.field_71441_e;
        if (world == null) {
            return;
        }
        if (Screen.func_231174_t_() && (time = world.func_82737_E()) - 200L > selfCheckInfoPrintedAt) {
            selfCheckInfoPrintedAt = time;
            LogManager.getLogger((String)"NoCubes Hooks SelfCheck").debug(String.join((CharSequence)"\n", SelfCheck.info()));
        }
        if ((player = Minecraft.func_71410_x().field_71439_g) == null) {
            return;
        }
        if (NoCubesConfig.Server.collisionsEnabled && !NoCubesNetwork.currentServerHasNoCubes) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("nocubes.notification.nocubesNotInstalledOnServerCollisionsUnavailable").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            NoCubesConfig.Server.collisionsEnabled = false;
        }
    }
}

