/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lava_monster.client;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LavaMonsterModel<T extends Entity>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public LavaMonsterModel(ModelPart model) {
        this.head = model.m_171324_("head");
        this.jaw = model.m_171324_("jaw");
        this.body = model.m_171324_("body");
        this.rightFrontLeg = model.m_171324_("right_front_leg");
        this.leftFrontLeg = model.m_171324_("left_front_leg");
        this.rightHindLeg = model.m_171324_("right_hind_leg");
        this.leftHindLeg = model.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -6.0f, -8.0f, 7.0f, 6.0f, 10.0f, size), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-3.0f));
        root.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-3.0f, -1.0f, -7.0f, 6.0f, 2.0f, 7.0f, size), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-3.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 9).m_171488_(-4.5f, -10.0f, -7.0f, 9.0f, 16.0f, 7.0f, size), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)3.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, size), PartPose.m_171419_((float)-5.0f, (float)16.0f, (float)-5.0f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, size).m_171480_(), PartPose.m_171419_((float)5.0f, (float)16.0f, (float)-5.0f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, -2.0f, -3.0f, 4.0f, 10.0f, 4.0f, size), PartPose.m_171419_((float)-5.0f, (float)16.0f, (float)5.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, -2.0f, -3.0f, 4.0f, 10.0f, 4.0f, size).m_171480_(), PartPose.m_171419_((float)5.0f, (float)16.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head, (Object)this.jaw, (Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch / 57.29578f;
        this.head.f_104204_ = netHeadYaw / 57.29578f;
        this.jaw.f_104203_ = this.head.f_104203_ + 0.392699f;
        this.jaw.f_104204_ = this.head.f_104204_;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = this.rightHindLeg.f_104203_;
    }
}

