/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lava_monster;

import com.legacy.lava_monster.LavaEntityTypes;
import com.legacy.lava_monster.LavaMonsterConfig;
import com.legacy.lava_monster.entity.LavaMonsterEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClassicSpawnHandler {
    private static final int maxNumberOfCreature = 10;
    private int spawnTime = 0;
    private HashMap<ChunkPos, Boolean> eligibleChunksForSpawning = new HashMap();

    public static boolean canLavaMonsterSpawnAtLocation(Level world, BlockPos pos) {
        return (!LavaMonsterConfig.depthHazard || LavaMonsterConfig.depthHazard && pos.m_123342_() <= 16 || world.m_6042_().m_63951_()) && world.m_8055_(pos).m_60734_() == Blocks.f_49991_ && world.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_49991_;
    }

    private int performSpawning(ServerLevel world) {
        if (++this.spawnTime < LavaMonsterConfig.spawnFrequency) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        if (!world.m_6907_().isEmpty()) {
            for (Player player : world.m_6907_()) {
                int chunkX = Mth.m_14107_((double)(player.m_20185_() / 16.0));
                int chunkZ = Mth.m_14107_((double)(player.m_20189_() / 16.0));
                int spawnRange = 8;
                for (int x = -spawnRange; x <= spawnRange; ++x) {
                    for (int z = -spawnRange; z <= spawnRange; ++z) {
                        boolean isEdge = x == -spawnRange || x == spawnRange || z == -spawnRange || z == spawnRange;
                        ChunkPos chunkCoord = new ChunkPos(x + chunkX, z + chunkZ);
                        if (!isEdge) {
                            this.eligibleChunksForSpawning.put(chunkCoord, isEdge);
                            continue;
                        }
                        if (this.eligibleChunksForSpawning.containsKey(chunkCoord)) continue;
                        this.eligibleChunksForSpawning.put(chunkCoord, true);
                    }
                }
            }
        }
        int numberSpawned = 0;
        BlockPos spawnCoords = world.m_8900_();
        if (this.getLavaMonsters(world) <= 10 * this.eligibleChunksForSpawning.size() / 256) {
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>(this.eligibleChunksForSpawning.keySet());
            if (chunks.isEmpty()) {
                return numberSpawned;
            }
            Collections.shuffle(chunks);
            block3: for (ChunkPos chunkCoord : chunks) {
                if (this.eligibleChunksForSpawning.get(chunkCoord).booleanValue()) continue;
                BlockPos chunkPos = this.getRandomSpawningPointInChunk((Level)world, chunkCoord.f_45578_, chunkCoord.f_45579_);
                int x = chunkPos.m_123341_();
                int y = chunkPos.m_123342_();
                int z = chunkPos.m_123343_();
                int groupRadius = 6;
                int groupSpawnAttempt = 3;
                while (groupSpawnAttempt-- > 0) {
                    int X = x;
                    int Y = y;
                    int Z = z;
                    int spawnAttempt = 4;
                    while (spawnAttempt-- > 0) {
                        float spawnZ;
                        float spawnY;
                        float spawnX;
                        float spawnDist;
                        float posZ;
                        float posY;
                        float posX;
                        if (!ClassicSpawnHandler.canLavaMonsterSpawnAtLocation((Level)world, new BlockPos(X += world.f_46441_.nextInt(groupRadius) - world.f_46441_.nextInt(groupRadius), Y += world.f_46441_.nextInt(1) - world.f_46441_.nextInt(1), Z += world.f_46441_.nextInt(groupRadius) - world.f_46441_.nextInt(groupRadius))) || world.m_45914_((double)(posX = (float)X + 0.5f), (double)(posY = (float)Y), (double)(posZ = (float)Z + 0.5f), 24.0) || !((spawnDist = (spawnX = posX - (float)spawnCoords.m_123341_()) * spawnX + (spawnY = posY - (float)spawnCoords.m_123342_()) * spawnY + (spawnZ = posZ - (float)spawnCoords.m_123343_()) * spawnZ) >= 576.0f)) continue;
                        LavaMonsterEntity lavaMonster = new LavaMonsterEntity(LavaEntityTypes.LAVA_MONSTER, (Level)world);
                        lavaMonster.m_7678_(posX, posY, posZ, world.f_46441_.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((Mob)lavaMonster, (LevelAccessor)world, (double)posX, (double)posY, (double)posZ, null, (MobSpawnType)MobSpawnType.NATURAL);
                        if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !lavaMonster.classicSpawnRules())) continue;
                        ++numberSpawned;
                        world.m_7967_((Entity)lavaMonster);
                        if (ForgeEventFactory.doSpecialSpawn((Mob)lavaMonster, (Level)world, (float)posX, (float)posY, (float)posZ, null, null)) continue block3;
                        lavaMonster.m_6518_((ServerLevelAccessor)world, world.m_6436_(new BlockPos((double)posX, (double)posY, (double)posZ)), MobSpawnType.NATURAL, null, null);
                        continue block3;
                    }
                }
            }
        }
        return numberSpawned;
    }

    private BlockPos getRandomSpawningPointInChunk(Level world, int chunkX, int chunkZ) {
        LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
        int x = (chunkX << 4) + world.f_46441_.nextInt(16);
        int z = (chunkZ << 4) + world.f_46441_.nextInt(16);
        int y = world.f_46441_.nextInt(chunk == null ? world.m_151558_() : chunk.m_62098_() + 16 - 1);
        return new BlockPos(x, y, z);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (!LavaMonsterConfig.shouldUseVanillaSpawning && event.phase == TickEvent.Phase.START && event.world instanceof ServerLevel && event.world.m_46469_().m_46207_(GameRules.f_46134_) && event.world.m_46791_() != Difficulty.PEACEFUL) {
            this.performSpawning((ServerLevel)event.world);
        }
    }

    public int getLavaMonsters(ServerLevel world) {
        int lavaMonsters = 0;
        for (Entity entity : world.m_142646_().m_142273_()) {
            if (!(entity instanceof LavaMonsterEntity) || !entity.m_6084_()) continue;
            ++lavaMonsters;
        }
        return lavaMonsters;
    }
}

