/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.tile.hyperTransfer.base;

import com.cjm721.overloaded.storage.IHyperHandler;
import com.cjm721.overloaded.storage.IHyperType;
import com.cjm721.overloaded.tile.hyperTransfer.base.AbstractTileHyperReceiver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractTileHyperSender<T extends IHyperType, H extends IHyperHandler<T>>
extends TileEntity
implements ITickableTileEntity {
    private int delayTicks;
    private BlockPos partnerBlockPos;
    private RegistryKey<World> partnerWorldID;
    private final Capability<H> capability;

    protected AbstractTileHyperSender(TileEntityType<?> type, Capability<H> capability) {
        super(type);
        this.capability = capability;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.partnerBlockPos != null) {
            compound.func_74768_a("X", this.partnerBlockPos.func_177958_n());
            compound.func_74768_a("Y", this.partnerBlockPos.func_177956_o());
            compound.func_74768_a("Z", this.partnerBlockPos.func_177952_p());
            compound.func_74778_a("WORLD", this.partnerWorldID.func_240901_a_().toString());
        }
        return compound;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("X")) {
            int x = compound.func_74762_e("X");
            int y = compound.func_74762_e("Y");
            int z = compound.func_74762_e("Z");
            this.partnerBlockPos = new BlockPos(x, y, z);
            this.partnerWorldID = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)ResourceLocation.func_208304_a((String)compound.func_74779_i("WORLD")));
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.delayTicks % 20 == 0) {
            if (this.partnerBlockPos == null) {
                return;
            }
            AbstractTileHyperReceiver<T, H> partner = this.findPartner();
            if (partner != null) {
                this.send(partner);
            }
        }
        ++this.delayTicks;
    }

    @Nullable
    private AbstractTileHyperReceiver<T, H> findPartner() {
        ServerWorld world = this.func_145831_w().func_73046_m().func_71218_a(this.partnerWorldID);
        if (world != null && world.func_175667_e(this.partnerBlockPos)) {
            TileEntity partnerTE = world.func_175625_s(this.partnerBlockPos);
            if (partnerTE == null || !this.isCorrectPartnerType(partnerTE)) {
                this.partnerBlockPos = null;
                return null;
            }
            return (AbstractTileHyperReceiver)partnerTE;
        }
        return null;
    }

    private void send(@Nonnull AbstractTileHyperReceiver<T, H> partner) {
        for (Direction side : Direction.values()) {
            LazyOptional cap;
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177971_a(side.func_176730_m()));
            if (te == null || !(cap = te.getCapability(this.capability, side.func_176734_d())).isPresent()) continue;
            this.send(partner, te, side);
        }
    }

    private void send(@Nonnull AbstractTileHyperReceiver<T, H> partner, @Nonnull TileEntity te, @Nonnull Direction side) {
        T tookOut;
        T leftOvers;
        LazyOptional handler = te.getCapability(this.capability, side.func_176734_d());
        if (!handler.isPresent()) {
            return;
        }
        T itemStack = ((IHyperHandler)handler.orElse(null)).take(this.generate(Long.MAX_VALUE), false);
        if (((Number)itemStack.getAmount()).longValue() > 0L && (leftOvers = partner.receive(itemStack)).getAmount() != itemStack.getAmount() && ((Number)(tookOut = ((IHyperHandler)handler.orElse(null)).take(this.generate(((Number)itemStack.getAmount()).longValue() - ((Number)leftOvers.getAmount()).longValue()), true)).getAmount()).longValue() != ((Number)itemStack.getAmount()).longValue() - ((Number)leftOvers.getAmount()).longValue()) {
            throw new RuntimeException("IHyperHandler Take was not consistent");
        }
    }

    @Nonnull
    protected abstract T generate(long var1);

    protected abstract boolean isCorrectPartnerType(TileEntity var1);

    public void setPartnerInfo(String registryLocation, BlockPos partnerPos) {
        this.partnerWorldID = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)ResourceLocation.func_208304_a((String)registryLocation));
        this.partnerBlockPos = partnerPos;
    }

    @Nonnull
    public String getRightClickMessage() {
        if (this.partnerBlockPos != null) {
            return String.format("Bound to Receiver at %s %d,%d,%d", this.partnerWorldID.func_240901_a_(), this.partnerBlockPos.func_177958_n(), this.partnerBlockPos.func_177956_o(), this.partnerBlockPos.func_177952_p());
        }
        return "Not bound to anything";
    }
}

