/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.tile.functional;

import com.cjm721.overloaded.tile.ModTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemInterface
extends TileEntity
implements IItemHandler {
    private ItemStack storedItem = ItemStack.field_190927_a;

    public TileItemInterface() {
        super(ModTiles.itemInterface);
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        compound.func_218657_a("StoredItem", (INBT)this.storedItem.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        this.storedItem = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("StoredItem")));
        super.func_230337_a_(state, compound);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.storedItem;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.storedItem.func_190926_b()) {
            if (stack.func_190916_E() == 1) {
                if (!simulate) {
                    this.storedItem = stack;
                    this.updateClient();
                    this.func_70296_d();
                }
                return ItemStack.field_190927_a;
            }
            ItemStack storedCopy = stack.func_77946_l();
            storedCopy.func_190920_e(1);
            ItemStack returnCopy = stack.func_77946_l();
            returnCopy.func_190920_e(stack.func_190916_E() - 1);
            if (!simulate) {
                this.storedItem = storedCopy;
                this.updateClient();
                this.func_70296_d();
            }
            return returnCopy;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack copy = this.storedItem.func_77946_l();
        copy.func_190920_e(Math.min(copy.func_190916_E(), amount));
        if (!simulate) {
            this.storedItem.func_190920_e(this.storedItem.func_190916_E() - copy.func_190916_E());
            if (this.storedItem.func_190916_E() == 0) {
                this.storedItem = ItemStack.field_190927_a;
            }
            this.func_70296_d();
            this.updateClient();
        }
        return copy;
    }

    private void updateClient() {
        BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if ((side == Direction.UP || side == Direction.DOWN) && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> this)).cast();
        }
        LazyOptional t = this.storedItem.getCapability(cap, side);
        if (t.isPresent()) {
            return t;
        }
        return super.getCapability(cap, side);
    }

    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public void breakBlock() {
        if (!this.storedItem.func_190926_b()) {
            this.func_145831_w().func_217376_c((Entity)new ItemEntity(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.storedItem));
        }
    }
}

