/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.tile.functional;

import com.cjm721.overloaded.network.container.InstantFurnaceContainer;
import com.cjm721.overloaded.storage.crafting.FurnaceProcessor;
import com.cjm721.overloaded.tile.ModTiles;
import com.cjm721.overloaded.util.IDataUpdate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileInstantFurnace
extends LockableTileEntity
implements IDataUpdate {
    @Nonnull
    private final FurnaceProcessor processingStorage = new FurnaceProcessor(() -> ((TileInstantFurnace)this).func_145831_w(), Integer.MAX_VALUE, 9, this);
    @Nonnull
    private final LazyOptional<FurnaceProcessor> capability = LazyOptional.of(() -> this.processingStorage);

    public TileInstantFurnace() {
        super(ModTiles.instantFurnace);
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return new StringTextComponent("Instant Furnace");
    }

    @Nonnull
    protected Container func_213906_a(int id, @Nonnull PlayerInventory playerInventory) {
        return new InstantFurnaceContainer(id, playerInventory, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.capability.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                side = Direction.NORTH;
            }
            switch (side) {
                case UP: {
                    return this.capability.lazyMap(FurnaceProcessor::inputIItemHandler).cast();
                }
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    return this.capability.cast();
                }
                case DOWN: {
                    return this.capability.lazyMap(FurnaceProcessor::outputIItemHandler).cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public int func_70302_i_() {
        return this.processingStorage.getSlots();
    }

    public boolean func_191420_l() {
        return false;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return this.processingStorage.getStackInSlot(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.processingStorage.extractItem(index, count, false);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return this.processingStorage.extractItem(index, Integer.MAX_VALUE, false);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.processingStorage.setItem(index, stack);
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        throw new RuntimeException("clear is called");
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Processor")) {
            this.processingStorage.deserializeNBT((CompoundNBT)compound.func_74781_a("Processor"));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("Processor", (INBT)this.processingStorage.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void dataUpdated() {
        this.func_70296_d();
    }
}

