/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.item;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SubsetItemHandlerWrapper
implements IItemHandler {
    private final IItemHandler baseHandler;
    private final int offset;
    private final int length;

    public SubsetItemHandlerWrapper(@Nonnull IItemHandler handler, int offset, int length) {
        this.baseHandler = handler;
        this.offset = offset;
        this.length = length;
    }

    public int getSlots() {
        return this.length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.length) {
            return ItemStack.field_190927_a;
        }
        return this.baseHandler.getStackInSlot(this.offset + slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < 0 || slot >= this.length) {
            return stack;
        }
        return this.baseHandler.insertItem(this.offset + slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < 0 || slot >= this.length) {
            return ItemStack.field_190927_a;
        }
        return this.baseHandler.extractItem(this.offset + slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.baseHandler.getSlotLimit(this.offset + slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.baseHandler.isItemValid(this.offset + slot, stack);
    }
}

