/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.item;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FastItemStackQueue
implements IItemHandler {
    @Nonnull
    private final ItemStack[] storage;

    public FastItemStackQueue(int slots) {
        this.storage = new ItemStack[slots];
    }

    public int getSlots() {
        return this.storage.length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.storage[slot] == null ? ItemStack.field_190927_a : this.storage[slot];
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.storage[slot] == null) {
            if (!simulate) {
                this.storage[slot] = stack;
            }
            return ItemStack.field_190927_a;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.storage[slot], (ItemStack)stack)) {
            int newInternalCount = Math.min(this.storage[slot].func_190916_E() + stack.func_190916_E(), stack.func_77976_d());
            int returnCount = newInternalCount - this.storage[slot].func_190916_E() - stack.func_190916_E();
            if (!simulate) {
                this.storage[slot].func_190920_e(newInternalCount);
            }
            if (returnCount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack returnStack = stack.func_77946_l();
            returnStack.func_190920_e(returnCount);
            return returnStack;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.storage[slot] == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack internalStack = this.storage[slot];
        if (internalStack.func_190916_E() <= amount) {
            if (!simulate) {
                this.storage[slot] = null;
            }
            return internalStack.func_77946_l();
        }
        ItemStack toReturn = internalStack.func_77946_l();
        toReturn.func_190920_e(amount);
        if (!simulate) {
            internalStack.func_190920_e(internalStack.func_190916_E() - amount);
        }
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        return this.storage[slot] == null ? ItemStack.field_190927_a.func_77976_d() : this.storage[slot].func_77976_d();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.storage[slot] == null || ItemHandlerHelper.canItemStacksStack((ItemStack)this.storage[slot], (ItemStack)stack);
    }
}

