/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.crafting;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.storage.crafting.EnergyInventoryBasedRecipeProcessor;
import com.cjm721.overloaded.storage.item.SubsetItemHandlerWrapper;
import com.cjm721.overloaded.util.IDataUpdate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class FurnaceProcessor
extends EnergyInventoryBasedRecipeProcessor<FurnaceRecipe> {
    @Nonnull
    private final SubsetItemHandlerWrapper inputSubset;
    @Nonnull
    private final SubsetItemHandlerWrapper outputSubset;

    public FurnaceProcessor(Supplier<World> worldSupplier, int maxEnergy, int slots, @Nonnull IDataUpdate dataUpdate) {
        super(IRecipeType.field_222150_b, worldSupplier, maxEnergy, slots, dataUpdate);
        this.inputSubset = new SubsetItemHandlerWrapper((IItemHandler)this, 0, slots);
        this.outputSubset = new SubsetItemHandlerWrapper((IItemHandler)this, slots, slots);
    }

    @Override
    int energyCostPerRecipeOperation(FurnaceRecipe recipe) {
        long energy = (long)recipe.func_222137_e() * (long)OverloadedConfig.INSTANCE.productionConfig.energyPerCookTime;
        return (int)Math.min(energy, Integer.MAX_VALUE);
    }

    @Nonnull
    public IItemHandler inputIItemHandler() {
        return this.inputSubset;
    }

    @Nonnull
    public IItemHandler outputIItemHandler() {
        return this.outputSubset;
    }
}

